/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid.io;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.NoninvertibleTransformException;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.geometry.GeneralBounds;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;

public class ReadResolutionCalculator {
    static final Logger LOGGER = Logging.getLogger(ReadResolutionCalculator.class);
    static final int MAX_OVERSAMPLING_FACTOR_DEFAULT = Integer.valueOf(System.getProperty("org.geotools.coverage.max.oversample", "30"));
    static final double DELTA = 1.0E-10;
    private ReferencedEnvelope requestedBBox;
    private Rectangle requestedRasterArea;
    private AffineTransform requestedGridToWorld;
    private double[] fullResolution;
    private boolean accurateResolution;
    private boolean isFullResolutionInRequestedCRS;
    private MathTransform destinationToSourceTransform;
    private int maxOversamplingFactor = MAX_OVERSAMPLING_FACTOR_DEFAULT;

    public ReadResolutionCalculator(GridGeometry2D requestedGridGeometry, CoordinateReferenceSystem nativeCrs, double[] fullResolution) throws FactoryException {
        CoordinateReferenceSystem requestedCRS;
        Utilities.ensureNonNull((String)"gridGeometry", (Object)requestedGridGeometry);
        this.requestedBBox = new ReferencedEnvelope((Bounds)requestedGridGeometry.getEnvelope2D());
        this.requestedRasterArea = requestedGridGeometry.getGridRange2D().getBounds();
        this.requestedGridToWorld = (AffineTransform)requestedGridGeometry.getGridToCRS2D();
        this.fullResolution = fullResolution;
        if (fullResolution == null) {
            this.fullResolution = this.computeClassicResolution(this.requestedBBox);
            this.isFullResolutionInRequestedCRS = true;
        }
        if (!CRS.equalsIgnoreMetadata((Object)nativeCrs, (Object)(requestedCRS = requestedGridGeometry.getCoordinateReferenceSystem()))) {
            this.destinationToSourceTransform = CRS.findMathTransform((CoordinateReferenceSystem)requestedCRS, (CoordinateReferenceSystem)nativeCrs);
        }
    }

    public double[] computeRequestedResolution(ReferencedEnvelope readBounds) {
        try {
            if (this.requestedGridToWorld instanceof LinearTransform) {
                if (this.destinationToSourceTransform != null && !this.destinationToSourceTransform.isIdentity()) {
                    if (this.accurateResolution) {
                        return this.computeAccurateResolution(readBounds);
                    }
                    return this.computeClassicResolution(readBounds);
                }
                return new double[]{XAffineTransform.getScaleX0((AffineTransform)this.requestedGridToWorld), XAffineTransform.getScaleY0((AffineTransform)this.requestedGridToWorld)};
            }
            String arg0 = this.requestedGridToWorld.toString();
            throw new UnsupportedOperationException(MessageFormat.format("Operation \"{0}\" is unsupported.", arg0));
        }
        catch (Throwable e) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "Unable to compute requested resolution", e);
            }
            LOGGER.log(Level.WARNING, "Unable to compute requested resolution, the reader will pick the native one");
            return this.fullResolution;
        }
    }

    private double[] computeClassicResolution(ReferencedEnvelope readBounds) {
        GridToEnvelopeMapper geMapper = new GridToEnvelopeMapper((GridEnvelope)new GridEnvelope2D(this.requestedRasterArea), (Bounds)readBounds);
        AffineTransform tempTransform = geMapper.createAffineTransform();
        double scaleX = XAffineTransform.getScaleX0((AffineTransform)tempTransform);
        double scaleY = XAffineTransform.getScaleY0((AffineTransform)tempTransform);
        return new double[]{scaleX, scaleY};
    }

    private double[] computeAccurateResolution(ReferencedEnvelope readBBox) throws TransformException, NoninvertibleTransformException, FactoryException {
        boolean isReprojected = !CRS.equalsIgnoreMetadata((Object)readBBox.getCoordinateReferenceSystem(), (Object)this.requestedBBox.getCoordinateReferenceSystem());
        ReferencedEnvelope originalReadBBox = readBBox;
        if (isReprojected) {
            readBBox = readBBox.transform(this.requestedBBox.getCoordinateReferenceSystem(), true);
        }
        double resX = XAffineTransform.getScaleX0((AffineTransform)this.requestedGridToWorld);
        double resY = XAffineTransform.getScaleY0((AffineTransform)this.requestedGridToWorld);
        GeneralBounds cropBboxTarget = CRS.transform((Bounds)readBBox, (CoordinateReferenceSystem)this.requestedBBox.getCoordinateReferenceSystem());
        int NPOINTS = 36;
        double[] points = new double[72];
        for (int i = 0; i < 3; ++i) {
            double x = i == 0 ? cropBboxTarget.getMinimum(0) + resX / 2.0 : (i == 1 ? cropBboxTarget.getMedian(0) : cropBboxTarget.getMaximum(0) - resX / 2.0);
            for (int j = 0; j < 3; ++j) {
                double y = j == 0 ? cropBboxTarget.getMinimum(1) + resY / 2.0 : (j == 1 ? cropBboxTarget.getMedian(1) : cropBboxTarget.getMaximum(1) - resY / 2.0);
                int k = (i * 3 + j) * 8;
                points[k] = x - resX / 2.0;
                points[k + 1] = y;
                points[k + 2] = x + resX / 2.0;
                points[k + 3] = y;
                points[k + 4] = x;
                points[k + 5] = y - resY / 2.0;
                points[k + 6] = x;
                points[k + 7] = y + resY / 2.0;
            }
        }
        this.destinationToSourceTransform.transform(points, 0, points, 0, 36);
        double minDistance = Double.MAX_VALUE;
        for (int i = 0; i < points.length && minDistance > 0.0; i += 4) {
            double dx = points[i + 2] - points[i];
            double dy = points[i + 3] - points[i + 1];
            double d = Math.sqrt(dx * dx + dy * dy);
            if (!(d < minDistance)) continue;
            minDistance = d;
        }
        double[] fullRes = new double[]{this.fullResolution[0], this.fullResolution[1]};
        if (isReprojected && this.isFullResolutionInRequestedCRS) {
            double x0 = this.requestedBBox.getMedian(0);
            double y0 = this.requestedBBox.getMedian(1);
            double x1 = x0 + fullRes[0];
            double y1 = y0 + fullRes[1];
            GeneralBounds envelope = new GeneralBounds(new double[]{x0, y0}, new double[]{x1, y1});
            envelope = CRS.transform((MathTransform)this.destinationToSourceTransform, (Bounds)envelope);
            GridToEnvelopeMapper mapper = new GridToEnvelopeMapper((GridEnvelope)new GridEnvelope2D(0, 0, 1, 1), (Bounds)envelope);
            AffineTransform transform = mapper.createAffineTransform();
            fullRes[0] = XAffineTransform.getScaleX0((AffineTransform)transform);
            fullRes[1] = XAffineTransform.getScaleY0((AffineTransform)transform);
        }
        double[] classicRes = this.computeClassicResolution(originalReadBBox);
        double limitResX = Math.max(fullRes[0], classicRes[0]) / (double)this.maxOversamplingFactor;
        double limitResY = Math.max(fullRes[1], classicRes[1]) / (double)this.maxOversamplingFactor;
        double minDistanceX = Math.max(limitResX, minDistance);
        double minDistanceY = Math.max(limitResY, minDistance);
        return new double[]{minDistanceX, minDistanceY};
    }

    public boolean isAccurateResolution() {
        return this.accurateResolution;
    }

    public void setAccurateResolution(boolean accurateResolution) {
        this.accurateResolution = accurateResolution;
    }

    public int getMaxOversamplingFactor() {
        return this.maxOversamplingFactor;
    }

    public void setMaxOversamplingFactor(int maxOversamplingFactor) {
        this.maxOversamplingFactor = maxOversamplingFactor;
    }
}

