/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io;

import javax.imageio.ImageWriter;
import javax.imageio.event.IIOWriteProgressListener;
import javax.imageio.event.IIOWriteWarningListener;
import org.geotools.api.util.ProgressListener;
import org.geotools.image.io.BaseGridCoverageProgressAdapter;

public class GridCoverageWriterProgressAdapter
extends BaseGridCoverageProgressAdapter
implements IIOWriteProgressListener,
IIOWriteWarningListener {
    public GridCoverageWriterProgressAdapter(ProgressListener monitor, int numImages) {
        super(monitor, numImages);
    }

    public GridCoverageWriterProgressAdapter(ProgressListener monitor) {
        this(monitor, 1);
    }

    @Override
    public void warningOccurred(ImageWriter source, int imageIndex, String warning) {
        this.monitor.warningOccurred(source.getOutput().toString(), "Warning writing image:" + imageIndex, warning);
    }

    @Override
    public void imageStarted(ImageWriter source, int imageIndex) {
        if (imageIndex == 0) {
            this.monitor.started();
        }
        this.lastImageIndex = imageIndex;
        float progress = (float)this.lastImageIndex * this.progressStep * 100.0f;
        this.reportProgress(progress, source);
    }

    private void reportProgress(float progress, ImageWriter writer) {
        this.monitor.progress(progress);
        if (this.monitor.isCanceled()) {
            writer.abort();
        }
    }

    @Override
    public void imageProgress(ImageWriter source, float percentageDone) {
        float tempProgress = (float)this.lastImageIndex * this.progressStep * 100.0f + percentageDone * this.progressStep;
        if ((double)(tempProgress - this.progress) > 5.0) {
            this.reportProgress(tempProgress, source);
            this.progress = tempProgress;
        }
    }

    @Override
    public void imageComplete(ImageWriter source) {
        float progress = (float)(this.lastImageIndex + 1) * this.progressStep * 100.0f;
        this.reportProgress(progress, source);
        if (this.lastImageIndex == this.numImages - 1) {
            this.monitor.complete();
        }
    }

    @Override
    public void thumbnailStarted(ImageWriter source, int imageIndex, int thumbnailIndex) {
    }

    @Override
    public void thumbnailProgress(ImageWriter source, float percentageDone) {
    }

    @Override
    public void thumbnailComplete(ImageWriter source) {
    }

    @Override
    public void writeAborted(ImageWriter source) {
    }
}

