/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.cqljson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import org.geotools.filter.text.cqljson.ExpressionToCQL2Json;
import org.opengis.filter.And;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.BinaryLogicOperator;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNil;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import org.opengis.filter.temporal.After;
import org.opengis.filter.temporal.AnyInteracts;
import org.opengis.filter.temporal.Before;
import org.opengis.filter.temporal.Begins;
import org.opengis.filter.temporal.BegunBy;
import org.opengis.filter.temporal.BinaryTemporalOperator;
import org.opengis.filter.temporal.During;
import org.opengis.filter.temporal.EndedBy;
import org.opengis.filter.temporal.Ends;
import org.opengis.filter.temporal.Meets;
import org.opengis.filter.temporal.MetBy;
import org.opengis.filter.temporal.OverlappedBy;
import org.opengis.filter.temporal.TContains;
import org.opengis.filter.temporal.TEquals;
import org.opengis.filter.temporal.TOverlaps;

public class FilterToCQL2Json
implements FilterVisitor {
    private ObjectMapper objectMapper;
    protected static final String OP = "op";
    protected static final String ARGS = "args";

    public FilterToCQL2Json(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public Object visitNullFilter(Object extraData) {
        throw new NullPointerException("Cannot encode null as a Filter");
    }

    public Object visit(ExcludeFilter filter, Object extraData) {
        throw FilterToCQL2Json.unsupported("EXCLUDE");
    }

    public Object visit(IncludeFilter filter, Object extraData) {
        throw FilterToCQL2Json.unsupported("INCLUDE");
    }

    public Object visit(And filter, Object extraData) {
        return this.buildBinaryLogicalOperator("and", this, (BinaryLogicOperator)filter, extraData);
    }

    public Object visit(Id filter, Object extraData) {
        throw FilterToCQL2Json.unsupported("ID");
    }

    public Object visit(Not filter, Object extraData) {
        ObjectNode output = this.asObjectNode(extraData);
        ArrayNode args = this.objectMapper.createArrayNode();
        ObjectNode arg = this.objectMapper.createObjectNode();
        filter.getFilter().accept((FilterVisitor)this, (Object)arg);
        args.add((JsonNode)arg);
        output.put(OP, "not");
        output.set(ARGS, (JsonNode)args);
        return output;
    }

    public Object visit(Or filter, Object extraData) {
        if (this.isInFilter(filter)) {
            return this.buildIN(filter, extraData);
        }
        return this.buildBinaryLogicalOperator("or", this, (BinaryLogicOperator)filter, extraData);
    }

    private Object buildBinaryLogicalOperator(String operator, FilterVisitor visitor, BinaryLogicOperator filter, Object extraData) {
        ObjectNode output = this.asObjectNode(extraData);
        ArrayNode args = this.objectMapper.createArrayNode();
        List children = filter.getChildren();
        if (children != null) {
            for (Filter child : children) {
                ObjectNode arg = this.objectMapper.createObjectNode();
                child.accept(visitor, (Object)arg);
                args.add((JsonNode)arg);
            }
        }
        output.put(OP, operator);
        output.set(ARGS, (JsonNode)args);
        return output;
    }

    private Object buildBinarySpatialOperator(String spatialOperator, BinarySpatialOperator filter, Object extraData) {
        ExpressionToCQL2Json expVisitor = new ExpressionToCQL2Json(this.objectMapper);
        ObjectNode output = this.asObjectNode(extraData);
        ArrayNode args = this.objectMapper.createArrayNode();
        Expression expr1 = filter.getExpression1();
        expr1.accept((ExpressionVisitor)expVisitor, (Object)args);
        Expression expr2 = filter.getExpression2();
        expr2.accept((ExpressionVisitor)expVisitor, (Object)args);
        output.put(OP, spatialOperator);
        output.set(ARGS, (JsonNode)args);
        return output;
    }

    private Object buildBinaryTemporalOperator(BinaryTemporalOperator op, Object extraData, String opName) {
        ExpressionToCQL2Json expVisitor = new ExpressionToCQL2Json(this.objectMapper);
        ObjectNode output = this.asObjectNode(extraData);
        ArrayNode args = this.objectMapper.createArrayNode();
        op.getExpression1().accept((ExpressionVisitor)expVisitor, (Object)args);
        op.getExpression2().accept((ExpressionVisitor)expVisitor, (Object)args);
        output.put(OP, opName);
        output.set(ARGS, (JsonNode)args);
        return output;
    }

    private Object buildIN(Or filter, Object extraData) {
        ExpressionToCQL2Json exprVisitor = new ExpressionToCQL2Json(this.objectMapper);
        ObjectNode output = this.asObjectNode(extraData);
        ArrayNode args = this.objectMapper.createArrayNode();
        List children = filter.getChildren();
        PropertyIsEqualTo first = (PropertyIsEqualTo)filter.getChildren().get(0);
        Expression left = first.getExpression1();
        left.accept((ExpressionVisitor)exprVisitor, (Object)args);
        ArrayNode inMembers = this.objectMapper.createArrayNode();
        for (Filter child : children) {
            PropertyIsEqualTo propertyIsEqualTo = (PropertyIsEqualTo)child;
            Expression right = propertyIsEqualTo.getExpression2();
            right.accept((ExpressionVisitor)exprVisitor, (Object)inMembers);
        }
        args.add((JsonNode)inMembers);
        output.put(OP, "in");
        output.set(ARGS, (JsonNode)args);
        return output;
    }

    public Object visit(PropertyIsBetween filter, Object extraData) {
        ExpressionToCQL2Json exprVisitor = new ExpressionToCQL2Json(this.objectMapper);
        ObjectNode output = this.asObjectNode(extraData);
        ArrayNode args = this.objectMapper.createArrayNode();
        PropertyName propertyName = (PropertyName)filter.getExpression();
        propertyName.accept((ExpressionVisitor)exprVisitor, (Object)args);
        filter.getLowerBoundary().accept((ExpressionVisitor)exprVisitor, (Object)args);
        filter.getUpperBoundary().accept((ExpressionVisitor)exprVisitor, (Object)args);
        output.put(OP, "between");
        output.set(ARGS, (JsonNode)args);
        return output;
    }

    public Object visit(PropertyIsEqualTo filter, Object extraData) {
        ObjectNode output = this.asObjectNode(extraData);
        if (this.isRelateOperation(filter)) {
            return this.buildRelate(filter, output);
        }
        if (this.isFunctionTrue(filter, "PropertyExists", 1)) {
            return this.buildExists(filter, output);
        }
        return this.buildComparison((BinaryComparisonOperator)filter, output, "=");
    }

    private Object buildRelate(PropertyIsEqualTo filter, ObjectNode output) {
        ObjectNode functionDetails = this.objectMapper.createObjectNode();
        Function function = (Function)filter.getExpression1();
        List parameters = function.getParameters();
        Expression arg1 = (Expression)parameters.get(0);
        Expression arg2 = (Expression)parameters.get(1);
        Literal arg3 = (Literal)parameters.get(2);
        functionDetails.put("name", "RELATE");
        ArrayNode args = this.objectMapper.createArrayNode();
        ExpressionToCQL2Json visitor = new ExpressionToCQL2Json(this.objectMapper);
        arg1.accept((ExpressionVisitor)visitor, (Object)args);
        arg2.accept((ExpressionVisitor)visitor, (Object)args);
        args.add(arg3.getValue().toString());
        functionDetails.set(ARGS, (JsonNode)args);
        output.set("function", (JsonNode)functionDetails);
        return output;
    }

    private Object buildExists(PropertyIsEqualTo filter, ObjectNode output) {
        ObjectNode functionDetails = this.objectMapper.createObjectNode();
        Function function = (Function)filter.getExpression1();
        List parameters = function.getParameters();
        Literal arg = (Literal)parameters.get(0);
        functionDetails.put("name", "EXISTS");
        ArrayNode args = this.objectMapper.createArrayNode();
        args.add(arg.getValue().toString());
        functionDetails.set(ARGS, (JsonNode)args);
        output.set("function", (JsonNode)functionDetails);
        return output;
    }

    private Object buildComparison(BinaryComparisonOperator filter, ObjectNode output, String operation) {
        output.put(OP, operation);
        ExpressionToCQL2Json visitor = new ExpressionToCQL2Json(this.objectMapper);
        ArrayNode args = this.objectMapper.createArrayNode();
        filter.getExpression1().accept((ExpressionVisitor)visitor, (Object)args);
        filter.getExpression2().accept((ExpressionVisitor)visitor, (Object)args);
        output.set(ARGS, (JsonNode)args);
        return output;
    }

    private boolean isInFilter(Or filter) {
        if (filter.getChildren() == null) {
            return false;
        }
        Expression left = null;
        for (Filter child : filter.getChildren()) {
            if (child instanceof PropertyIsEqualTo) {
                PropertyIsEqualTo equal = (PropertyIsEqualTo)child;
                if (left == null) {
                    left = equal.getExpression1();
                    continue;
                }
                if (left.equals(equal.getExpression1())) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private boolean isFunctionTrue(PropertyIsEqualTo filter, String operation, int numberOfArguments) {
        if (filter.getExpression1() instanceof Function) {
            Function function = (Function)filter.getExpression1();
            List parameters = function.getParameters();
            if (parameters == null) {
                return false;
            }
            String name = function.getName();
            if (!operation.equalsIgnoreCase(name) || parameters.size() != numberOfArguments) {
                return false;
            }
        } else {
            return false;
        }
        if (filter.getExpression2() instanceof Literal) {
            Literal literal = (Literal)filter.getExpression2();
            Boolean value = (Boolean)literal.evaluate(null, Boolean.class);
            return value != null && value != false;
        }
        return false;
    }

    private boolean isRelateOperation(PropertyIsEqualTo filter) {
        if (this.isFunctionTrue(filter, "relatePattern", 3)) {
            Literal literal;
            Object value;
            Function function = (Function)filter.getExpression1();
            List parameters = function.getParameters();
            Expression param3 = (Expression)parameters.get(2);
            return !(param3 instanceof Literal) || (value = (literal = (Literal)param3).getValue()) instanceof String;
        }
        return false;
    }

    public Object visit(PropertyIsNotEqualTo filter, Object extraData) {
        ObjectNode output = this.asObjectNode(extraData);
        return this.buildComparison((BinaryComparisonOperator)filter, output, "<>");
    }

    public Object visit(PropertyIsGreaterThan filter, Object extraData) {
        ObjectNode output = this.asObjectNode(extraData);
        return this.buildComparison((BinaryComparisonOperator)filter, output, ">");
    }

    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object extraData) {
        ObjectNode output = this.asObjectNode(extraData);
        return this.buildComparison((BinaryComparisonOperator)filter, output, ">=");
    }

    public Object visit(PropertyIsLessThan filter, Object extraData) {
        ObjectNode output = this.asObjectNode(extraData);
        return this.buildComparison((BinaryComparisonOperator)filter, output, "<");
    }

    public Object visit(PropertyIsLessThanOrEqualTo filter, Object extraData) {
        ObjectNode output = this.asObjectNode(extraData);
        return this.buildComparison((BinaryComparisonOperator)filter, output, "<=");
    }

    public Object visit(PropertyIsLike filter, Object extraData) {
        ObjectNode output = this.asObjectNode(extraData);
        output.put(OP, "like");
        ArrayNode args = this.objectMapper.createArrayNode();
        Expression expr = filter.getExpression();
        expr.accept((ExpressionVisitor)new ExpressionToCQL2Json(this.objectMapper), (Object)args);
        String pattern = filter.getLiteral();
        args.add(pattern);
        output.set(ARGS, (JsonNode)args);
        return output;
    }

    public Object visit(PropertyIsNull filter, Object extraData) {
        ObjectNode output = this.asObjectNode(extraData);
        output.put(OP, "isNull");
        ArrayNode args = this.objectMapper.createArrayNode();
        Expression expr = filter.getExpression();
        expr.accept((ExpressionVisitor)new ExpressionToCQL2Json(this.objectMapper), (Object)args);
        output.set(ARGS, (JsonNode)args);
        return output;
    }

    public Object visit(PropertyIsNil filter, Object extraData) {
        ObjectNode output = this.asObjectNode(extraData);
        output.put(OP, "isNull");
        ArrayNode args = this.objectMapper.createArrayNode();
        Expression expr = filter.getExpression();
        expr.accept((ExpressionVisitor)new ExpressionToCQL2Json(this.objectMapper), (Object)args);
        output.set(ARGS, (JsonNode)args);
        return output;
    }

    public Object visit(BBOX filter, Object extraData) {
        return this.buildBinarySpatialOperator("s_intersects", (BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Beyond filter, Object extraData) {
        return this.buildBinarySpatialOperator("s_crosses", (BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Contains filter, Object extraData) {
        return this.buildBinarySpatialOperator("s_contains", (BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Crosses filter, Object extraData) {
        return this.buildBinarySpatialOperator("s_crosses", (BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Disjoint filter, Object extraData) {
        return this.buildBinarySpatialOperator("s_disjoint", (BinarySpatialOperator)filter, extraData);
    }

    public Object visit(DWithin filter, Object extraData) {
        return this.buildBinarySpatialOperator("s_within", (BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Equals filter, Object extraData) {
        return this.buildBinarySpatialOperator("s_equals", (BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Intersects filter, Object extraData) {
        return this.buildBinarySpatialOperator("s_intersects", (BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Overlaps filter, Object extraData) {
        return this.buildBinarySpatialOperator("s_overlaps", (BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Touches filter, Object extraData) {
        return this.buildBinarySpatialOperator("s_touches", (BinarySpatialOperator)filter, extraData);
    }

    public Object visit(Within filter, Object extraData) {
        return this.buildBinarySpatialOperator("s_within", (BinarySpatialOperator)filter, extraData);
    }

    public Object visit(After after, Object extraData) {
        return this.buildBinaryTemporalOperator((BinaryTemporalOperator)after, extraData, "t_after");
    }

    public Object visit(AnyInteracts anyInteracts, Object extraData) {
        return this.buildBinaryTemporalOperator((BinaryTemporalOperator)anyInteracts, extraData, "t_intersects");
    }

    public Object visit(Before before, Object extraData) {
        return this.buildBinaryTemporalOperator((BinaryTemporalOperator)before, extraData, "t_before");
    }

    public Object visit(Begins begins, Object extraData) {
        return this.buildBinaryTemporalOperator((BinaryTemporalOperator)begins, extraData, "t_starts");
    }

    public Object visit(BegunBy begunBy, Object extraData) {
        return this.buildBinaryTemporalOperator((BinaryTemporalOperator)begunBy, extraData, "t_startedBy");
    }

    public Object visit(During during, Object extraData) {
        return this.buildBinaryTemporalOperator((BinaryTemporalOperator)during, extraData, "t_during");
    }

    public Object visit(EndedBy endedBy, Object extraData) {
        return this.buildBinaryTemporalOperator((BinaryTemporalOperator)endedBy, extraData, "t_finishedBy");
    }

    public Object visit(Ends ends, Object extraData) {
        return this.buildBinaryTemporalOperator((BinaryTemporalOperator)ends, extraData, "t_finishes");
    }

    public Object visit(Meets meets, Object extraData) {
        return this.buildBinaryTemporalOperator((BinaryTemporalOperator)meets, extraData, "t_meets");
    }

    public Object visit(MetBy metBy, Object extraData) {
        return this.buildBinaryTemporalOperator((BinaryTemporalOperator)metBy, extraData, "t_metBy");
    }

    public Object visit(OverlappedBy overlappedBy, Object extraData) {
        return this.buildBinaryTemporalOperator((BinaryTemporalOperator)overlappedBy, extraData, "t_overlappedBy");
    }

    public Object visit(TContains contains, Object extraData) {
        return this.buildBinaryTemporalOperator((BinaryTemporalOperator)contains, extraData, "t_contains");
    }

    public Object visit(TEquals equals, Object extraData) {
        return this.buildBinaryTemporalOperator((BinaryTemporalOperator)equals, extraData, "t_equals");
    }

    public Object visit(TOverlaps contains, Object extraData) {
        return this.buildBinaryTemporalOperator((BinaryTemporalOperator)contains, extraData, "t_overlaps");
    }

    private ObjectNode asObjectNode(Object extraData) {
        if (extraData instanceof ObjectNode) {
            return (ObjectNode)extraData;
        }
        return this.objectMapper.createObjectNode();
    }

    private static UnsupportedOperationException unsupported(String filterName) {
        return new UnsupportedOperationException("The" + filterName + " has not an CQL2 expression");
    }
}

