/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.cql2;

import java.util.List;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.FilterFactoryImpl;
import org.geotools.filter.IsNullImpl;
import org.geotools.filter.function.FilterFunction_relatePattern;
import org.geotools.filter.function.PropertyExistsFunction;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.referencing.CRS;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.DistanceBufferOperator;
import org.opengis.filter.temporal.Before;
import org.opengis.referencing.FactoryException;

public class CQLTest {
    @Test
    public void betweenPredicate() throws CQLException {
        Filter filter = CQL.toFilter((String)"QUANTITY BETWEEN 10 AND 20");
        Assert.assertTrue((boolean)(filter instanceof PropertyIsBetween));
    }

    @Test
    public void comparisonPredicate() throws Exception {
        Filter filter = CQL.toFilter((String)"POP_RANK > 6");
        Assert.assertTrue((boolean)(filter instanceof PropertyIsGreaterThan));
    }

    @Test
    public void geoOperationPredicate() throws CQLException {
        Filter filter = CQL.toFilter((String)"DISJOINT(the_geom, POINT(1 2))");
        Assert.assertTrue((String)"Disjoint was expected", (boolean)(filter instanceof Disjoint));
    }

    @Test
    public void relateGeoOperation() throws CQLException {
        PropertyIsEqualTo filter = (PropertyIsEqualTo)CQL.toFilter((String)"RELATE(geometry, LINESTRING (-134.921387 58.687767, -135.303391 59.092838), T*****FF*)");
        Assert.assertTrue((String)"Relate Pattern Function was expected", (boolean)(filter.getExpression1() instanceof FilterFunction_relatePattern));
        Assert.assertTrue((String)"Literal TRUE was expected", (boolean)(filter.getExpression2() instanceof Literal));
    }

    @Test
    public void dwithinGeometry() throws Exception {
        Filter resultFilter = CQL.toFilter((String)"DWITHIN(the_geom, POINT(1 2), 10, kilometers)");
        Assert.assertTrue((boolean)(resultFilter instanceof DistanceBufferOperator));
    }

    @Test
    public void temporalPredicate() throws Exception {
        Filter filter = CQL.toFilter((String)"DATE BEFORE 2006-12-31T01:30:00Z");
        Assert.assertTrue((boolean)(filter instanceof Before));
    }

    @Test
    public void booleanPredicate() throws Exception {
        Filter filter = CQL.toFilter((String)"QUANTITY < 10 AND QUANTITY < 2 ");
        Assert.assertTrue((boolean)(filter instanceof And));
        filter = CQL.toFilter((String)"QUANTITY < 10 OR QUANTITY < 2 ");
        Assert.assertTrue((boolean)(filter instanceof Or));
        filter = CQL.toFilter((String)"NOT QUANTITY < 10");
        Assert.assertTrue((boolean)(filter instanceof Not));
    }

    @Test
    public void likePredicate() throws Exception {
        Filter filter = CQL.toFilter((String)"NAME like '%new%'");
        Assert.assertTrue((boolean)(filter instanceof PropertyIsLike));
    }

    @Test
    public void isNullPredicate() throws Exception {
        Filter filter = CQL.toFilter((String)"SHAPE IS NULL");
        Assert.assertTrue((boolean)(filter instanceof IsNullImpl));
    }

    @Test
    public void existProperty() throws Exception {
        Filter resultFilter = CQL.toFilter((String)"NAME EXISTS");
        Assert.assertTrue((boolean)(resultFilter instanceof PropertyIsEqualTo));
        PropertyIsEqualTo eq = (PropertyIsEqualTo)resultFilter;
        Expression expr = eq.getExpression1();
        Assert.assertTrue((boolean)(expr instanceof PropertyExistsFunction));
    }

    @Test
    public void addExpression() throws Exception {
        Expression expr = CQL.toExpression((String)"QUANTITY + 1");
        Assert.assertTrue((boolean)(expr instanceof Add));
    }

    @Test
    public void listOfPredicates() throws Exception {
        List list = CQL.toFilterList((String)"QUANTITY=1; YEAR<1963");
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)(list.get(0) instanceof PropertyIsEqualTo));
        Assert.assertTrue((boolean)(list.get(1) instanceof PropertyIsLessThan));
    }

    @Test
    public void filterListToCQL() throws Exception {
        String expectedCQL = "QUANTITY = 1; YEAR < 1963";
        List list = CQL.toFilterList((String)expectedCQL);
        Assert.assertEquals((long)2L, (long)list.size());
        String cqlResult = CQL.toCQL((List)list);
        Assert.assertEquals((Object)expectedCQL, (Object)cqlResult);
    }

    @Test
    public void filterToCQL() throws Exception {
        String expectedCQL = "QUANTITY = 1";
        Filter list = CQL.toFilter((String)expectedCQL);
        String cqlResult = CQL.toCQL((Filter)list);
        Assert.assertEquals((Object)expectedCQL, (Object)cqlResult);
    }

    @Test
    public void expressionToCQLExpression() throws Exception {
        String expectedCQL = "abs(-10) + 1";
        Expression list = CQL.toExpression((String)expectedCQL);
        String cqlResult = CQL.toCQL((Expression)list);
        Assert.assertEquals((Object)expectedCQL, (Object)cqlResult);
    }

    @Test
    public void toFilterUsesProvidedFilterFactory() throws Exception {
        final boolean[] called = new boolean[]{false};
        FilterFactoryImpl ff = new FilterFactoryImpl(){

            public PropertyName property(String propName) {
                called[0] = true;
                return super.property(propName);
            }
        };
        CQL.toFilter((String)"attName > 20", (FilterFactory)ff);
        Assert.assertTrue((String)"Provided FilterFactory was not called", (boolean)called[0]);
    }

    @Test
    public void toExpressionUsesProvidedFilterFactory() throws Exception {
        final boolean[] called = new boolean[]{false};
        FilterFactoryImpl ff = new FilterFactoryImpl(){

            public PropertyName property(String propName) {
                called[0] = true;
                return super.property(propName);
            }
        };
        CQL.toExpression((String)"attName", (FilterFactory)ff);
        Assert.assertTrue((String)"Provided FilterFactory was not called", (boolean)called[0]);
    }

    @Test
    public void testEWKTEncodingDisabled() throws Exception {
        Literal literalGeometry = this.getWgs84PointLiteral();
        String cql = CQL.toCQL((Expression)literalGeometry);
        Assert.assertEquals((Object)"POINT (1 2)", (Object)cql);
    }

    private Literal getWgs84PointLiteral() throws FactoryException {
        Point p = new GeometryFactory().createPoint(new Coordinate(1.0, 2.0));
        p.setUserData((Object)CRS.decode((String)"EPSG:4326", (boolean)true));
        return CommonFactoryFinder.getFilterFactory2().literal((Object)p);
    }
}

