/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.ecql;

import java.awt.RenderingHints;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.text.commons.CompilerUtil;
import org.geotools.filter.text.commons.ExpressionToText;
import org.geotools.filter.text.commons.Language;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.cql2.CQLLiteralTest;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.filter.text.ecql.FilterToECQL;
import org.geotools.referencing.CRS;
import org.geotools.util.factory.Hints;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Intersects;
import org.opengis.referencing.FactoryException;

public class ECQLLiteralTest
extends CQLLiteralTest {
    public static final int WGS84 = 4326;
    private FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();

    public ECQLLiteralTest() {
        super(Language.ECQL);
    }

    @Test
    public void lineString() throws Exception {
        String wkt = "LINESTRING (1 2, 3 4)";
        this.assertParseReferencedAndUnreferenced(wkt, LineString.class);
    }

    @Test
    public void point() throws Exception {
        String wkt = "POINT(1 2)";
        this.assertParseReferencedAndUnreferenced(wkt, Point.class);
    }

    @Test
    public void polygon() throws Exception {
        String wkt = "POLYGON((1 2, 15 2, 15 20, 15 21, 1 2))";
        this.assertParseReferencedAndUnreferenced(wkt, Polygon.class);
    }

    @Test
    public void polygonWithHole() throws Exception {
        String wkt = "POLYGON ((40 60, 420 60, 420 320, 40 320, 40 60), (200 140, 160 220, 260 200, 200 140))";
        this.assertParseReferencedAndUnreferenced(wkt, Polygon.class);
    }

    @Test
    public void multiPoint() throws Exception {
        String wkt = "MULTIPOINT( (1 2), (15 2), (15 20), (15 21), (1 2))";
        String expectedWkt = "MULTIPOINT(1 2, 15 2, 15 20, 15 21, 1 2)";
        this.assertParseReferencedAndUnreferenced(wkt, expectedWkt, MultiPoint.class, null);
        this.assertParseReferencedAndUnreferenced(wkt, expectedWkt, MultiPoint.class, 4326);
    }

    @Test
    public void multiLineString() throws Exception {
        String wkt = "MULTILINESTRING((10 10, 20 20),(15 15,30 15))";
        this.assertParseReferencedAndUnreferenced(wkt, MultiLineString.class);
    }

    @Test
    public void geometryCollection() throws Exception {
        String wkt = "GEOMETRYCOLLECTION (POINT (10 10),POINT (30 30),LINESTRING (15 15, 20 20))";
        this.assertParseReferencedAndUnreferenced(wkt, GeometryCollection.class);
    }

    @Test
    public void multiPolygon() throws Exception {
        String wkt = "MULTIPOLYGON( ((10 10, 10 20, 20 20, 20 15, 10 10)),((60 60, 70 70, 80 60, 60 60 )) )";
        this.assertParseReferencedAndUnreferenced(wkt, MultiPolygon.class);
    }

    private void assertParseReferencedAndUnreferenced(String wkt, Class<? extends Geometry> type) throws Exception {
        this.assertParseReferencedAndUnreferenced(wkt, type, null);
        this.assertParseReferencedAndUnreferenced(wkt, type, 4326);
    }

    private void assertParseReferencedAndUnreferenced(String wkt, Class expectedGeometryClass, Integer srid) throws Exception {
        this.assertParseReferencedAndUnreferenced(wkt, wkt, expectedGeometryClass, srid);
    }

    private void assertParseReferencedAndUnreferenced(String wkt, String expectedWkt, Class expectedGeometryClass, Integer srid) throws Exception {
        Object sridPrefix = srid != null ? "SRID=" + srid + ";" : "";
        Expression expression = CompilerUtil.parseExpression((Language)this.language, (String)((String)sridPrefix + wkt));
        MatcherAssert.assertThat((Object)expression, (Matcher)CoreMatchers.instanceOf(Literal.class));
        Literal literal = (Literal)expression;
        Object actualGeometry = literal.getValue();
        MatcherAssert.assertThat((Object)actualGeometry, (Matcher)CoreMatchers.instanceOf((Class)expectedGeometryClass));
        if (srid != null) {
            this.assertEqualsReferencedGeometries(expectedWkt, (Geometry)actualGeometry, 4326);
        } else {
            this.assertEqualsGeometries(expectedWkt, (Geometry)actualGeometry);
        }
    }

    @Test
    public void testParseInvalidSRID() throws Exception {
        String wkt = "SRID=12345678987654321;POINT(1 2)";
        try {
            CompilerUtil.parseExpression((Language)this.language, (String)wkt);
        }
        catch (CQLException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"Failed to build CRS"), (Matcher)CoreMatchers.containsString((String)"12345678987654321")));
        }
    }

    @Test
    public void testEncodeEWKTControlOnExpression() throws Exception {
        Literal literalGeometry = this.getWgs84PointLiteral();
        String cql1 = this.expressionToText(literalGeometry, false);
        Assert.assertEquals((Object)"POINT (1 2)", (Object)cql1);
        String cql2 = this.expressionToText(literalGeometry, true);
        Assert.assertEquals((Object)"SRID=4326;POINT (1 2)", (Object)cql2);
    }

    @Test
    public void testEncodeEWKTControlOnIntersects() throws Exception {
        Literal literalGeometry = this.getWgs84PointLiteral();
        Intersects intersects = this.ff.intersects((Expression)this.ff.property("the_geom"), (Expression)literalGeometry);
        String cql1 = this.filterToText((Filter)intersects, false);
        Assert.assertEquals((Object)"INTERSECTS(the_geom, POINT (1 2))", (Object)cql1);
        String cql2 = this.filterToText((Filter)intersects, true);
        Assert.assertEquals((Object)"INTERSECTS(the_geom, SRID=4326;POINT (1 2))", (Object)cql2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEncodeEWKTControlOnIntersectsWithHints() throws Exception {
        Literal literalGeometry = this.getWgs84PointLiteral();
        Intersects intersects = this.ff.intersects((Expression)this.ff.property("the_geom"), (Expression)literalGeometry);
        Hints.putSystemDefault((RenderingHints.Key)Hints.ENCODE_EWKT, (Object)false);
        try {
            String cql1 = ECQL.toCQL((Filter)intersects);
            Assert.assertEquals((Object)"INTERSECTS(the_geom, POINT (1 2))", (Object)cql1);
        }
        finally {
            Hints.putSystemDefault((RenderingHints.Key)Hints.ENCODE_EWKT, (Object)true);
        }
        String cql2 = this.filterToText((Filter)intersects, true);
        Assert.assertEquals((Object)"INTERSECTS(the_geom, SRID=4326;POINT (1 2))", (Object)cql2);
    }

    @Test
    public void testEncodeEWKTControlOnDWithin() throws Exception {
        Literal literalGeometry = this.getWgs84PointLiteral();
        DWithin dwithin = this.ff.dwithin((Expression)this.ff.property("the_geom"), (Expression)literalGeometry, 10.0, "m");
        String cql1 = this.filterToText((Filter)dwithin, false);
        Assert.assertEquals((Object)"DWITHIN(the_geom, POINT (1 2), 10.0, m)", (Object)cql1);
        String cql2 = this.filterToText((Filter)dwithin, true);
        Assert.assertEquals((Object)"DWITHIN(the_geom, SRID=4326;POINT (1 2), 10.0, m)", (Object)cql2);
    }

    @Test
    public void testEncodeEWKTControlOnBeyond() throws Exception {
        Literal literalGeometry = this.getWgs84PointLiteral();
        Beyond beyond = this.ff.beyond((Expression)this.ff.property("the_geom"), (Expression)literalGeometry, 10.0, "m");
        String cql1 = this.filterToText((Filter)beyond, false);
        Assert.assertEquals((Object)"BEYOND(the_geom, POINT (1 2), 10.0, m)", (Object)cql1);
        String cql2 = this.filterToText((Filter)beyond, true);
        Assert.assertEquals((Object)"BEYOND(the_geom, SRID=4326;POINT (1 2), 10.0, m)", (Object)cql2);
    }

    private Literal getWgs84PointLiteral() throws FactoryException {
        Point p = new GeometryFactory().createPoint(new Coordinate(1.0, 2.0));
        p.setUserData((Object)CRS.decode((String)"EPSG:4326", (boolean)true));
        return this.ff.literal((Object)p);
    }

    private String expressionToText(Literal literalGeometry, boolean encodeEWKT) {
        ExpressionToText encoder = new ExpressionToText(encodeEWKT);
        StringBuilder sb = new StringBuilder();
        literalGeometry.accept((ExpressionVisitor)encoder, (Object)sb);
        return sb.toString();
    }

    private String filterToText(Filter filter, boolean encodeEWKT) {
        FilterToECQL encoder = new FilterToECQL(encodeEWKT);
        StringBuilder sb = new StringBuilder();
        filter.accept((FilterVisitor)encoder, (Object)sb);
        return sb.toString();
    }
}

