/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.cql2;

import org.geotools.api.filter.Filter;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.filter.spatial.Contains;
import org.geotools.api.filter.spatial.Crosses;
import org.geotools.api.filter.spatial.Disjoint;
import org.geotools.api.filter.spatial.Equals;
import org.geotools.api.filter.spatial.Intersects;
import org.geotools.api.filter.spatial.Overlaps;
import org.geotools.api.filter.spatial.Touches;
import org.geotools.api.filter.spatial.Within;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.api.referencing.FactoryException;
import org.geotools.filter.function.FilterFunction_relatePattern;
import org.geotools.filter.text.commons.CompilerUtil;
import org.geotools.filter.text.commons.Language;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.junit.Assert;
import org.junit.Test;

public class CQLGeoOperationTest {
    protected final Language language;

    public CQLGeoOperationTest() {
        this(Language.CQL);
    }

    protected CQLGeoOperationTest(Language language) {
        assert (language != null) : "language cannot be null value";
        this.language = language;
    }

    @Test
    public void disjoint() throws CQLException {
        Filter resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"DISJOINT(ATTR1, POINT(1 2))");
        Assert.assertTrue((String)"Disjoint was expected", (boolean)(resultFilter instanceof Disjoint));
    }

    @Test
    public void Intersects() throws CQLException {
        Filter resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"INTERSECTS(ATTR1, POINT(1 2))");
        Assert.assertTrue((String)"Intersects was expected", (boolean)(resultFilter instanceof Intersects));
        resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"INTERSECTS(GEOLOC, POINT(615358 312185))");
        Assert.assertTrue((String)"Intersects was expected", (boolean)(resultFilter instanceof Intersects));
    }

    @Test
    public void relate() throws CQLException {
        PropertyIsEqualTo resultFilter = (PropertyIsEqualTo)CompilerUtil.parseFilter((Language)this.language, (String)"RELATE(the_geom, LINESTRING (-134.921387 58.687767, -135.303391 59.092838), T*****FF*)");
        Expression relateFunction = resultFilter.getExpression1();
        Assert.assertTrue((boolean)(relateFunction instanceof FilterFunction_relatePattern));
        Literal trueLiteral = (Literal)resultFilter.getExpression2();
        Assert.assertTrue((boolean)(trueLiteral.getValue() instanceof Boolean));
    }

    @Test
    public void relatePatterns() throws CQLException {
        this.testRelatePatten("T******F*");
        this.testRelatePatten("T012**FF*");
        this.testRelatePatten("100000001");
        this.testRelatePatten("200000000");
    }

    private void testRelatePatten(String pattern) throws CQLException {
        PropertyIsEqualTo resultFilter = (PropertyIsEqualTo)CompilerUtil.parseFilter((Language)this.language, (String)("RELATE(the_geom, LINESTRING (-134.921387 58.687767, -135.303391 59.092838), " + pattern + ")"));
        Expression relateFunction = resultFilter.getExpression1();
        Assert.assertTrue((boolean)(relateFunction instanceof FilterFunction_relatePattern));
        Literal trueLiteral = (Literal)resultFilter.getExpression2();
        Assert.assertTrue((boolean)(trueLiteral.getValue() instanceof Boolean));
    }

    @Test(expected=CQLException.class)
    public void relateBadLongitudInPattern() throws CQLException {
        CQL.toFilter((String)"RELATE(geometry, LINESTRING (-134.921387 58.687767, -135.303391 59.092838), **1******T)");
    }

    @Test(expected=CQLException.class)
    public void relateIlegalPattern() throws CQLException {
        CQL.toFilter((String)"RELATE(geometry, LINESTRING (-134.921387 58.687767, -135.303391 59.092838), **1*****X)");
    }

    @Test(expected=CQLException.class)
    public void invalidGeoOperation() throws CQLException {
        CompilerUtil.parseFilter((Language)this.language, (String)"INTERSECT(ATTR1, POINT(1 2))");
    }

    @Test
    public void invalidSyntaxMessage() throws CQLException {
        try {
            CompilerUtil.parseFilter((Language)this.language, (String)"INTERSECT(ATTR1, POINT(1 2))");
            Assert.fail((String)"CQLException is expected");
        }
        catch (CQLException e) {
            String error = e.getSyntaxError();
            Assert.assertNotNull((Object)error);
            Assert.assertNotEquals((Object)"", (Object)error);
        }
    }

    @Test
    public void touches() throws CQLException {
        Filter resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"TOUCHES(ATTR1, POINT(1 2))");
        Assert.assertTrue((String)"Touches was expected", (boolean)(resultFilter instanceof Touches));
    }

    @Test
    public void crosses() throws CQLException {
        Filter resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"CROSSES(ATTR1, POINT(1 2))");
        Assert.assertTrue((String)"Crosses was expected", (boolean)(resultFilter instanceof Crosses));
    }

    @Test
    public void contains() throws CQLException {
        Filter resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"CONTAINS(ATTR1, POINT(1 2))");
        Assert.assertTrue((String)"Contains was expected", (boolean)(resultFilter instanceof Contains));
    }

    @Test
    public void overlaps() throws Exception {
        Filter resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"OVERLAPS(ATTR1, POINT(1 2))");
        Assert.assertTrue((String)"Overlaps was expected", (boolean)(resultFilter instanceof Overlaps));
    }

    @Test
    public void equals() throws CQLException {
        Filter resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"EQUALS(ATTR1, POINT(1 2))");
        Assert.assertTrue((String)"not an instance of Equals", (boolean)(resultFilter instanceof Equals));
    }

    @Test
    public void within() throws CQLException {
        Filter resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"WITHIN(ATTR1, POLYGON((1 2, 1 10, 5 10, 1 2)) )");
        Assert.assertTrue((String)"Within was expected", (boolean)(resultFilter instanceof Within));
    }

    @Test
    public void bbox() throws CQLException, FactoryException {
        Filter resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"BBOX(ATTR1, 10.0,20.0,30.0,40.0)");
        Assert.assertTrue((String)"BBox was expected", (boolean)(resultFilter instanceof BBOX));
        BBOX bboxFilter = (BBOX)resultFilter;
        Assert.assertTrue((boolean)JTS.equals((BoundingBox)new ReferencedEnvelope(10.0, 30.0, 20.0, 40.0, null), (BoundingBox)bboxFilter.getBounds(), (double)0.1));
        resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"BBOX(ATTR1, 10.0,20.0,30.0,40.0, 'EPSG:4326')");
        Assert.assertTrue((String)"BBox was expected", (boolean)(resultFilter instanceof BBOX));
        bboxFilter = (BBOX)resultFilter;
        Assert.assertEquals((Object)CRS.decode((String)"EPSG:4326", (boolean)false), (Object)bboxFilter.getBounds().getCoordinateReferenceSystem());
    }
}

