/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.cql2;

import org.geotools.api.filter.expression.PropertyName;
import org.geotools.filter.text.commons.CompilerUtil;
import org.geotools.filter.text.commons.Language;
import org.geotools.filter.text.cql2.CQLException;
import org.junit.Assert;
import org.junit.Test;

public class CQLAttributeNameTest {
    protected final Language language;

    public CQLAttributeNameTest() {
        this(Language.CQL);
    }

    protected CQLAttributeNameTest(Language language) {
        assert (language != null) : "language cannot be null value";
        this.language = language;
    }

    @Test
    public void simpleAttribute() throws CQLException {
        this.testAttribute("startPart");
    }

    @Test
    public void simpleAttribureWithColon() throws CQLException {
        this.testAttribute("startpart:part1:part2");
    }

    @Test
    public void compoundAttributeName() throws CQLException {
        this.testAttribute("s11:p12:p13.s21:p22.s31:p32");
        this.testAttribute("gmd:MD_Metadata.gmd:identificationInfo.gmd:MD_DataIdentification.gmd:abstract");
    }

    @Test(expected=CQLException.class)
    public void invalidAttribute() throws CQLException {
        this.testAttribute("1startPart");
        this.testAttribute("startpart part1");
    }

    @Test
    public void keywordAsAttribute() throws CQLException {
        this.testAttributeBetweenDoubleQuotes("\"LIKE\"");
        this.testAttributeBetweenDoubleQuotes("\"AND\"");
        this.testAttributeBetweenDoubleQuotes("\"OR\"");
    }

    @Test
    public void localCharactersetInAttributeName() throws CQLException {
        this.testAttributeBetweenDoubleQuotes("\"poblaci\u00f3n\"");
        this.testAttributeBetweenDoubleQuotes("\"reconna\u00eetre\"");
        this.testAttributeBetweenDoubleQuotes("\"k\u00f6nnen\"");
        this.testAttributeBetweenDoubleQuotes("\"\u0414\u041e\u0411\u0420\u0418\u0427\"");
        this.testAttributeBetweenDoubleQuotes("\"\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435\"");
        this.testAttributeBetweenDoubleQuotes("\"\u0444\u0430\u043c\u0438\u043b\u0438\u044f\"");
        this.testAttributeBetweenDoubleQuotes("\"\u0441\u0440\u0435\u0434\u044b\"");
        this.testAttributeBetweenDoubleQuotes("\"\u540d\"");
        this.testAttributeBetweenDoubleQuotes("\"\u59d3\"");
        this.testAttributeBetweenDoubleQuotes("\"\u74b0\u5883\"");
    }

    protected void testAttributeBetweenDoubleQuotes(String attSample) throws CQLException {
        PropertyName attResult = this.parsePropertyName(attSample);
        String expected = attSample.replace('.', '/');
        expected = expected.substring(1, expected.length() - 1);
        String propertyName = attResult.getPropertyName();
        Assert.assertEquals((Object)expected, (Object)propertyName);
    }

    private void testAttribute(String attSample) throws CQLException {
        PropertyName attResult = this.parsePropertyName(attSample);
        String expected = attSample.replace('.', '/');
        Assert.assertEquals((Object)expected, (Object)attResult.getPropertyName());
    }

    protected PropertyName parsePropertyName(String attSample) throws CQLException {
        return (PropertyName)CompilerUtil.parseExpression((Language)this.language, (String)attSample);
    }
}

