/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.cql2;

import org.geotools.api.filter.Filter;
import org.geotools.api.filter.PropertyIsBetween;
import org.geotools.api.filter.expression.Expression;
import org.geotools.filter.text.commons.CompilerUtil;
import org.geotools.filter.text.commons.Language;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.cql2.FilterCQLSample;
import org.junit.Assert;
import org.junit.Test;

public class CQLBetweenPredicateTest {
    protected final Language language;

    public CQLBetweenPredicateTest() {
        this(Language.CQL);
    }

    protected CQLBetweenPredicateTest(Language language) {
        assert (language != null) : "language cannot be null value";
        this.language = language;
    }

    @Test
    public void propertyBetweenLiterals() throws Exception {
        Filter expected = FilterCQLSample.getSample("ATTR1 BETWEEN 10 AND 20");
        this.testBetweenPredicate("ATTR1 BETWEEN 10 AND 20", expected);
    }

    @Test
    public void notBetweenPredicate() throws Exception {
        Filter expected = FilterCQLSample.getSample("ATTR1 NOT BETWEEN 10 AND 20");
        this.testBetweenPredicate("ATTR1 NOT BETWEEN 10 AND 20", expected);
    }

    @Test
    public void compoundAttributeInBetweenPredicate() throws Exception {
        String prop = "gmd:aa:bb.gmd:cc.gmd:dd";
        String propExpected = "gmd:aa:bb/gmd:cc/gmd:dd";
        Filter resultFilter = this.parseFilter("gmd:aa:bb.gmd:cc.gmd:dd BETWEEN 100 AND 200 ");
        Assert.assertTrue((String)"PropertyIsBetween filter was expected", (boolean)(resultFilter instanceof PropertyIsBetween));
        PropertyIsBetween filter = (PropertyIsBetween)resultFilter;
        Expression property = filter.getExpression();
        Assert.assertEquals((Object)"gmd:aa:bb/gmd:cc/gmd:dd", (Object)property.toString());
    }

    protected void testBetweenPredicate(String samplePredicate, Filter expected) throws Exception {
        Filter actual = this.parseFilter(samplePredicate);
        Assert.assertNotNull((String)"expects a not null filter", (Object)actual);
        Assert.assertEquals((String)"between filter error", (Object)expected, (Object)actual);
    }

    protected Filter parseFilter(String samplePredicate) throws CQLException {
        return CompilerUtil.parseFilter((Language)this.language, (String)samplePredicate);
    }
}

