/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.cql2;

import org.geotools.api.filter.Filter;
import org.geotools.api.filter.Not;
import org.geotools.filter.text.commons.CompilerUtil;
import org.geotools.filter.text.commons.Language;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.cql2.FilterCQLSample;
import org.junit.Assert;
import org.junit.Test;

public class CQLBooleanValueExpressionTest {
    protected final Language language;

    public CQLBooleanValueExpressionTest() {
        this(Language.CQL);
    }

    protected CQLBooleanValueExpressionTest(Language language) {
        assert (language != null) : "language cannot be null value";
        this.language = language;
    }

    protected Filter parseFilter(String filter) throws CQLException {
        return CompilerUtil.parseFilter((Language)this.language, (String)filter);
    }

    @Test
    public void and() throws CQLException {
        Filter result = this.parseFilter("ATTR1 < 10 AND ATTR2 < 2");
        Assert.assertNotNull((String)"filter expected", (Object)result);
        Filter expected = FilterCQLSample.getSample("ATTR1 < 10 AND ATTR2 < 2");
        Assert.assertEquals((String)"ATTR1 < 10 AND ATTR2 < 2 was expected", (Object)expected, (Object)result);
    }

    @Test
    public void or() throws CQLException {
        Filter result = this.parseFilter("ATTR1 > 10 OR ATTR2 < 2");
        Assert.assertNotNull((String)"filter expected", (Object)result);
        Filter expected = FilterCQLSample.getSample("ATTR1 > 10 OR ATTR2 < 2");
        Assert.assertEquals((String)"ATTR1 > 10 OR ATTR2 < 2 was expected", (Object)expected, (Object)result);
    }

    @Test
    public void andOr() throws CQLException {
        Filter result = this.parseFilter("ATTR1 < 10 AND ATTR2 < 2 OR ATTR3 > 10");
        Assert.assertNotNull((String)"filter expected", (Object)result);
        Filter expected = FilterCQLSample.getSample("ATTR1 < 10 AND ATTR2 < 2 OR ATTR3 > 10");
        Assert.assertEquals((String)"a bad filter was expected", (Object)expected, (Object)result);
        result = this.parseFilter("ATTR3 < 4 AND (ATTR1 > 10 OR ATTR2 < 2)");
        Assert.assertNotNull((String)"filter expected", (Object)result);
        expected = FilterCQLSample.getSample("ATTR3 < 4 AND (ATTR1 > 10 OR ATTR2 < 2)");
        Assert.assertEquals((String)"a bad filter was expected", (Object)expected, (Object)result);
    }

    @Test
    public void not() throws Exception {
        String stmt = "NOT ATTR1 < 1";
        Filter result = this.parseFilter("NOT ATTR1 < 1");
        Assert.assertNotNull((String)"filter expected", (Object)result);
        Assert.assertTrue((boolean)(result instanceof Not));
        Not notFilter = (Not)result;
        Filter actual = notFilter.getFilter();
        Filter expected = FilterCQLSample.getSample("ATTR1 < 1");
        Assert.assertEquals((String)"ATTR1 < 1was expected", (Object)expected, (Object)actual);
    }

    @Test
    public void andNot() throws Exception {
        Filter result = this.parseFilter("ATTR3 < 4 AND (NOT( ATTR1 < 10 AND ATTR2 < 2))");
        Assert.assertNotNull((String)"filter expected", (Object)result);
        Filter expected = FilterCQLSample.getSample("ATTR3 < 4 AND (NOT( ATTR1 < 10 AND ATTR2 < 2))");
        Assert.assertEquals((String)"a bad filter was produced", (Object)expected, (Object)result);
        result = this.parseFilter("ATTR1 < 1 AND (NOT (ATTR2 < 2)) AND ATTR3 < 3");
        Assert.assertNotNull((String)"filter expected", (Object)result);
        expected = FilterCQLSample.getSample("ATTR1 < 1 AND (NOT (ATTR2 < 2)) AND ATTR3 < 3");
        Assert.assertEquals((String)"a bad filter was produced", (Object)expected, (Object)result);
    }
}

