/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.cql2;

import org.geotools.api.filter.Filter;
import org.geotools.api.filter.expression.Add;
import org.geotools.api.filter.expression.Divide;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Multiply;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.expression.Subtract;
import org.geotools.filter.text.commons.CompilerUtil;
import org.geotools.filter.text.commons.Language;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.filter.text.cql2.CQLException;
import org.junit.Assert;
import org.junit.Test;

public class CQLExpressionTest {
    protected final Language language;

    public CQLExpressionTest() {
        this(Language.CQL);
    }

    protected CQLExpressionTest(Language language) {
        assert (language != null) : "language cannot be null value";
        this.language = language;
    }

    @Test
    public void attributeName() throws CQLException {
        Expression expression = this.parseExpression("attName");
        Assert.assertNotNull((Object)expression);
        Assert.assertTrue((boolean)(expression instanceof PropertyName));
        Assert.assertEquals((Object)"attName", (Object)((PropertyName)expression).getPropertyName());
    }

    protected Expression parseExpression(String cql) throws CQLException {
        return CompilerUtil.parseExpression((Language)this.language, (String)cql);
    }

    @Test(expected=CQLException.class)
    public void badPropertyName() throws CQLException {
        String cqlExpression = "1A=2";
        this.parseFilter(cqlExpression);
    }

    protected Filter parseFilter(String cql) throws CQLException {
        return CompilerUtil.parseFilter((Language)this.language, (String)cql);
    }

    @Test
    public void add() throws CQLException {
        Expression expression = this.parseExpression("a + b + x.y.z");
        Assert.assertNotNull((Object)expression);
        Assert.assertTrue((boolean)(expression instanceof Add));
        Add add = (Add)expression;
        Expression e1 = add.getExpression1();
        Expression e2 = add.getExpression2();
        Assert.assertTrue((boolean)(e1 instanceof Add));
        Assert.assertTrue((boolean)(e2 instanceof PropertyName));
        Assert.assertEquals((Object)"x/y/z", (Object)((PropertyName)e2).getPropertyName());
    }

    @Test(expected=CQLException.class)
    public final void testGetSyntaxError() throws CQLException {
        String malformedExp = "12 / ] + 4";
        this.parseExpression("12 / ] + 4");
    }

    @Test
    public void testCombinedOperations() throws Exception {
        String combinedOperations = "4 / (1 + 3) + 5 * (10 - 8)";
        Expression exp = this.parseExpression("4 / (1 + 3) + 5 * (10 - 8)");
        this.assertExpectedExpressionsStructure(exp);
        String cql = CQL.toCQL((Expression)exp);
        exp = this.parseExpression(cql);
        this.assertExpectedExpressionsStructure(exp);
    }

    private void assertExpectedExpressionsStructure(Expression exp) {
        Assert.assertTrue((boolean)(exp instanceof Add));
        Add add = (Add)exp;
        Expression exp1 = add.getExpression1();
        Assert.assertTrue((boolean)(exp1 instanceof Divide));
        Divide divide = (Divide)exp1;
        Expression exp3 = divide.getExpression2();
        Assert.assertTrue((boolean)(exp3 instanceof Add));
        Expression exp2 = add.getExpression2();
        Assert.assertTrue((boolean)(exp2 instanceof Multiply));
        Multiply multiply = (Multiply)exp2;
        Expression exp4 = multiply.getExpression2();
        Assert.assertTrue((boolean)(exp4 instanceof Subtract));
    }
}

