/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.cql2;

import org.geotools.api.filter.Filter;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.spatial.Beyond;
import org.geotools.api.filter.spatial.DWithin;
import org.geotools.api.filter.spatial.DistanceBufferOperator;
import org.geotools.filter.text.commons.CompilerUtil;
import org.geotools.filter.text.commons.Language;
import org.geotools.filter.text.cql2.CQLException;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.locationtech.jts.geom.Point;

public class CQLRelGeoOpTest {
    protected final Language language;

    public CQLRelGeoOpTest() {
        this(Language.CQL);
    }

    protected CQLRelGeoOpTest(Language language) {
        assert (language != null) : "language cannot be null value";
        this.language = language;
    }

    @Test
    public void dwithin() throws CQLException {
        Filter resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"DWITHIN(ATTR1, POINT(1 2), 10, kilometers)");
        Assert.assertTrue((boolean)(resultFilter instanceof DistanceBufferOperator));
        String prop = "gmd:aa:bb.gmd:cc.gmd:dd";
        String propExpected = "gmd:aa:bb/gmd:cc/gmd:dd";
        resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"DWITHIN(gmd:aa:bb.gmd:cc.gmd:dd, POINT(1 2), 10, kilometers) ");
        Assert.assertTrue((String)"DistanceBufferOperator filter was expected", (boolean)(resultFilter instanceof DWithin));
        DWithin filter = (DWithin)resultFilter;
        Expression property = filter.getExpression1();
        Assert.assertEquals((Object)"gmd:aa:bb/gmd:cc/gmd:dd", (Object)property.toString());
    }

    @Test
    public void beyon() throws CQLException {
        Filter resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"BEYOND(ATTR1, POINT(1.0 2.0), 10.0, kilometers)");
        Assert.assertTrue((boolean)(resultFilter instanceof Beyond));
        Beyond beyondFilter = (Beyond)resultFilter;
        Assert.assertEquals((double)beyondFilter.getDistance(), (double)10.0, (double)0.1);
        Assert.assertEquals((Object)beyondFilter.getDistanceUnits(), (Object)"kilometers");
        Assert.assertEquals((Object)beyondFilter.getExpression1().toString(), (Object)"ATTR1");
        Expression geomExpression = beyondFilter.getExpression2();
        Assert.assertTrue((boolean)(geomExpression instanceof Literal));
        Literal literalPoint = (Literal)geomExpression;
        Object pointValue = literalPoint.getValue();
        Assert.assertTrue((boolean)(pointValue instanceof Point));
        Point point = (Point)pointValue;
        Assert.assertEquals((double)point.getX(), (double)1.0, (double)0.1);
        Assert.assertEquals((double)point.getY(), (double)2.0, (double)0.1);
    }

    @Test(expected=CQLException.class)
    public void syntaxError() throws Exception {
        CompilerUtil.parseFilter((Language)this.language, (String)"EYOND(ATTR1, POINTS(1.0 2.0), 10.0, kilometers)");
    }

    @Test
    public final void syntaxErrorMessage() {
        try {
            String malformedGeometry = "WITHIN(ATTR1, POLYGON((1 2, 10 15), (10 15, 1 2)))";
            CompilerUtil.parseFilter((Language)this.language, (String)"WITHIN(ATTR1, POLYGON((1 2, 10 15), (10 15, 1 2)))");
            Assert.fail();
        }
        catch (CQLException e) {
            String msg = e.getSyntaxError();
            Assert.assertNotNull((Object)msg);
        }
    }

    @Ignore
    @Test
    public void testRoutineInvocationGeneric() throws Exception {
    }
}

