/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.cql2;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.temporal.Before;
import org.geotools.filter.text.commons.CompilerUtil;
import org.geotools.filter.text.commons.Language;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.cql2.FilterCQLSample;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class CQLTemporalPredicateTest {
    protected final Language language;

    public CQLTemporalPredicateTest() {
        this(Language.CQL);
    }

    protected CQLTemporalPredicateTest(Language language) {
        assert (language != null) : "language cannot be null value";
        this.language = language;
    }

    @Test
    public void before() throws Exception {
        Filter resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"ATTR1 BEFORE 2006-11-30T01:30:00Z");
        Assert.assertNotNull((String)"not null expected", (Object)resultFilter);
        Filter expected = FilterCQLSample.getSample("ATTR1 BEFORE 2006-11-30T01:30:00Z");
        Assert.assertEquals((Object)expected, (Object)resultFilter);
        resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"ATTR1 BEFORE 2006-11-30T01:30:00.123Z");
        Assert.assertNotNull((String)"not null expected", (Object)resultFilter);
        expected = FilterCQLSample.getSample("ATTR1 BEFORE 2006-11-30T01:30:00.123Z");
        Assert.assertEquals((Object)expected, (Object)resultFilter);
        resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"ATTR1 BEFORE 2006-11-30T01:30:00Z/2006-12-31T01:30:00Z");
        Assert.assertNotNull((String)"Filter expected", (Object)resultFilter);
        expected = FilterCQLSample.getSample("ATTR1 BEFORE 2006-11-30T01:30:00Z/2006-12-31T01:30:00Z");
        Assert.assertEquals((String)"less than first date of period ", (Object)expected, (Object)resultFilter);
        resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"ATTR1 BEFORE 2006-11-30T01:30:00.123Z/2006-12-31T01:30:00.456Z");
        Assert.assertNotNull((String)"Filter expected", (Object)resultFilter);
        expected = FilterCQLSample.getSample("ATTR1 BEFORE 2006-11-30T01:30:00.123Z/2006-12-31T01:30:00.456Z");
        Assert.assertEquals((String)"less than first date of period ", (Object)expected, (Object)resultFilter);
        resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"ATTR1 BEFORE  2006-11-30T01:30:00Z/P30D");
        Assert.assertNotNull((String)"Filter expected", (Object)resultFilter);
        expected = FilterCQLSample.getSample("ATTR1 BEFORE  2006-11-30T01:30:00Z/P30D");
        Assert.assertEquals((String)"less than first date of period ", (Object)expected, (Object)resultFilter);
        resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"ATTR1 BEFORE 2006-11-30T01:30:00Z/P1Y");
        Assert.assertNotNull((String)"Filter expected", (Object)resultFilter);
        expected = FilterCQLSample.getSample("ATTR1 BEFORE 2006-11-30T01:30:00Z/P1Y");
        Assert.assertEquals((String)"less than first date of period ", (Object)expected, (Object)resultFilter);
        resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"ATTR1 BEFORE 2006-11-30T01:30:00Z/P12M");
        Assert.assertNotNull((String)"Filter expected", (Object)resultFilter);
        expected = FilterCQLSample.getSample("ATTR1 BEFORE 2006-11-30T01:30:00Z/P12M");
        Assert.assertEquals((String)"less than first date of period ", (Object)expected, (Object)resultFilter);
        resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"ATTR1 BEFORE P10Y10M10DT5H5M5S/2006-12-31T01:30:00Z");
        Assert.assertNotNull((String)"Filter expected", (Object)resultFilter);
        expected = FilterCQLSample.getSample("ATTR1 BEFORE P10Y10M10DT5H5M5S/2006-12-31T01:30:00Z");
        Assert.assertEquals((String)"greater filter", (Object)expected, (Object)resultFilter);
    }

    @Test(expected=CQLException.class)
    public void lostTime() throws CQLException {
        CompilerUtil.parseFilter((Language)this.language, (String)"ZONE_VALID_FROM BEFORE 2008-09-09");
        Assert.fail((String)"CQLException is expected. The \"date-time\" rule requires a time");
    }

    @Test(expected=CQLException.class)
    public void badTime() throws CQLException {
        CompilerUtil.parseFilter((Language)this.language, (String)"ZONE_VALID_FROM BEFORE 2008-09-09 17:00:00");
        Assert.fail((String)"CQLException is expected. The \"date-time\" rule require a time preceded by \"T\"");
    }

    @Test
    public void dateTime() throws Exception {
        String cqlDateTime = "2008-09-09T17:00:00Z";
        Filter resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"ZONE_VALID_FROM BEFORE 2008-09-09T17:00:00Z");
        Before comparation = (Before)resultFilter;
        Expression expr2 = comparation.getExpression2();
        Literal literalDate = (Literal)expr2;
        String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        dateFormatter.setTimeZone(TimeZone.getTimeZone("GMT+00:00"));
        Date expectedDate = dateFormatter.parse("2008-09-09T17:00:00Z");
        Date actualDate = (Date)literalDate.getValue();
        Assert.assertEquals((Object)expectedDate, (Object)actualDate);
    }

    @Test
    public void dateTimeWithLocalTime() throws Exception {
        String localTime = "2008-09-09T17:00:00";
        Filter resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)("ZONE_VALID_FROM BEFORE " + localTime));
        Before comparation = (Before)resultFilter;
        Expression expr2 = comparation.getExpression2();
        Literal literalDate = (Literal)expr2;
        String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        dateFormatter.setTimeZone(TimeZone.getDefault());
        Date expectedDate = dateFormatter.parse(localTime);
        Date actualDate = (Date)literalDate.getValue();
        Assert.assertEquals((Object)expectedDate, (Object)actualDate);
    }

    @Test
    public void dateTimeWithOffset() throws Exception {
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ssz");
        String offset = "GMT+01:00";
        TimeZone tz = TimeZone.getTimeZone("GMT+01:00");
        dateFormatter.setTimeZone(tz);
        Filter resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"ZONE_VALID_FROM BEFORE 2008-09-09T17:00:00+01:00");
        Before comparation = (Before)resultFilter;
        Expression expr2 = comparation.getExpression2();
        Literal literalDate = (Literal)expr2;
        Date actualDate = (Date)literalDate.getValue();
        Date expectedDate = dateFormatter.parse("2008-09-09 17:00:00GMT+01:00");
        Assert.assertEquals((Object)expectedDate, (Object)actualDate);
        dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        offset = "GMT-01:00";
        tz = TimeZone.getTimeZone("GMT-01:00");
        dateFormatter.setTimeZone(tz);
        resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"ZONE_VALID_FROM BEFORE 2008-09-09T17:00:00-01:00");
        comparation = (Before)resultFilter;
        expr2 = comparation.getExpression2();
        literalDate = (Literal)expr2;
        actualDate = (Date)literalDate.getValue();
        expectedDate = dateFormatter.parse("2008-09-09 17:00:00");
        Assert.assertEquals((Object)expectedDate, (Object)actualDate);
    }

    @Test
    public void beforeCompundProperty() throws CQLException {
        String prop = "gmd:aa:bb.gmd:cc.gmd:dd";
        String propExpected = "gmd:aa:bb/gmd:cc/gmd:dd";
        String predicate = "gmd:aa:bb.gmd:cc.gmd:dd BEFORE P10Y10M10DT5H5M5S/2006-11-30T01:30:00Z ";
        Filter resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)predicate);
        Assert.assertTrue((boolean)(resultFilter instanceof Before));
        Before lessFilter = (Before)resultFilter;
        Expression property = lessFilter.getExpression1();
        Assert.assertEquals((Object)"gmd:aa:bb/gmd:cc/gmd:dd", (Object)property.toString());
    }

    @Test
    public void beforeOrDuring() throws Exception {
        Filter resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"ATTR1 BEFORE OR DURING 2006-11-30T01:30:00Z/2006-12-31T01:30:00Z");
        Assert.assertNotNull((String)"Filter expected", (Object)resultFilter);
        Filter expected = FilterCQLSample.getSample("ATTR1 BEFORE OR DURING 2006-11-30T01:30:00Z/2006-12-31T01:30:00Z");
        Assert.assertEquals((String)"less than or equal the last date of period ", (Object)expected, (Object)resultFilter);
        resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"ATTR1 BEFORE OR DURING P10Y10M10DT5H5M5S/2006-12-31T01:30:00Z");
        Assert.assertNotNull((String)"Filter expected", (Object)resultFilter);
        expected = FilterCQLSample.getSample("ATTR1 BEFORE OR DURING P10Y10M10DT5H5M5S/2006-12-31T01:30:00Z");
        Assert.assertEquals((String)" filter", (Object)expected, (Object)resultFilter);
        resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"ATTR1 BEFORE OR DURING 2006-11-30T01:30:00Z/P10Y10M10DT5H5M5S");
        Assert.assertNotNull((String)"Filter expected", (Object)resultFilter);
        expected = FilterCQLSample.getSample("ATTR1 BEFORE OR DURING 2006-11-30T01:30:00Z/P10Y10M10DT5H5M5S");
        Assert.assertEquals((String)" filter", (Object)expected, (Object)resultFilter);
    }

    @Test
    public void duringOrAfter() throws Exception {
        Filter resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"ATTR1 DURING OR AFTER 2006-11-30T01:30:00Z/2006-12-31T01:30:00Z");
        Assert.assertNotNull((String)"Filter expected", (Object)resultFilter);
        Filter expected = FilterCQLSample.getSample("ATTR1 DURING OR AFTER 2006-11-30T01:30:00Z/2006-12-31T01:30:00Z");
        Assert.assertEquals((String)"greater than or equal the first date of period ", (Object)expected, (Object)resultFilter);
        resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"ATTR1 DURING OR AFTER P10Y10M10DT5H5M5S/2006-12-31T01:30:00Z");
        Assert.assertNotNull((String)"Filter expected", (Object)resultFilter);
        expected = FilterCQLSample.getSample("ATTR1 DURING OR AFTER P10Y10M10DT5H5M5S/2006-12-31T01:30:00Z");
        Assert.assertEquals((String)"greater than or equal the first date (is calculated subtract period to last date) of period", (Object)expected, (Object)resultFilter);
        resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"ATTR1 DURING OR AFTER 2006-11-30T01:30:00Z/P10Y10M10DT5H5M5S");
        Assert.assertNotNull((String)"Filter expected", (Object)resultFilter);
        expected = FilterCQLSample.getSample("ATTR1 DURING OR AFTER 2006-11-30T01:30:00Z/P10Y10M10DT5H5M5S");
        Assert.assertEquals((String)"greater than or equal the first date", (Object)expected, (Object)resultFilter);
    }

    @Test
    public void during() throws Exception {
        Filter resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"ATTR1 DURING 2006-11-30T01:30:00Z/2006-12-31T01:30:00Z");
        Assert.assertNotNull((String)"Filter expected", (Object)resultFilter);
        Filter expected = FilterCQLSample.getSample("ATTR1 DURING 2006-11-30T01:30:00Z/2006-12-31T01:30:00Z");
        Assert.assertEquals((String)"greater filter ", (Object)expected, (Object)resultFilter);
        resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"ATTR1 DURING 2006-11-30T01:30:00Z/P10Y10M10DT5H5M5S");
        Assert.assertNotNull((String)"Filter expected", (Object)resultFilter);
        expected = FilterCQLSample.getSample("ATTR1 DURING 2006-11-30T01:30:00Z/P10Y10M10DT5H5M5S");
        Assert.assertEquals((String)"greater filter", (Object)expected, (Object)resultFilter);
        resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"ATTR1 DURING P10Y10M10DT5H5M5S/2006-12-31T01:30:00Z");
        Assert.assertNotNull((String)"Filter expected", (Object)resultFilter);
        expected = FilterCQLSample.getSample("ATTR1 DURING P10Y10M10DT5H5M5S/2006-12-31T01:30:00Z");
        Assert.assertEquals((String)"greater filter", (Object)expected, (Object)resultFilter);
    }

    @Test
    public void after() throws Exception {
        Filter resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"ATTR1 AFTER 2006-12-31T01:30:00Z");
        Assert.assertNotNull((String)"Filter expected", (Object)resultFilter);
        Filter expected = FilterCQLSample.getSample("ATTR1 AFTER 2006-12-31T01:30:00Z");
        Assert.assertEquals((String)"greater filter ", (Object)expected, (Object)resultFilter);
        resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"ATTR1 AFTER 2006-11-30T01:30:00Z/2006-12-31T01:30:00Z");
        Assert.assertNotNull((String)"Filter expected", (Object)resultFilter);
        expected = FilterCQLSample.getSample("ATTR1 AFTER 2006-11-30T01:30:00Z/2006-12-31T01:30:00Z");
        Assert.assertEquals((String)"greater filter ", (Object)expected, (Object)resultFilter);
        resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"ATTR1 AFTER 2006-11-30T01:30:00Z/P10D");
        Assert.assertNotNull((String)"Filter expected", (Object)resultFilter);
        expected = FilterCQLSample.getSample("ATTR1 AFTER 2006-11-30T01:30:00Z/P10D");
        Assert.assertEquals((String)"greater filter", (Object)expected, (Object)resultFilter);
        resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"ATTR1 AFTER 2006-11-30T01:30:00Z/P10M");
        Assert.assertNotNull((String)"Filter expected", (Object)resultFilter);
        expected = FilterCQLSample.getSample("ATTR1 AFTER 2006-11-30T01:30:00Z/P10M");
        Assert.assertEquals((String)"greater filter", (Object)expected, (Object)resultFilter);
        resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"ATTR1 AFTER 2006-11-30T01:30:00Z/P10Y");
        Assert.assertNotNull((String)"Filter expected", (Object)resultFilter);
        expected = FilterCQLSample.getSample("ATTR1 AFTER 2006-11-30T01:30:00Z/P10Y");
        Assert.assertEquals((String)"greater filter", (Object)expected, (Object)resultFilter);
        resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"ATTR1 AFTER 2006-11-30T01:30:00Z/P10Y10M");
        Assert.assertNotNull((String)"Filter expected", (Object)resultFilter);
        expected = FilterCQLSample.getSample("ATTR1 AFTER 2006-11-30T01:30:00Z/P10Y10M");
        Assert.assertEquals((String)"greater filter", (Object)expected, (Object)resultFilter);
        resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"ATTR1 AFTER 2006-11-30T01:30:00Z/T5H");
        Assert.assertNotNull((String)"Filter expected", (Object)resultFilter);
        expected = FilterCQLSample.getSample("ATTR1 AFTER 2006-11-30T01:30:00Z/T5H");
        Assert.assertEquals((String)"greater filter", (Object)expected, (Object)resultFilter);
        resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"ATTR1 AFTER 2006-11-30T01:30:00Z/T5M");
        Assert.assertNotNull((String)"FilSter expected", (Object)resultFilter);
        expected = FilterCQLSample.getSample("ATTR1 AFTER 2006-11-30T01:30:00Z/T5M");
        Assert.assertEquals((String)"greater filter", (Object)expected, (Object)resultFilter);
        resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"ATTR1 AFTER 2006-11-30T01:30:00Z/T5S");
        Assert.assertNotNull((String)"Filter expected", (Object)resultFilter);
        expected = FilterCQLSample.getSample("ATTR1 AFTER 2006-11-30T01:30:00Z/T5S");
        Assert.assertEquals((String)"greater filter", (Object)expected, (Object)resultFilter);
        resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"ATTR1 AFTER 2006-11-30T01:30:00Z/P10Y10M10DT5H5M5S");
        Assert.assertNotNull((String)"Filter expected", (Object)resultFilter);
        expected = FilterCQLSample.getSample("ATTR1 AFTER 2006-11-30T01:30:00Z/P10Y10M10DT5H5M5S");
        Assert.assertEquals((String)"greater filter", (Object)expected, (Object)resultFilter);
    }

    @Ignore
    public void issueCOT2157() throws Exception {
        Runnable cqlRunner = () -> {
            String predicate = "( ZONE_VALID_FROM BEFORE 2008-09-15T00:00:00Z AND ( ZONE_VALID_TO IS NULL OR ZONE_VALID_TO AFTER 2008-09-15T00:00:00Z))";
            try {
                Filter filter = CompilerUtil.parseFilter((Language)this.language, (String)"( ZONE_VALID_FROM BEFORE 2008-09-15T00:00:00Z AND ( ZONE_VALID_TO IS NULL OR ZONE_VALID_TO AFTER 2008-09-15T00:00:00Z))");
                Assert.assertNotNull((Object)filter);
            }
            catch (CQLException e) {
                Logger.getGlobal().log(Level.INFO, "", e);
            }
        };
        Thread[] threadList = new Thread[1000];
        for (int i = 0; i < threadList.length; ++i) {
            threadList[i] = new Thread(cqlRunner);
        }
        for (Thread thread : threadList) {
            thread.start();
        }
    }

    @Test
    public void equal() throws Exception {
        Filter resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"ATTR1 TEQUALS 2006-11-30T01:30:00Z");
        Assert.assertNotNull((String)"not null expected", (Object)resultFilter);
        Filter expected = FilterCQLSample.getSample("ATTR1 TEQUALS 2006-11-30T01:30:00Z");
        Assert.assertEquals((Object)expected, (Object)resultFilter);
    }
}

