/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.ecql;

import org.geotools.api.filter.Filter;
import org.geotools.filter.text.commons.Language;
import org.geotools.filter.text.cql2.CQLBetweenPredicateTest;
import org.geotools.filter.text.ecql.FilterECQLSample;
import org.junit.Test;

public class ECQLBetweenPredicateTest
extends CQLBetweenPredicateTest {
    public ECQLBetweenPredicateTest() {
        super(Language.ECQL);
    }

    @Test
    public void literalBetweenLiterals() throws Exception {
        String txtPredicate = "2 between 1 and 3";
        Filter expected = FilterECQLSample.getSample(txtPredicate);
        this.testBetweenPredicate(txtPredicate, expected);
    }

    @Test
    public void literalBetweenExpressions() throws Exception {
        String txtPredicate = "2 BETWEEN (2-1) AND (2+1)";
        Filter expected = FilterECQLSample.getSample(txtPredicate);
        this.testBetweenPredicate(txtPredicate, expected);
    }

    @Test
    public void functionBetweenLiterals() throws Exception {
        String txtPredicate = "area( the_geom ) BETWEEN 10000 AND 30000";
        Filter expected = FilterECQLSample.getSample(txtPredicate);
        this.testBetweenPredicate(txtPredicate, expected);
    }

    @Test
    public void functionBetweenFunctions() throws Exception {
        String txtPredicate = "area( the_geom ) BETWEEN abs(10000) AND abs(30000)";
        Filter expected = FilterECQLSample.getSample("area( the_geom ) BETWEEN abs(10000) AND abs(30000)");
        this.testBetweenPredicate("area( the_geom ) BETWEEN abs(10000) AND abs(30000)", expected);
    }
}

