/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.ecql;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.geotools.api.filter.BinaryComparisonOperator;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.PropertyIsBetween;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.PropertyIsGreaterThan;
import org.geotools.api.filter.PropertyIsGreaterThanOrEqualTo;
import org.geotools.api.filter.PropertyIsLessThan;
import org.geotools.api.filter.PropertyIsLessThanOrEqualTo;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.filter.AndImpl;
import org.geotools.filter.NotImpl;
import org.geotools.filter.text.commons.Language;
import org.geotools.filter.text.cql2.CQLComparisonPredicateTest;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.filter.text.ecql.FilterECQLSample;
import org.junit.Assert;
import org.junit.Test;

public class ECQLComparisonPredicateTest
extends CQLComparisonPredicateTest {
    public ECQLComparisonPredicateTest() {
        super(Language.ECQL);
    }

    @Override
    @Test
    public void deprecatedPredicate() throws Exception {
        ECQL.toFilter((String)"POP_RANK eq 6");
        ECQL.toFilter((String)"POP_RANK neq 6");
        ECQL.toFilter((String)"POP_RANK lte 6");
        ECQL.toFilter((String)"! (POP_RANK = 6)");
        Assert.assertTrue((boolean)(ECQL.toFilter((String)"POP_RANK eq 6") instanceof PropertyIsEqualTo));
        Assert.assertTrue((boolean)(ECQL.toFilter((String)"POP_RANK == 6") instanceof PropertyIsEqualTo));
        Assert.assertTrue((boolean)(ECQL.toFilter((String)"POP_RANK lte 6") instanceof PropertyIsLessThanOrEqualTo));
        Assert.assertTrue((boolean)(ECQL.toFilter((String)"POP_RANK gte 6") instanceof PropertyIsGreaterThanOrEqualTo));
        Assert.assertTrue((boolean)(ECQL.toFilter((String)"POP_RANK lt 6") instanceof PropertyIsLessThan));
        Assert.assertTrue((boolean)(ECQL.toFilter((String)"POP_RANK gt 6") instanceof PropertyIsGreaterThan));
        Assert.assertTrue((boolean)(ECQL.toFilter((String)"! (POP_RANK == 6)") instanceof NotImpl));
        Assert.assertTrue((boolean)(ECQL.toFilter((String)"POP_RANK neq 6") instanceof NotImpl));
        Assert.assertTrue((boolean)(ECQL.toFilter((String)"A > 2 && B < 1") instanceof AndImpl));
    }

    @Test
    public void expressionComparisonProperty() throws CQLException {
        this.testComparison("(1+3) > aProperty");
        this.testComparison("(1+3) > (4-5)");
        this.testComparison("(x+4) > (y - 5)");
    }

    @Test
    public void negativeNumber() throws CQLException {
        this.testComparison("aProperty > -1");
        this.testComparison("-1 > aProperty");
        this.testComparison("aProperty > -1.05");
        this.testComparison("-1.05 > aProperty");
        this.testComparison("-1.05 + 4.6 > aProperty");
        this.testComparison("aProperty > -1.05 + 4.6");
        this.testComparison("-1.05 + (-4.6* -10) > aProperty");
        this.testComparison("10--1.05 > aProperty");
    }

    @Test
    public void functionsInComparison() throws CQLException {
        this.testComparison("abs(10) < aProperty");
        this.testComparison("area( the_geom ) < 30000");
        this.testComparison("area( the_geom ) < (1+3)");
        this.testComparison("area( the_geom ) < abs(10)");
    }

    @Test
    public void dateLiteral() throws Exception {
        Filter f = this.parseFilter("X = 2012-02-01");
        this.testPropertyIsEqualDate(f, this.date(2012, 1, 1, 0, 0, 0, 0, TimeZone.getDefault()));
    }

    @Test
    public void dateLiteralTimeZoneUTC() throws Exception {
        Filter f = this.parseFilter("X = 2012-02-01Z");
        this.testPropertyIsEqualDate(f, this.date(2012, 1, 1, 0, 0, 0, 0, TimeZone.getTimeZone("GMT")));
    }

    @Test
    public void dateLiteralTimeZonePlusMinus() throws Exception {
        Filter f = this.parseFilter("X = 2012-02-01-0800");
        this.testPropertyIsEqualDate(f, this.date(2012, 1, 1, 0, 0, 0, 0, TimeZone.getTimeZone("GMT-8:00")));
        f = this.parseFilter("X = 2012-02-01+08:00");
        this.testPropertyIsEqualDate(f, this.date(2012, 1, 1, 0, 0, 0, 0, TimeZone.getTimeZone("GMT+8:00")));
    }

    @Test
    public void dateTimeLiteral() throws Exception {
        Filter f = this.parseFilter("X = 2012-02-01T12:10:13");
        this.testPropertyIsEqualDate(f, this.date(2012, 1, 1, 12, 10, 13, 0, TimeZone.getDefault()));
    }

    @Test
    public void dateTimeLiteralMilliseconds() throws Exception {
        Filter f = this.parseFilter("X = 2012-02-01T12:10:13.123");
        this.testPropertyIsEqualDate(f, this.date(2012, 1, 1, 12, 10, 13, 123, TimeZone.getDefault()));
    }

    @Test
    public void dateTimeLiteralTimeZoneUTC() throws Exception {
        Filter f = this.parseFilter("X = 2012-02-01T12:10:13.123Z");
        this.testPropertyIsEqualDate(f, this.date(2012, 1, 1, 12, 10, 13, 123, TimeZone.getTimeZone("GMT")));
    }

    @Test
    public void dateTimeLiteralTimeZonePlusMinus() throws Exception {
        Filter f = this.parseFilter("X = 2012-02-01T12:10:13.123-0800");
        this.testPropertyIsEqualDate(f, this.date(2012, 1, 1, 12, 10, 13, 123, TimeZone.getTimeZone("GMT-8:00")));
        f = this.parseFilter("X = 2012-02-01T12:10:13+08:00");
        this.testPropertyIsEqualDate(f, this.date(2012, 1, 1, 12, 10, 13, 0, TimeZone.getTimeZone("GMT+8:00")));
    }

    @Test
    public void testPositiveNegativeConsistent() throws Exception {
        BinaryComparisonOperator f = (BinaryComparisonOperator)this.parseFilter("foo > -1");
        Assert.assertEquals((Object)-1L, (Object)f.getExpression2().evaluate(null));
        f = (BinaryComparisonOperator)this.parseFilter("foo > 1");
        Assert.assertEquals((Object)1L, (Object)f.getExpression2().evaluate(null));
        f = (BinaryComparisonOperator)this.parseFilter("-1 > foo");
        Assert.assertEquals((Object)-1L, (Object)f.getExpression1().evaluate(null));
        f = (BinaryComparisonOperator)this.parseFilter("1 > foo");
        Assert.assertEquals((Object)1L, (Object)f.getExpression1().evaluate(null));
        PropertyIsBetween between = (PropertyIsBetween)this.parseFilter("foo between -1 and 1");
        Assert.assertEquals((Object)-1L, (Object)between.getLowerBoundary().evaluate(null));
        Assert.assertEquals((Object)1L, (Object)between.getUpperBoundary().evaluate(null));
        between = (PropertyIsBetween)this.parseFilter("-1 between foo and bar");
        Assert.assertEquals((Object)-1L, (Object)between.getExpression().evaluate(null));
    }

    protected Date date(int year, int month, int dayOfMonth, int hourOfDay, int minute, int second, int milliscond, TimeZone tz) {
        Calendar c = Calendar.getInstance();
        c.set(1, year);
        c.set(2, month);
        c.set(5, dayOfMonth);
        c.set(11, hourOfDay);
        c.set(12, minute);
        c.set(13, second);
        c.set(14, milliscond);
        c.setTimeZone(tz);
        return c.getTime();
    }

    protected void testPropertyIsEqualDate(Filter f, Date expected) {
        Assert.assertTrue((boolean)(f instanceof PropertyIsEqualTo));
        PropertyIsEqualTo eq = (PropertyIsEqualTo)f;
        Assert.assertTrue((boolean)(eq.getExpression1() instanceof PropertyName));
        Assert.assertTrue((boolean)(eq.getExpression2() instanceof Literal));
        Object o = eq.getExpression2().evaluate(null);
        Assert.assertTrue((boolean)(o instanceof Date));
        Date d = (Date)o;
        Assert.assertEquals((Object)expected, (Object)d);
    }

    private void testComparison(String testPredicate) throws CQLException {
        Filter expected = FilterECQLSample.getSample(testPredicate);
        Filter actual = this.parseFilter(testPredicate);
        Assert.assertNotNull((String)"expects filter not null", (Object)actual);
        Assert.assertEquals((String)"compare filter error", (Object)expected, (Object)actual);
    }
}

