/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.ecql;

import java.util.Set;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.Id;
import org.geotools.api.filter.Not;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.junit.Assert;
import org.junit.Test;

public class ECQLIDPredicateTest {
    @Test
    public void filterIdWithListOfIdValues() throws Exception {
        String strId1 = "states.1";
        String strId2 = "states.2";
        String strId3 = "states.3";
        Filter filter = ECQL.toFilter((String)"IN ('states.1','states.2', 'states.3')");
        Assert.assertNotNull((Object)filter);
        Assert.assertTrue((boolean)(filter instanceof Id));
        Id filterId = (Id)filter;
        Set resultIdentifiers = filterId.getIDs();
        Assert.assertEquals((String)"one id in filter Id was expected", (long)3L, (long)resultIdentifiers.size());
        Assert.assertTrue((String)"states.1 was expected", (boolean)resultIdentifiers.contains("states.1"));
        Assert.assertTrue((String)"states.2 was expected", (boolean)resultIdentifiers.contains("states.2"));
        Assert.assertTrue((String)"states.3 was expected", (boolean)resultIdentifiers.contains("states.3"));
    }

    @Test
    public void notFilterId() throws Exception {
        String strId1 = "states.1";
        String strId2 = "states.2";
        String strId3 = "states.3";
        Filter filter = ECQL.toFilter((String)"NOT IN ('states.1','states.2', 'states.3')");
        Assert.assertNotNull((Object)filter);
        Assert.assertTrue((String)"Not filter was expected", (boolean)(filter instanceof Not));
        Assert.assertTrue((boolean)(filter instanceof Not));
        Not notFilter = (Not)filter;
        filter = notFilter.getFilter();
        Assert.assertTrue((boolean)(filter instanceof Id));
        Id filterId = (Id)filter;
        Set resultIdentifiers = filterId.getIDs();
        Assert.assertEquals((String)"one id in filter Id was expected", (long)3L, (long)resultIdentifiers.size());
        Assert.assertTrue((String)"states.1 was expected", (boolean)resultIdentifiers.contains("states.1"));
        Assert.assertTrue((String)"states.2 was expected", (boolean)resultIdentifiers.contains("states.2"));
        Assert.assertTrue((String)"states.3 was expected", (boolean)resultIdentifiers.contains("states.3"));
    }

    @Test
    public void idUsingIntegerValues() throws Exception {
        String strId1 = "1";
        String strId2 = "2";
        String strId3 = "3";
        Filter filter = ECQL.toFilter((String)"IN (1,2, 3)");
        Id filterId = (Id)filter;
        Set resultIdentifiers = filterId.getIDs();
        Assert.assertEquals((String)"one id in filter Id was expected", (long)3L, (long)resultIdentifiers.size());
        Assert.assertTrue((String)"1 was expected", (boolean)resultIdentifiers.contains("1"));
        Assert.assertTrue((String)"2 was expected", (boolean)resultIdentifiers.contains("2"));
        Assert.assertTrue((String)"3 was expected", (boolean)resultIdentifiers.contains("3"));
    }

    @Test
    public void IdUsingDateValues() throws Exception {
        String date1 = "2010-01-01";
        String date2 = "2010-02-02";
        String date3 = "2010-03-03";
        Filter filter = ECQL.toFilter((String)"IN ('2010-01-01','2010-02-02', '2010-03-03')");
        Assert.assertNotNull((Object)filter);
        Assert.assertTrue((String)"Not filter was expected", (boolean)(filter instanceof Id));
        Id filterId = (Id)filter;
        Set resultIdentifiers = filterId.getIDs();
        Assert.assertEquals((String)"one id in filter Id was expected", (long)3L, (long)resultIdentifiers.size());
        Assert.assertTrue((String)"2010-01-01 was expected", (boolean)resultIdentifiers.contains("2010-01-01"));
        Assert.assertTrue((String)"2010-02-02 was expected", (boolean)resultIdentifiers.contains("2010-02-02"));
        Assert.assertTrue((String)"2010-03-03 was expected", (boolean)resultIdentifiers.contains("2010-03-03"));
    }

    @Test
    public void IdUsingTimeStamp() throws Exception {
        String timeStamp1 = "2010-01-01 00:01:01";
        String timeStamp2 = "2010-02-02 00:01:01";
        String timeStamp3 = "2010-03-03 00:01:01";
        Filter filter = ECQL.toFilter((String)"IN ('2010-01-01 00:01:01','2010-02-02 00:01:01', '2010-03-03 00:01:01')");
        Assert.assertNotNull((Object)filter);
        Assert.assertTrue((String)"Not filter was expected", (boolean)(filter instanceof Id));
        Id filterId = (Id)filter;
        Set resultIdentifiers = filterId.getIDs();
        Assert.assertEquals((String)"one id in filter Id was expected", (long)3L, (long)resultIdentifiers.size());
        Assert.assertTrue((String)"2010-01-01 00:01:01 was expected", (boolean)resultIdentifiers.contains("2010-01-01 00:01:01"));
        Assert.assertTrue((String)"2010-02-02 00:01:01 was expected", (boolean)resultIdentifiers.contains("2010-02-02 00:01:01"));
        Assert.assertTrue((String)"2010-03-03 00:01:01 was expected", (boolean)resultIdentifiers.contains("2010-03-03 00:01:01"));
    }

    @Test
    public void filterIdSimple() throws Exception {
        this.assertFilterId("15521.3566");
        this.assertFilterId("fid-_df58120_11814e5d8b3__7ffb");
        this.assertFilterId("states.1");
    }

    private void assertFilterId(String idValue) throws CQLException {
        String strId = "'" + idValue + "'";
        Filter filter = ECQL.toFilter((String)("IN (" + strId + ")"));
        Assert.assertNotNull((Object)filter);
        Assert.assertTrue((boolean)(filter instanceof Id));
        Id filterId = (Id)filter;
        Set idSet = filterId.getIDs();
        Assert.assertEquals((String)"one id in filter Id was expected", (long)1L, (long)idSet.size());
        Assert.assertTrue((String)(idValue + "was expected"), (boolean)idSet.contains(idValue));
    }

    @Test(expected=CQLException.class)
    public void filterIdSyntaxError() throws CQLException {
        String strId = "IN 15521.3566";
        ECQL.toFilter((String)strId);
    }

    @Test
    public void deprecatedSyntax() throws Exception {
        Filter filter = ECQL.toFilter((String)"ID IN ('river.1', 'river.2')");
        Assert.assertTrue((boolean)(filter instanceof Id));
    }

    @Test
    public void propertyNameIdIsBeingDelimited() {
        try {
            ECQL.toFilter((String)"id = 'river.3'");
            Assert.fail();
        }
        catch (CQLException cQLException) {
            // empty catch block
        }
        try {
            ECQL.toFilter((String)"Id = 'river.3'");
            Assert.fail();
        }
        catch (CQLException cQLException) {
            // empty catch block
        }
        try {
            ECQL.toFilter((String)"iD = 'river.3'");
            Assert.fail();
        }
        catch (CQLException cQLException) {
            // empty catch block
        }
        try {
            ECQL.toFilter((String)"ID = 'river.3'");
            Assert.fail();
        }
        catch (CQLException cQLException) {
            // empty catch block
        }
        ECQLIDPredicateTest.assertToFilterToECQLEquals("\"id\" = 'river.3'");
        ECQLIDPredicateTest.assertToFilterToECQLEquals("\"Id\" = 'river.3'");
        ECQLIDPredicateTest.assertToFilterToECQLEquals("\"iD\" = 'river.3'");
        ECQLIDPredicateTest.assertToFilterToECQLEquals("\"ID\" = 'river.3'");
    }

    private static void assertToFilterToECQLEquals(String ecqlPredicate) {
        try {
            Filter filter = ECQL.toFilter((String)ecqlPredicate);
            Assert.assertEquals((Object)ecqlPredicate, (Object)ECQL.toCQL((Filter)filter));
        }
        catch (CQLException e) {
            Assert.fail();
        }
    }
}

