/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.ecql;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.Or;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.junit.Assert;
import org.junit.Test;

public class ECQLINPredicateTest {
    @Test
    public void oneIntegerLiteralInList() throws CQLException {
        LinkedList<String> intList = new LinkedList<String>();
        intList.add("4100001");
        String propName = "length";
        String txtPredicate = this.makeInPredicate(propName, intList);
        Filter filter = this.parseFilter(txtPredicate);
        this.commonAssertForInPredicate(filter);
        this.assertFilterHasProperty((Or)filter, propName);
    }

    @Test
    public void manyIntegerLiteralInList() throws CQLException {
        LinkedList<String> intList = new LinkedList<String>();
        String v1 = "4100001";
        intList.add(v1);
        String v2 = "4100002";
        intList.add(v2);
        String v3 = "4100003";
        intList.add(v3);
        String propName = "length";
        String txtPredicate = this.makeInPredicate(propName, intList);
        Filter filter = this.parseFilter(txtPredicate);
        this.commonAssertForInPredicate(filter);
        this.assertFilterHasProperty((Or)filter, propName);
    }

    @Test
    public void manyStringLiteralInList() throws CQLException {
        LinkedList<String> stringList = new LinkedList<String>();
        String v1 = "one";
        stringList.add(v1);
        String v2 = "two";
        stringList.add(v2);
        String v3 = "three";
        stringList.add(v3);
        String propName = "name";
        String txtPredicate = this.makeInPredicateUsingString(propName, stringList);
        Filter filter = this.parseFilter(txtPredicate);
        this.commonAssertForInPredicate(filter);
        this.assertFilterHasProperty((Or)filter, propName);
    }

    @Test
    public void binaryExpression() throws CQLException {
        LinkedList<String> mathExptList = new LinkedList<String>();
        mathExptList.add("(1+2)");
        mathExptList.add("3-4");
        mathExptList.add("[5*6]");
        String propName = "length";
        String txtPredicate = this.makeInPredicate(propName, mathExptList);
        Filter filter = this.parseFilter(txtPredicate);
        this.commonAssertForInPredicate(filter);
        this.assertFilterHasProperty((Or)filter, propName);
    }

    protected Filter parseFilter(String txtPredicate) throws CQLException {
        return ECQL.toFilter((String)txtPredicate);
    }

    @Test
    public void functions() throws CQLException {
        LinkedList<String> intList = new LinkedList<String>();
        intList.add("abs(-1)");
        intList.add("area(the_geom)");
        String propName = "length";
        String txtPredicate = this.makeInPredicate(propName, intList);
        Filter filter = this.parseFilter(txtPredicate);
        this.commonAssertForInPredicate(filter);
        this.assertFilterHasProperty((Or)filter, propName);
    }

    protected void commonAssertForInPredicate(Filter filter) throws CQLException {
        Assert.assertNotNull((Object)filter);
        Assert.assertTrue((boolean)(filter instanceof Or));
        Or filterId = (Or)filter;
        List filterList = filterId.getChildren();
        Assert.assertFalse((String)"one or more expressions in Or filter was expected", (boolean)filterList.isEmpty());
    }

    protected void assertFilterHasProperty(Or filter, String expectedName) {
        List filterlist = filter.getChildren();
        for (Filter f : filterlist) {
            PropertyIsEqualTo eq = (PropertyIsEqualTo)f;
            Expression expr = eq.getExpression1();
            Assert.assertTrue((boolean)(expr instanceof PropertyName));
            PropertyName actualName = (PropertyName)expr;
            Assert.assertEquals((Object)expectedName, (Object)actualName.toString());
        }
    }

    protected String makeInPredicate(String propName, List<String> exprList) {
        StringBuffer txtExprList = new StringBuffer();
        Iterator<String> iterator = exprList.iterator();
        while (iterator.hasNext()) {
            String literal = iterator.next();
            txtExprList.append(literal);
            if (!iterator.hasNext()) continue;
            txtExprList.append(",");
        }
        String txtPredicate = propName + " IN (" + txtExprList + ")";
        return txtPredicate;
    }

    private String makeInPredicateUsingString(String propName, List<String> exprList) {
        StringBuffer txtExprList = new StringBuffer();
        Iterator<String> iterator = exprList.iterator();
        while (iterator.hasNext()) {
            String literal = iterator.next();
            txtExprList.append("'").append(literal).append("'");
            if (!iterator.hasNext()) continue;
            txtExprList.append(",");
        }
        String txtPredicate = propName + " IN (" + txtExprList + ")";
        return txtPredicate;
    }
}

