/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.ecql;

import org.geotools.api.filter.Filter;
import org.geotools.api.filter.Not;
import org.geotools.api.filter.PropertyIsLike;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.filter.LikeFilterImpl;
import org.geotools.filter.text.commons.Language;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.cql2.CQLLikePredicateTest;
import org.geotools.filter.text.ecql.FilterECQLSample;
import org.junit.Assert;
import org.junit.Test;

public class ECQLLikePredicateTest
extends CQLLikePredicateTest {
    public ECQLLikePredicateTest() {
        super(Language.ECQL);
    }

    @Test
    public void functionlikePredicate() throws Exception {
        Filter resultFilter = this.parseFilter("strConcat('aa', 'bbcc') like '%bb%'");
        Assert.assertNotNull((String)"Filter expected", (Object)resultFilter);
        Assert.assertTrue((boolean)(resultFilter instanceof PropertyIsLike));
        PropertyIsLike expected = (PropertyIsLike)FilterECQLSample.getSample("strConcat('aa', 'bbcc') like '%bb%'");
        Assert.assertEquals((String)"like filter was expected", (Object)expected, (Object)resultFilter);
        resultFilter = this.parseFilter("strToUpperCase(anAttribute) like '%BB%'");
        Assert.assertTrue((boolean)(resultFilter instanceof PropertyIsLike));
        PropertyIsLike resultLike = (PropertyIsLike)resultFilter;
        Expression resultExpression = resultLike.getExpression();
        Assert.assertTrue((boolean)(resultExpression instanceof Function));
        Function resultFunction = (Function)resultExpression;
        Assert.assertEquals((Object)"strToUpperCase", (Object)resultFunction.getName());
        Assert.assertEquals((Object)resultLike.getLiteral(), (Object)"%BB%");
    }

    @Test
    public void functionAndPatternWithSpanishCharacter() throws CQLException {
        Filter resultFilter = this.parseFilter("strToUpperCase(anAttribute) like '%a\u00f1o%'");
        Assert.assertTrue((boolean)(resultFilter instanceof PropertyIsLike));
        PropertyIsLike resultLike = (PropertyIsLike)resultFilter;
        Expression resultExpression = resultLike.getExpression();
        Assert.assertTrue((boolean)(resultExpression instanceof Function));
        Function resultFunction = (Function)resultExpression;
        Assert.assertEquals((Object)"strToUpperCase", (Object)resultFunction.getName());
        Assert.assertEquals((Object)resultLike.getLiteral(), (Object)"%a\u00f1o%");
    }

    @Test
    public void likePredicateCaseSensitive() throws Exception {
        Filter resultFilter = this.parseFilter("ATTR1 LIKE 'abc%'");
        Assert.assertNotNull((String)"Filter expected", (Object)resultFilter);
        Assert.assertTrue((boolean)(resultFilter instanceof LikeFilterImpl));
        LikeFilterImpl likeFilter = (LikeFilterImpl)resultFilter;
        Assert.assertTrue((boolean)likeFilter.isMatchingCase());
    }

    @Test
    public void ilikePredicate() throws Exception {
        Filter resultFilter = this.parseFilter("ATTR1 ILIKE 'abc%'");
        Assert.assertNotNull((String)"Filter expected", (Object)resultFilter);
        Assert.assertTrue((boolean)(resultFilter instanceof LikeFilterImpl));
        LikeFilterImpl likeFilter = (LikeFilterImpl)resultFilter;
        Assert.assertFalse((boolean)likeFilter.isMatchingCase());
    }

    @Test
    public void notilikePredicate() throws Exception {
        Filter resultFilter = this.parseFilter("not ATTR1 ILIKE 'abc%'");
        Not notFilter = (Not)resultFilter;
        LikeFilterImpl likeFilter = (LikeFilterImpl)notFilter.getFilter();
        Assert.assertFalse((boolean)likeFilter.isMatchingCase());
    }

    @Test
    public void literallikePredicate() throws Exception {
        Filter resultFilter = this.parseFilter("'aabbcc' LIKE '%bb%'");
        Assert.assertNotNull((String)"Filter expected", (Object)resultFilter);
        Assert.assertTrue((boolean)(resultFilter instanceof PropertyIsLike));
        PropertyIsLike expected = (PropertyIsLike)FilterECQLSample.getSample("'aabbcc' LIKE '%bb%'");
        Assert.assertEquals((String)"like filter was expected", (Object)expected, (Object)resultFilter);
    }

    @Test
    public void literalNotlikePredicate() throws Exception {
        Filter resultFilter = this.parseFilter("'aabbcc' not like '%bb%'");
        Assert.assertNotNull((String)"Filter expected", (Object)resultFilter);
        Assert.assertTrue((boolean)(resultFilter instanceof Not));
        Not expected = (Not)FilterECQLSample.getSample("'aabbcc' not like '%bb%'");
        Assert.assertTrue((boolean)(expected.getFilter() instanceof PropertyIsLike));
        Assert.assertEquals((String)"like filter was expected", (Object)expected, (Object)resultFilter);
    }
}

