/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.ecql;

import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.spatial.Beyond;
import org.geotools.api.filter.spatial.DistanceBufferOperator;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.function.FilterFunction_buffer;
import org.geotools.filter.text.commons.CompilerUtil;
import org.geotools.filter.text.commons.Language;
import org.geotools.filter.text.cql2.CQLRelGeoOpTest;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Geometry;

public class ECQLRelGeoOpTest
extends CQLRelGeoOpTest {
    protected static final FilterFactory FILTER_FACTORY = CommonFactoryFinder.getFilterFactory(null);

    public ECQLRelGeoOpTest() {
        super(Language.ECQL);
    }

    @Test
    public void functionDwithinGeometry() throws Exception {
        Filter resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"DWITHIN(buffer(the_geom,5), POINT(1 2), 10, kilometers)");
        Assert.assertTrue((boolean)(resultFilter instanceof DistanceBufferOperator));
        DistanceBufferOperator distOp = (DistanceBufferOperator)resultFilter;
        Assert.assertTrue((boolean)(distOp.getExpression1() instanceof FilterFunction_buffer));
        Assert.assertTrue((boolean)(distOp.getExpression2() instanceof Literal));
    }

    @Test
    public void functionDwithinFunction() throws Exception {
        Filter filter = CompilerUtil.parseFilter((Language)this.language, (String)"DWITHIN(buffer(the_geom,5), buffer(the_geom,2), 10, kilometers)");
        Assert.assertTrue((boolean)(filter instanceof DistanceBufferOperator));
        DistanceBufferOperator distOp = (DistanceBufferOperator)filter;
        Assert.assertTrue((boolean)(distOp.getExpression1() instanceof FilterFunction_buffer));
        Assert.assertTrue((boolean)(distOp.getExpression2() instanceof FilterFunction_buffer));
    }

    @Test
    public void geometryDwithinGeometry() throws Exception {
        Filter resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"DWITHIN(POINT(5 7), POINT(1 2), 10, kilometers)");
        Assert.assertTrue((boolean)(resultFilter instanceof DistanceBufferOperator));
    }

    @Test
    public void geometryBeyondGeometry() throws Exception {
        Filter resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"BEYOND(POINT(5.0 7.0), POINT(1.0 2.0), 10.0, kilometers)");
        Assert.assertTrue((boolean)(resultFilter instanceof Beyond));
        Beyond beyondFilter = (Beyond)resultFilter;
        Literal literal1 = (Literal)beyondFilter.getExpression1();
        Assert.assertTrue((boolean)(literal1.getValue() instanceof Geometry));
        Literal literal2 = (Literal)beyondFilter.getExpression2();
        Assert.assertTrue((boolean)(literal2.getValue() instanceof Geometry));
    }

    @Test
    public void functionBeyondFunction() throws Exception {
        Filter resultFilter = CompilerUtil.parseFilter((Language)this.language, (String)"BEYOND(buffer(geom1,3), buffer(geom2, 4), 10.0, kilometers)");
        Assert.assertTrue((boolean)(resultFilter instanceof Beyond));
        Beyond beyondFilter = (Beyond)resultFilter;
        Expression expr1 = beyondFilter.getExpression1();
        Assert.assertTrue((boolean)(expr1 instanceof FilterFunction_buffer));
        Expression expr2 = beyondFilter.getExpression2();
        Assert.assertTrue((boolean)(expr2 instanceof FilterFunction_buffer));
    }
}

