/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.cqljson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.awt.Color;
import java.sql.Date;
import java.time.Instant;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.geotools.api.filter.expression.Add;
import org.geotools.api.filter.expression.BinaryExpression;
import org.geotools.api.filter.expression.Divide;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.Multiply;
import org.geotools.api.filter.expression.NilExpression;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.expression.Subtract;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.api.temporal.Period;
import org.geotools.data.geojson.GeoJSONWriter;
import org.geotools.util.Converters;
import org.locationtech.jts.geom.Geometry;

public class ExpressionToCQL2Json
implements ExpressionVisitor {
    private ObjectMapper objectMapper;

    public ExpressionToCQL2Json(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public Object visit(NilExpression expression, Object extraData) {
        throw new UnsupportedOperationException("PropertyIsNil not supported");
    }

    public Object visit(Add expression, Object extraData) {
        return this.buildBinaryExpression((BinaryExpression)expression, extraData, "+");
    }

    private Object buildBinaryExpression(BinaryExpression binaryExpression, Object extraData, String opName) {
        ArrayNode output = this.asArrayNode(extraData);
        ArrayNode args = this.objectMapper.createArrayNode();
        binaryExpression.getExpression1().accept((ExpressionVisitor)this, (Object)args);
        binaryExpression.getExpression2().accept((ExpressionVisitor)this, (Object)args);
        ObjectNode objectNode = this.objectMapper.createObjectNode();
        objectNode.put("op", opName);
        objectNode.set("args", (JsonNode)args);
        output.add((JsonNode)objectNode);
        return output;
    }

    public Object visit(Divide expression, Object extraData) {
        return this.buildBinaryExpression((BinaryExpression)expression, extraData, "/");
    }

    public Object visit(Function expression, Object extraData) {
        ArrayNode output = this.asArrayNode(extraData);
        ObjectNode functionNode = this.objectMapper.createObjectNode();
        ObjectNode functionDetails = this.objectMapper.createObjectNode();
        functionDetails.put("name", expression.getName());
        ArrayNode args = this.objectMapper.createArrayNode();
        for (Expression parameter : expression.getParameters()) {
            parameter.accept((ExpressionVisitor)this, (Object)args);
        }
        functionDetails.set("args", (JsonNode)args);
        functionNode.set("function", (JsonNode)functionDetails);
        output.add((JsonNode)functionNode);
        return output;
    }

    public Object visit(Multiply expression, Object extraData) {
        return this.buildBinaryExpression((BinaryExpression)expression, extraData, "*");
    }

    public Object visit(PropertyName expression, Object extraData) {
        ArrayNode output = this.asArrayNode(extraData);
        ObjectNode propertyName = this.objectMapper.createObjectNode();
        propertyName.put("property", expression.getPropertyName());
        output.add((JsonNode)propertyName);
        return output;
    }

    public Object visit(Subtract expression, Object extraData) {
        return this.buildBinaryExpression((BinaryExpression)expression, extraData, "-");
    }

    public Object visit(Literal expression, Object extraData) {
        ArrayNode output = this.asArrayNode(extraData);
        if (expression.getValue() instanceof Number) {
            this.toNumber(output, (Number)expression.getValue());
        } else if (expression.getValue() instanceof Geometry) {
            this.toGeoJSON(output, (Geometry)expression.getValue());
        } else if (expression.getValue() instanceof BoundingBox) {
            this.toGeoJSON(output, (BoundingBox)expression.getValue());
        } else if (expression.getValue() instanceof Date) {
            this.toDate(output, (Date)expression.getValue());
        } else if (expression.getValue() instanceof java.util.Date || expression.getValue() instanceof Instant) {
            this.toTimestamp(output, expression.getValue());
        } else if (expression.getValue() instanceof Period) {
            this.toPeriod(output, (Period)expression.getValue());
        } else if (expression.getValue() instanceof Color) {
            this.toColor(output, (Color)expression.getValue());
        } else if (expression.getValue() instanceof Boolean) {
            output.add((Boolean)expression.getValue());
        } else {
            if (expression.getValue() == null) {
                throw new NullPointerException("CQL2-JSON does not support null literal value");
            }
            output.add(expression.getValue().toString());
        }
        return output;
    }

    private void toColor(ArrayNode output, Color value) {
        Color color = value;
        StringBuilder stringBuilder = new StringBuilder();
        String redCode = Integer.toHexString(color.getRed());
        String greenCode = Integer.toHexString(color.getGreen());
        String blueCode = Integer.toHexString(color.getBlue());
        stringBuilder.append("'#");
        if (redCode.length() == 1) {
            stringBuilder.append("0");
        }
        stringBuilder.append(redCode.toUpperCase());
        if (greenCode.length() == 1) {
            stringBuilder.append("0");
        }
        stringBuilder.append(greenCode.toUpperCase());
        if (blueCode.length() == 1) {
            stringBuilder.append("0");
        }
        stringBuilder.append(blueCode.toUpperCase());
        output.add(stringBuilder.toString());
    }

    private void toPeriod(ArrayNode output, Period period) {
        if (period != null) {
            String date1 = this.toTimestampText(period.getBeginning().getPosition().getDate());
            String date2 = this.toTimestampText(period.getEnding().getPosition().getDate());
            ObjectNode intervalNode = this.objectMapper.createObjectNode();
            ArrayNode arrayNode = this.objectMapper.createArrayNode();
            arrayNode.add(date1);
            arrayNode.add(date2);
            intervalNode.set("interval", (JsonNode)arrayNode);
        }
    }

    private void toDate(ArrayNode output, Date value) {
        if (value != null) {
            ObjectNode dateNode = this.objectMapper.createObjectNode();
            dateNode.put("date", this.toDateText(value));
            output.add((JsonNode)dateNode);
        }
    }

    private String toDateText(Date value) {
        LocalDate localDate = value.toLocalDate();
        return localDate.format(DateTimeFormatter.ISO_LOCAL_DATE);
    }

    private void toTimestamp(ArrayNode output, Object value) {
        if (value != null) {
            ObjectNode dateNode = this.objectMapper.createObjectNode();
            dateNode.put("timestamp", this.toTimestampText(value));
            output.add((JsonNode)dateNode);
        }
    }

    private String toTimestampText(Object value) {
        java.util.Date date = (java.util.Date)Converters.convert((Object)value, java.util.Date.class);
        return DateTimeFormatter.ISO_INSTANT.format(date.toInstant());
    }

    private void toGeoJSON(ArrayNode output, Geometry value) {
        try {
            if (value.isRectangle()) {
                ObjectNode bboxNode = this.objectMapper.createObjectNode();
                ArrayNode coords = this.objectMapper.createArrayNode();
                coords.add(value.getEnvelopeInternal().getMinX());
                coords.add(value.getEnvelopeInternal().getMinY());
                coords.add(value.getEnvelopeInternal().getMaxX());
                coords.add(value.getEnvelopeInternal().getMaxY());
                bboxNode.set("bbox", (JsonNode)coords);
                output.add((JsonNode)bboxNode);
            } else {
                output.add(this.objectMapper.readTree(GeoJSONWriter.toGeoJSON((Geometry)value)));
            }
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Unable to convert Geometry into GeoJSON while building CQL2-JSON");
        }
    }

    private void toGeoJSON(ArrayNode arrayNode, BoundingBox value) {
        ObjectNode bboxNode = this.objectMapper.createObjectNode();
        ArrayNode coords = this.objectMapper.createArrayNode();
        coords.add(value.getMinX());
        coords.add(value.getMinY());
        coords.add(value.getMaxX());
        coords.add(value.getMaxY());
        bboxNode.set("bbox", (JsonNode)coords);
        arrayNode.add((JsonNode)bboxNode);
    }

    private void toNumber(ArrayNode arrayNode, Number value) {
        if (value.doubleValue() % 1.0 == 0.0) {
            arrayNode.add(value.intValue());
        } else {
            arrayNode.add(value.doubleValue());
        }
    }

    private ArrayNode asArrayNode(Object extraData) {
        if (extraData instanceof ArrayNode) {
            return (ArrayNode)extraData;
        }
        return this.objectMapper.createArrayNode();
    }
}

