/*
 * Decompiled with CFR 0.152.
 */
package org.geootols.filter.text.cql_2;

import java.util.Iterator;
import java.util.List;
import org.geootols.filter.text.cql_2.CQL2ExpressionToText;
import org.geotools.filter.text.commons.ExpressionToText;
import org.geotools.filter.text.commons.FilterToTextUtil;
import org.opengis.filter.And;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.BinaryLogicOperator;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNil;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import org.opengis.filter.temporal.After;
import org.opengis.filter.temporal.AnyInteracts;
import org.opengis.filter.temporal.Before;
import org.opengis.filter.temporal.Begins;
import org.opengis.filter.temporal.BegunBy;
import org.opengis.filter.temporal.BinaryTemporalOperator;
import org.opengis.filter.temporal.During;
import org.opengis.filter.temporal.EndedBy;
import org.opengis.filter.temporal.Ends;
import org.opengis.filter.temporal.Meets;
import org.opengis.filter.temporal.MetBy;
import org.opengis.filter.temporal.OverlappedBy;
import org.opengis.filter.temporal.TContains;
import org.opengis.filter.temporal.TEquals;
import org.opengis.filter.temporal.TOverlaps;
import org.opengis.geometry.BoundingBox;

final class FilterToCQL2
implements FilterVisitor {
    ExpressionToText expressionVisitor = new CQL2ExpressionToText();

    public Object visitNullFilter(Object extraData) {
        throw new NullPointerException("Cannot encode null as a Filter");
    }

    public Object visit(ExcludeFilter filter, Object extraData) {
        return FilterToTextUtil.buildExclude((Object)extraData);
    }

    public Object visit(IncludeFilter filter, Object extraData) {
        return FilterToTextUtil.buildInclude((Object)extraData);
    }

    public Object visit(And filter, Object extraData) {
        return FilterToTextUtil.buildBinaryLogicalOperator((String)"AND", (FilterVisitor)this, (BinaryLogicOperator)filter, (Object)extraData);
    }

    public Object visit(Id filter, Object extraData) {
        throw FilterToCQL2.unsupported("ID");
    }

    public Object visit(Not filter, Object extraData) {
        return FilterToTextUtil.buildNot((FilterVisitor)this, (Not)filter, (Object)extraData);
    }

    public Object visit(Or filter, Object extraData) {
        if (this.isInFilter(filter)) {
            return this.buildIN(filter, extraData);
        }
        return FilterToTextUtil.buildBinaryLogicalOperator((String)"OR", (FilterVisitor)this, (BinaryLogicOperator)filter, (Object)extraData);
    }

    private boolean isInFilter(Or filter) {
        if (filter.getChildren() == null) {
            return false;
        }
        Expression left = null;
        for (Filter child : filter.getChildren()) {
            if (child instanceof PropertyIsEqualTo) {
                PropertyIsEqualTo equal = (PropertyIsEqualTo)child;
                if (left == null) {
                    left = equal.getExpression1();
                    continue;
                }
                if (left.equals(equal.getExpression1())) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private Object buildIN(Or filter, Object extraData) {
        StringBuilder output = FilterToTextUtil.asStringBuilder((Object)extraData);
        List children = filter.getChildren();
        PropertyIsEqualTo first = (PropertyIsEqualTo)filter.getChildren().get(0);
        Expression left = first.getExpression1();
        left.accept((ExpressionVisitor)this.expressionVisitor, (Object)output);
        output.append(" IN (");
        Iterator i = children.iterator();
        while (i.hasNext()) {
            PropertyIsEqualTo child = (PropertyIsEqualTo)i.next();
            Expression right = child.getExpression2();
            right.accept((ExpressionVisitor)this.expressionVisitor, (Object)output);
            if (!i.hasNext()) continue;
            output.append(",");
        }
        output.append(")");
        return output;
    }

    public Object visit(PropertyIsBetween filter, Object extraData) {
        return FilterToTextUtil.buildBetween((PropertyIsBetween)filter, (Object)extraData);
    }

    public Object visit(PropertyIsEqualTo filter, Object extraData) {
        StringBuilder output = FilterToTextUtil.asStringBuilder((Object)extraData);
        if (this.isRelateOperation(filter)) {
            return this.buildRelate(filter, output);
        }
        if (this.isFunctionTrue(filter, "PropertyExists", 1)) {
            return this.buildExists(filter, output);
        }
        return FilterToTextUtil.buildComparison((BinaryComparisonOperator)filter, (Object)output, (String)"=");
    }

    private boolean isFunctionTrue(PropertyIsEqualTo filter, String operation, int numberOfArguments) {
        if (filter.getExpression1() instanceof Function) {
            Function function = (Function)filter.getExpression1();
            List parameters = function.getParameters();
            if (parameters == null) {
                return false;
            }
            String name = function.getName();
            if (!operation.equalsIgnoreCase(name) || parameters.size() != numberOfArguments) {
                return false;
            }
        } else {
            return false;
        }
        if (filter.getExpression2() instanceof Literal) {
            Literal literal = (Literal)filter.getExpression2();
            Boolean value = (Boolean)literal.evaluate(null, Boolean.class);
            return value != null && value != false;
        }
        return false;
    }

    private Object buildExists(PropertyIsEqualTo filter, StringBuilder output) {
        Function function = (Function)filter.getExpression1();
        List parameters = function.getParameters();
        Literal arg = (Literal)parameters.get(0);
        output.append(arg.getValue());
        output.append(" EXISTS");
        return output;
    }

    private boolean isRelateOperation(PropertyIsEqualTo filter) {
        if (this.isFunctionTrue(filter, "relatePattern", 3)) {
            Literal literal;
            Object value;
            Function function = (Function)filter.getExpression1();
            List parameters = function.getParameters();
            Expression param3 = (Expression)parameters.get(2);
            return !(param3 instanceof Literal) || (value = (literal = (Literal)param3).getValue()) instanceof String;
        }
        return false;
    }

    private Object buildRelate(PropertyIsEqualTo filter, StringBuilder output) {
        Function operation = (Function)filter.getExpression1();
        output.append("RELATE(");
        List parameters = operation.getParameters();
        Expression arg1 = (Expression)parameters.get(0);
        Expression arg2 = (Expression)parameters.get(1);
        Literal arg3 = (Literal)parameters.get(2);
        arg1.accept((ExpressionVisitor)this.expressionVisitor, (Object)output);
        output.append(",");
        arg2.accept((ExpressionVisitor)this.expressionVisitor, (Object)output);
        output.append(",");
        output.append(arg3.getValue());
        output.append(")");
        return output;
    }

    public Object visit(PropertyIsNotEqualTo filter, Object extraData) {
        return FilterToTextUtil.buildComparison((BinaryComparisonOperator)filter, (Object)extraData, (String)"<>");
    }

    public Object visit(PropertyIsGreaterThan filter, Object extraData) {
        return FilterToTextUtil.buildComparison((BinaryComparisonOperator)filter, (Object)extraData, (String)">");
    }

    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object extraData) {
        return FilterToTextUtil.buildComparison((BinaryComparisonOperator)filter, (Object)extraData, (String)">=");
    }

    public Object visit(PropertyIsLessThan filter, Object extraData) {
        return FilterToTextUtil.buildComparison((BinaryComparisonOperator)filter, (Object)extraData, (String)"<");
    }

    public Object visit(PropertyIsLessThanOrEqualTo filter, Object extraData) {
        return FilterToTextUtil.buildComparison((BinaryComparisonOperator)filter, (Object)extraData, (String)"<=");
    }

    public Object visit(PropertyIsLike filter, Object extraData) {
        return FilterToTextUtil.buildIsLike((PropertyIsLike)filter, (Object)extraData);
    }

    public Object visit(PropertyIsNull filter, Object extraData) {
        return FilterToTextUtil.buildIsNull((PropertyIsNull)filter, (Object)extraData);
    }

    public Object visit(PropertyIsNil filter, Object extraData) {
        throw new UnsupportedOperationException("PropertyIsNil not supported");
    }

    public Object visit(BBOX filter, Object extraData) {
        StringBuilder output = FilterToTextUtil.asStringBuilder((Object)extraData);
        BoundingBox bounds = filter.getBounds();
        output.append("S_INTERSECTS(");
        output.append(((PropertyName)filter.getExpression1()).getPropertyName());
        output.append(", ENVELOPE(");
        output.append(bounds.getMinX());
        output.append(",");
        output.append(bounds.getMinY());
        output.append(",");
        output.append(bounds.getMaxX());
        output.append(",");
        output.append(bounds.getMaxY());
        output.append("))");
        return output;
    }

    public Object visit(Beyond filter, Object extraData) {
        throw FilterToCQL2.unsupported("BEYOND");
    }

    public Object visit(Contains filter, Object extraData) {
        return FilterToTextUtil.buildBinarySpatialOperator((String)"S_CONTAINS", (BinarySpatialOperator)filter, (Object)extraData, (ExpressionToText)this.expressionVisitor);
    }

    public Object visit(Crosses filter, Object extraData) {
        return FilterToTextUtil.buildBinarySpatialOperator((String)"S_CROSSES", (BinarySpatialOperator)filter, (Object)extraData, (ExpressionToText)this.expressionVisitor);
    }

    public Object visit(Disjoint filter, Object extraData) {
        return FilterToTextUtil.buildBinarySpatialOperator((String)"S_DISJOINT", (BinarySpatialOperator)filter, (Object)extraData, (ExpressionToText)this.expressionVisitor);
    }

    public Object visit(DWithin filter, Object extraData) {
        throw FilterToCQL2.unsupported("DWITHIN");
    }

    public Object visit(Equals filter, Object extraData) {
        return FilterToTextUtil.buildBinarySpatialOperator((String)"S_EQUALS", (BinarySpatialOperator)filter, (Object)extraData, (ExpressionToText)this.expressionVisitor);
    }

    public Object visit(Intersects filter, Object extraData) {
        return FilterToTextUtil.buildBinarySpatialOperator((String)"S_INTERSECTS", (BinarySpatialOperator)filter, (Object)extraData, (ExpressionToText)this.expressionVisitor);
    }

    public Object visit(Overlaps filter, Object extraData) {
        return FilterToTextUtil.buildBinarySpatialOperator((String)"S_OVERLAPS", (BinarySpatialOperator)filter, (Object)extraData, (ExpressionToText)this.expressionVisitor);
    }

    public Object visit(Touches filter, Object extraData) {
        return FilterToTextUtil.buildBinarySpatialOperator((String)"S_TOUCHES", (BinarySpatialOperator)filter, (Object)extraData, (ExpressionToText)this.expressionVisitor);
    }

    public Object visit(Within filter, Object extraData) {
        return FilterToTextUtil.buildBinarySpatialOperator((String)"S_WITHIN", (BinarySpatialOperator)filter, (Object)extraData, (ExpressionToText)this.expressionVisitor);
    }

    public Object visit(After after, Object extraData) {
        return this.buildBinaryTemporalOperator((BinaryTemporalOperator)after, extraData, "T_AFTER");
    }

    public Object visit(Before before, Object extraData) {
        return this.buildBinaryTemporalOperator((BinaryTemporalOperator)before, extraData, "T_BEFORE");
    }

    private Object buildBinaryTemporalOperator(BinaryTemporalOperator op, Object extraData, String opName) {
        StringBuilder output = FilterToTextUtil.asStringBuilder((Object)extraData);
        output.append(opName).append("(");
        CQL2ExpressionToText visitor = new CQL2ExpressionToText();
        op.getExpression1().accept((ExpressionVisitor)visitor, (Object)output);
        output.append(", ");
        op.getExpression2().accept((ExpressionVisitor)visitor, (Object)output);
        output.append(")");
        return output;
    }

    public Object visit(AnyInteracts anyInteracts, Object extraData) {
        throw FilterToCQL2.unsupported("AnyInteracts");
    }

    public Object visit(Begins begins, Object extraData) {
        throw FilterToCQL2.unsupported("Begins");
    }

    public Object visit(BegunBy begunBy, Object extraData) {
        throw FilterToCQL2.unsupported("BegunBy");
    }

    private static UnsupportedOperationException unsupported(String filterName) {
        return new UnsupportedOperationException("The" + filterName + " has not an CQL2 expression");
    }

    public Object visit(During during, Object extraData) {
        CQL2ExpressionToText visitor = new CQL2ExpressionToText();
        StringBuilder output = FilterToTextUtil.asStringBuilder((Object)extraData);
        output.append("T_DURING(");
        during.getExpression1().accept((ExpressionVisitor)visitor, (Object)output);
        output.append(", ");
        during.getExpression2().accept((ExpressionVisitor)visitor, (Object)output);
        output.append(")");
        return output;
    }

    public Object visit(EndedBy endedBy, Object extraData) {
        throw FilterToCQL2.unsupported("EndedBy");
    }

    public Object visit(Ends ends, Object extraData) {
        throw FilterToCQL2.unsupported("EndedBy");
    }

    public Object visit(Meets meets, Object extraData) {
        throw FilterToCQL2.unsupported("Meets");
    }

    public Object visit(MetBy metBy, Object extraData) {
        throw FilterToCQL2.unsupported("MetBy");
    }

    public Object visit(OverlappedBy overlappedBy, Object extraData) {
        throw FilterToCQL2.unsupported("OverlappedBy");
    }

    public Object visit(TContains contains, Object extraData) {
        throw FilterToCQL2.unsupported("TContains");
    }

    public Object visit(TEquals equals, Object extraData) {
        throw FilterToCQL2.unsupported("TContains");
    }

    public Object visit(TOverlaps contains, Object extraData) {
        throw FilterToCQL2.unsupported("TContains");
    }
}

