/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.cql_2.conformance;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.geootols.filter.text.cql_2.CQL2;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.DataStoreFinder;
import org.geotools.api.data.Query;
import org.geotools.api.filter.Filter;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.http.HTTPResponse;
import org.geotools.http.SimpleHttpClient;
import org.geotools.jdbc.JDBCFeatureSource;
import org.junit.Assert;
import org.junit.Test;

public abstract class ATSOnlineTest {
    private static String NE_DATA_URL = "https://github.com/opengeospatial/ogcapi-features/raw/refs/heads/master/cql2/standard/data/ne110m4cql2.gpkg";
    protected final File neGpkg = Path.of(System.getProperty("java.io.tmpdir"), "ne.gpkg").toFile();
    protected final String dataset;
    protected final Filter filter;
    protected final int expectedFeatures;

    protected ATSOnlineTest(String dataset, String criteria, int expectedFeatures) throws CQLException {
        this.dataset = dataset;
        this.filter = this.criteriaToFilter(criteria);
        this.expectedFeatures = expectedFeatures;
    }

    protected Filter criteriaToFilter(String criteria) throws CQLException {
        return CQL2.toFilter((String)criteria);
    }

    protected ATSOnlineTest(String dataset, Filter filter, int expectedFeatures) {
        this.dataset = dataset;
        this.filter = filter;
        this.expectedFeatures = expectedFeatures;
    }

    private void downloadNaturalEarthData() throws IOException {
        if (this.neGpkg.exists()) {
            return;
        }
        this.neGpkg.createNewFile();
        SimpleHttpClient client = new SimpleHttpClient();
        HTTPResponse r = client.get(new URL(NE_DATA_URL));
        FileUtils.copyInputStreamToFile((InputStream)r.getResponseStream(), (File)this.neGpkg);
    }

    protected DataStore naturalEarthData() throws IOException {
        this.downloadNaturalEarthData();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("dbtype", "geopkg");
        params.put("database", this.neGpkg.getAbsolutePath());
        params.put("read-only", true);
        DataStore datastore = DataStoreFinder.getDataStore(params);
        return datastore;
    }

    protected int featuresReturned(DataStore ds) throws CQLException, IOException {
        Query q = new Query(this.dataset);
        q.getHints().put((Object)JDBCFeatureSource.FILTER_THREE_WAY_LOGIC, (Object)Boolean.TRUE);
        q.setFilter(this.filter);
        return ds.getFeatureSource(this.dataset).getFeatures(q).size();
    }

    @Test
    public void testConformance() throws CQLException, IOException {
        DataStore ds = this.naturalEarthData();
        int feat = this.featuresReturned(ds);
        ds.dispose();
        Assert.assertEquals((String)this.filter.toString(), (long)this.expectedFeatures, (long)feat);
    }
}

