/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.cql_2.conformance;

import java.util.Arrays;
import java.util.Collection;
import org.geootols.filter.text.cql_2.CQL2;
import org.geotools.api.filter.Filter;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.cql_2.conformance.ATSOnlineTest;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ConformanceTest9OnlineTest
extends ATSOnlineTest {
    public ConformanceTest9OnlineTest(String p1, String p2, String p3, String p4, int expectedFeatures) throws CQLException {
        super("ne_110m_populated_places_simple", ConformanceTest9OnlineTest.toFilter(p1, p2, p3, p4), expectedFeatures);
    }

    protected ConformanceTest9OnlineTest(Filter filter, int expectedFeatures) throws CQLException {
        super("ne_110m_populated_places_simple", filter, expectedFeatures);
    }

    private static Filter toFilter(String p1, String p2, String p3, String p4) throws CQLException {
        String template = "(NOT (%s) AND %s) OR (%s and %s) or not (%s OR %s)";
        return CQL2.toFilter((String)String.format(template, p2, p1, p3, p4, p1, p4));
    }

    @Parameterized.Parameters(name="{index} {0} {1} {2} {3}")
    public static Collection<Object[]> params() {
        return Arrays.asList({"pop_other<>1038288", "name<>'K\u00f8benhavn'", "pop_other IS NULL", "name<'K\u00f8benhavn'", 1}, {"pop_other<>1038288", "name>'K\u00f8benhavn'", "name<='K\u00f8benhavn'", "boolean=true", 107}, {"start IS NULL", "pop_other IS NOT NULL", "pop_other IS NOT NULL", "pop_other>1038288", 124}, {"pop_other<1038288", "pop_other>1038288", "pop_other IS NULL", "start<TIMESTAMP('2022-04-16T10:13:19Z')", 121}, {"start=TIMESTAMP('2022-04-16T10:13:19Z')", "pop_other<1038288", "start=TIMESTAMP('2022-04-16T10:13:19Z')", "name<>'K\u00f8benhavn'", 2}, {"start<=TIMESTAMP('2022-04-16T10:13:19Z')", "name<>'K\u00f8benhavn'", "boolean=true", "name<'K\u00f8benhavn'", 2}, {"pop_other=1038288", "start IS NULL", "start<>TIMESTAMP('2022-04-16T10:13:19Z')", "boolean IS NOT NULL", 242}, {"start IS NULL", "pop_other>1038288", "start IS NOT NULL", "name>'K\u00f8benhavn'", 122}, {"pop_other<1038288", "name<>'K\u00f8benhavn'", "name='K\u00f8benhavn'", "start<TIMESTAMP('2022-04-16T10:13:19Z')", 2}, {"start>=TIMESTAMP('2022-04-16T10:13:19Z')", "name IS NOT NULL", "start IS NULL", "pop_other<1038288", 120}, {"name>='K\u00f8benhavn'", "start IS NOT NULL", "boolean=true", "start>=TIMESTAMP('2022-04-16T10:13:19Z')", 137}, {"start IS NOT NULL", "name>='K\u00f8benhavn'", "start IS NOT NULL", "name IS NOT NULL", 3}, {"name IS NULL", "name<'K\u00f8benhavn'", "pop_other IS NOT NULL", "boolean IS NOT NULL", 243}, {"start>=TIMESTAMP('2022-04-16T10:13:19Z')", "name>'K\u00f8benhavn'", "pop_other=1038288", "name<'K\u00f8benhavn'", 3}, {"start<TIMESTAMP('2022-04-16T10:13:19Z')", "name<='K\u00f8benhavn'", "boolean IS NULL", "name>'K\u00f8benhavn'", 138}, {"pop_other IS NOT NULL", "start IS NULL", "pop_other>=1038288", "name>'K\u00f8benhavn'", 62}, {"name='K\u00f8benhavn'", "start=TIMESTAMP('2022-04-16T10:13:19Z')", "boolean=true", "pop_other IS NULL", 243}, {"name>'K\u00f8benhavn'", "pop_other<1038288", "pop_other>1038288", "name<='K\u00f8benhavn'", 122}, {"pop_other<>1038288", "name='K\u00f8benhavn'", "name<='K\u00f8benhavn'", "start>TIMESTAMP('2022-04-16T10:13:19Z')", 243}, {"start<TIMESTAMP('2022-04-16T10:13:19Z')", "start>=TIMESTAMP('2022-04-16T10:13:19Z')", "pop_other=1038288", "start IS NULL", 3}, {"name<>'K\u00f8benhavn'", "boolean=true", "start=TIMESTAMP('2022-04-16T10:13:19Z')", "start IS NULL", 2}, {"name IS NULL", "start<>TIMESTAMP('2022-04-16T10:13:19Z')", "start<TIMESTAMP('2022-04-16T10:13:19Z')", "name IS NULL", 243}, {"start<>TIMESTAMP('2022-04-16T10:13:19Z')", "name>'K\u00f8benhavn'", "start<=TIMESTAMP('2022-04-16T10:13:19Z')", "name IS NOT NULL", 3}, {"name<>'K\u00f8benhavn'", "pop_other<>1038288", "pop_other<1038288", "start>=TIMESTAMP('2022-04-16T10:13:19Z')", 2}, {"boolean IS NULL", "pop_other>1038288", "boolean IS NOT NULL", "pop_other IS NULL", 122}, {"pop_other=1038288", "start IS NULL", "start>TIMESTAMP('2022-04-16T10:13:19Z')", "pop_other IS NOT NULL", 2}, {"pop_other<>1038288", "start IS NULL", "pop_other>1038288", "boolean=true", 2}, {"start>TIMESTAMP('2022-04-16T10:13:19Z')", "pop_other<1038288", "name<='K\u00f8benhavn'", "pop_other=1038288", 2}, {"start>=TIMESTAMP('2022-04-16T10:13:19Z')", "start<=TIMESTAMP('2022-04-16T10:13:19Z')", "name<='K\u00f8benhavn'", "name<>'K\u00f8benhavn'", 107}, {"boolean=true", "name IS NOT NULL", "boolean IS NULL", "pop_other=1038288", 1}, {"start=TIMESTAMP('2022-04-16T10:13:19Z')", "pop_other=1038288", "pop_other<1038288", "name<>'K\u00f8benhavn'", 122}, {"pop_other<>1038288", "start<=TIMESTAMP('2022-04-16T10:13:19Z')", "start IS NOT NULL", "start=TIMESTAMP('2022-04-16T10:13:19Z')", 3}, {"name<>'K\u00f8benhavn'", "pop_other<>1038288", "pop_other IS NOT NULL", "name IS NOT NULL", 243}, {"name='K\u00f8benhavn'", "pop_other<1038288", "start IS NOT NULL", "pop_other<>1038288", 3}, {"name<'K\u00f8benhavn'", "start<>TIMESTAMP('2022-04-16T10:13:19Z')", "start>TIMESTAMP('2022-04-16T10:13:19Z')", "start=TIMESTAMP('2022-04-16T10:13:19Z')", 2}, {"boolean=true", "pop_other<1038288", "name IS NOT NULL", "start<=TIMESTAMP('2022-04-16T10:13:19Z')", 3}, {"pop_other<=1038288", "name<'K\u00f8benhavn'", "pop_other<1038288", "pop_other<1038288", 243}, {"pop_other IS NULL", "name<='K\u00f8benhavn'", "name='K\u00f8benhavn'", "start>TIMESTAMP('2022-04-16T10:13:19Z')", 2}, {"pop_other<1038288", "name<>'K\u00f8benhavn'", "pop_other<>1038288", "name<>'K\u00f8benhavn'", 243}, {"start<=TIMESTAMP('2022-04-16T10:13:19Z')", "pop_other IS NULL", "start<TIMESTAMP('2022-04-16T10:13:19Z')", "name IS NOT NULL", 2}, {"start<>TIMESTAMP('2022-04-16T10:13:19Z')", "name='K\u00f8benhavn'", "boolean IS NULL", "pop_other<>1038288", 241}, {"boolean=true", "pop_other<=1038288", "name<>'K\u00f8benhavn'", "pop_other IS NULL", 2}, {"name IS NOT NULL", "pop_other<=1038288", "start IS NOT NULL", "boolean IS NOT NULL", 124}, {"pop_other<=1038288", "pop_other<1038288", "start>TIMESTAMP('2022-04-16T10:13:19Z')", "pop_other>1038288", 1}, {"start IS NOT NULL", "boolean IS NOT NULL", "name>='K\u00f8benhavn'", "pop_other IS NOT NULL", 137}, {"start<>TIMESTAMP('2022-04-16T10:13:19Z')", "start IS NOT NULL", "pop_other>1038288", "pop_other<1038288", 1}, {"pop_other<=1038288", "name<='K\u00f8benhavn'", "boolean IS NULL", "start IS NOT NULL", 198}, {"name>='K\u00f8benhavn'", "name>='K\u00f8benhavn'", "name<='K\u00f8benhavn'", "name>='K\u00f8benhavn'", 107}, {"boolean=true", "start<TIMESTAMP('2022-04-16T10:13:19Z')", "boolean IS NOT NULL", "name<'K\u00f8benhavn'", 2}, {"start>TIMESTAMP('2022-04-16T10:13:19Z')", "start>=TIMESTAMP('2022-04-16T10:13:19Z')", "pop_other IS NULL", "pop_other<=1038288", 1}, {"pop_other<1038288", "name='K\u00f8benhavn'", "start>=TIMESTAMP('2022-04-16T10:13:19Z')", "name<'K\u00f8benhavn'", 181}, {"pop_other<1038288", "pop_other<=1038288", "pop_other IS NULL", "start IS NOT NULL", 121}, {"name>='K\u00f8benhavn'", "pop_other>=1038288", "boolean=true", "name IS NOT NULL", 79}, {"boolean IS NULL", "name<>'K\u00f8benhavn'", "boolean IS NULL", "pop_other IS NOT NULL", 240}, {"pop_other<1038288", "start>=TIMESTAMP('2022-04-16T10:13:19Z')", "name>'K\u00f8benhavn'", "pop_other<=1038288", 199}, {"name<='K\u00f8benhavn'", "start>TIMESTAMP('2022-04-16T10:13:19Z')", "name<'K\u00f8benhavn'", "boolean IS NULL", 106}, {"pop_other IS NOT NULL", "name<>'K\u00f8benhavn'", "pop_other<1038288", "pop_other<=1038288", 121}, {"name>='K\u00f8benhavn'", "start IS NOT NULL", "name>='K\u00f8benhavn'", "name IS NOT NULL", 137}, {"pop_other<1038288", "start<TIMESTAMP('2022-04-16T10:13:19Z')", "name IS NULL", "pop_other>=1038288", 1}, {"pop_other>=1038288", "name>'K\u00f8benhavn'", "boolean IS NOT NULL", "start IS NOT NULL", 184}, {"start IS NOT NULL", "name<>'K\u00f8benhavn'", "name<='K\u00f8benhavn'", "name IS NULL", 241}, {"name>='K\u00f8benhavn'", "pop_other<>1038288", "start=TIMESTAMP('2022-04-16T10:13:19Z')", "name<>'K\u00f8benhavn'", 2}, {"boolean IS NOT NULL", "pop_other<=1038288", "pop_other=1038288", "start=TIMESTAMP('2022-04-16T10:13:19Z')", 1}, {"name IS NOT NULL", "start IS NOT NULL", "start IS NOT NULL", "name>='K\u00f8benhavn'", 241}, {"pop_other=1038288", "pop_other IS NOT NULL", "start IS NOT NULL", "name<>'K\u00f8benhavn'", 2}, {"start=TIMESTAMP('2022-04-16T10:13:19Z')", "start IS NULL", "pop_other>1038288", "pop_other<=1038288", 1}, {"name IS NULL", "start IS NOT NULL", "start=TIMESTAMP('2022-04-16T10:13:19Z')", "name IS NOT NULL", 1}, {"boolean IS NOT NULL", "name='K\u00f8benhavn'", "boolean IS NOT NULL", "name IS NOT NULL", 3}, {"pop_other<>1038288", "pop_other<>1038288", "pop_other=1038288", "pop_other<=1038288", 1}, {"pop_other IS NULL", "start<>TIMESTAMP('2022-04-16T10:13:19Z')", "start>TIMESTAMP('2022-04-16T10:13:19Z')", "boolean IS NOT NULL", 241}, {"start<TIMESTAMP('2022-04-16T10:13:19Z')", "boolean IS NULL", "start>TIMESTAMP('2022-04-16T10:13:19Z')", "name<'K\u00f8benhavn'", 2}, {"pop_other>1038288", "pop_other<>1038288", "start<>TIMESTAMP('2022-04-16T10:13:19Z')", "name<>'K\u00f8benhavn'", 2}, {"start>=TIMESTAMP('2022-04-16T10:13:19Z')", "start=TIMESTAMP('2022-04-16T10:13:19Z')", "pop_other=1038288", "name IS NOT NULL", 2}, {"pop_other<=1038288", "start IS NOT NULL", "start<=TIMESTAMP('2022-04-16T10:13:19Z')", "boolean IS NOT NULL", 242}, {"boolean=true", "start>TIMESTAMP('2022-04-16T10:13:19Z')", "pop_other<1038288", "pop_other<>1038288", 122}, {"pop_other>=1038288", "pop_other>1038288", "boolean IS NULL", "pop_other=1038288", 121}, {"name<'K\u00f8benhavn'", "pop_other>1038288", "start=TIMESTAMP('2022-04-16T10:13:19Z')", "boolean=true", 44});
    }
}

