/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.cql_2;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.geootols.filter.text.cql_2.CQL2;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.temporal.Before;
import org.geotools.filter.text.commons.Language;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.cql2.FilterCQLSample;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class CQL2TemporalPredicateTest {
    protected final Language language;

    public CQL2TemporalPredicateTest() {
        this(Language.CQL);
    }

    protected CQL2TemporalPredicateTest(Language language) {
        assert (language != null) : "language cannot be null value";
        this.language = language;
    }

    @Test
    public void before() throws Exception {
        Filter resultFilter = CQL2.toFilter((String)"T_BEFORE(ATTR1, TIMESTAMP('2006-11-30T01:30:00Z'))");
        Assert.assertNotNull((String)"not null expected", (Object)resultFilter);
        Filter expected = FilterCQLSample.getSample((String)"ATTR1 BEFORE 2006-11-30T01:30:00Z");
        Assert.assertEquals((Object)expected, (Object)resultFilter);
        resultFilter = CQL2.toFilter((String)"T_BEFORE(ATTR1, TIMESTAMP('2006-11-30T01:30:00.123Z'))");
        Assert.assertNotNull((String)"not null expected", (Object)resultFilter);
        expected = FilterCQLSample.getSample((String)"ATTR1 BEFORE 2006-11-30T01:30:00.123Z");
        Assert.assertEquals((Object)expected, (Object)resultFilter);
        resultFilter = CQL2.toFilter((String)"T_BEFORE(ATTR1, INTERVAL(TIMESTAMP('2006-11-30T01:30:00Z'), TIMESTAMP('2006-12-31T01:30:00Z')))");
        Assert.assertNotNull((String)"Filter expected", (Object)resultFilter);
        expected = FilterCQLSample.getSample((String)"ATTR1 BEFORE 2006-11-30T01:30:00Z/2006-12-31T01:30:00Z");
        Assert.assertEquals((String)"less than first date of period ", (Object)expected, (Object)resultFilter);
        resultFilter = CQL2.toFilter((String)"T_BEFORE(ATTR1, INTERVAL(TIMESTAMP('2006-11-30T01:30:00.123Z'), TIMESTAMP('2006-12-31T01:30:00.456Z')))");
        Assert.assertNotNull((String)"Filter expected", (Object)resultFilter);
        expected = FilterCQLSample.getSample((String)"ATTR1 BEFORE 2006-11-30T01:30:00.123Z/2006-12-31T01:30:00.456Z");
        Assert.assertEquals((String)"less than first date of period ", (Object)expected, (Object)resultFilter);
    }

    @Test
    public void beforeDate() throws CQLException, ParseException {
        Filter filter = CQL2.toFilter((String)"T_BEFORE(ZONE_VALID_FROM, DATE('2008-09-09'))");
        MatcherAssert.assertThat((Object)filter, (Matcher)CoreMatchers.instanceOf(Before.class));
        Before before = (Before)filter;
        Object ex2Value = before.getExpression2().evaluate(null);
        MatcherAssert.assertThat((Object)ex2Value, (Matcher)CoreMatchers.instanceOf(Date.class));
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
        Date dateTime = dateFormatter.parse("2008-09-09");
        Assert.assertEquals((Object)dateTime, (Object)ex2Value);
    }

    @Test(expected=CQLException.class)
    public void badTime() throws CQLException {
        CQL.toFilter((String)"T_BEFORE(ZONE_VALID_FROM, TIMESTAMP('2008-09-09 17:00:00'))");
    }

    @Test
    public void dateTime() throws Exception {
        String cqlDateTime = "2008-09-09T17:00:00Z";
        Filter resultFilter = CQL2.toFilter((String)"T_BEFORE(ZONE_VALID_FROM, TIMESTAMP('2008-09-09T17:00:00Z'))");
        Before before = (Before)resultFilter;
        Expression expr2 = before.getExpression2();
        Literal literalDate = (Literal)expr2;
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        dateFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date expectedDate = dateFormatter.parse("2008-09-09T17:00:00Z");
        Date actualDate = (Date)literalDate.getValue();
        Assert.assertEquals((Object)expectedDate, (Object)actualDate);
    }

    @Test(expected=CQLException.class)
    public void dateTimeWithLocalTime() throws Exception {
        CQL2.toFilter((String)"T_BEFORE(ZONE_VALID_FROM, TIMESTAMP('2008-09-09T17:00:00'))");
    }

    @Test
    public void dateTimeWithOffset() throws Exception {
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        String offset = "GMT+01:00";
        TimeZone tz = TimeZone.getTimeZone("GMT+01:00");
        dateFormatter.setTimeZone(tz);
        Filter resultFilter = CQL2.toFilter((String)"T_BEFORE(ZONE_VALID_FROM, TIMESTAMP('2008-09-09T17:00:00+01:00'))");
        Before before = (Before)resultFilter;
        Expression expr2 = before.getExpression2();
        Literal literalDate = (Literal)expr2;
        Date actualDate = (Date)literalDate.getValue();
        Date expectedDate = dateFormatter.parse("2008-09-09T17:00:00GMT+01:00");
        Assert.assertEquals((Object)expectedDate, (Object)actualDate);
    }

    @Test
    public void during() throws Exception {
        Filter resultFilter = CQL2.toFilter((String)"T_DURING(ATTR1, INTERVAL(TIMESTAMP('2006-11-30T01:30:00Z'), TIMESTAMP('2006-12-31T01:30:00Z')))");
        Assert.assertNotNull((String)"Filter expected", (Object)resultFilter);
        Filter expected = FilterCQLSample.getSample((String)"ATTR1 DURING 2006-11-30T01:30:00Z/2006-12-31T01:30:00Z");
        Assert.assertEquals((String)"greater filter ", (Object)expected, (Object)resultFilter);
    }

    @Test
    public void after() throws Exception {
        Filter resultFilter = CQL2.toFilter((String)"T_AFTER(ATTR1, TIMESTAMP('2006-12-31T01:30:00Z'))");
        Assert.assertNotNull((String)"Filter expected", (Object)resultFilter);
        Filter expected = FilterCQLSample.getSample((String)"ATTR1 AFTER 2006-12-31T01:30:00Z");
        Assert.assertEquals((String)"greater filter ", (Object)expected, (Object)resultFilter);
        resultFilter = CQL2.toFilter((String)"T_AFTER(ATTR1, INTERVAL(TIMESTAMP('2006-11-30T01:30:00Z'), TIMESTAMP('2006-12-31T01:30:00Z')))");
        Assert.assertNotNull((String)"Filter expected", (Object)resultFilter);
        expected = FilterCQLSample.getSample((String)"ATTR1 AFTER 2006-11-30T01:30:00Z/2006-12-31T01:30:00Z");
        Assert.assertEquals((String)"greater filter ", (Object)expected, (Object)resultFilter);
    }

    @Test
    public void equal() throws Exception {
        Filter resultFilter = CQL2.toFilter((String)"T_EQUALS(ATTR1,  TIMESTAMP('2006-11-30T01:30:00Z'))");
        Assert.assertNotNull((String)"not null expected", (Object)resultFilter);
        Filter expected = FilterCQLSample.getSample((String)"ATTR1 TEQUALS 2006-11-30T01:30:00Z");
        Assert.assertEquals((Object)expected, (Object)resultFilter);
    }
}

