/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.css;

import java.util.List;
import org.parboiled.errors.DefaultInvalidInputErrorFormatter;
import org.parboiled.errors.InvalidInputError;
import org.parboiled.errors.ParseError;
import org.parboiled.support.Position;

public class CSSParseException
extends IllegalArgumentException {
    private static final long serialVersionUID = -2624556764086947780L;
    private volatile List<ParseError> errors;

    public CSSParseException(List<ParseError> errors) {
        super(CSSParseException.buildMessage(errors));
        this.errors = errors;
    }

    private static String buildMessage(List<ParseError> errors) {
        if (errors == null || errors.isEmpty()) {
            throw new IllegalArgumentException("Cannot build a CSSParseException without a list of errors");
        }
        StringBuilder sb = new StringBuilder();
        for (ParseError pe : errors) {
            Position pos = pe.getInputBuffer().getPosition(pe.getStartIndex());
            String message = pe.getErrorMessage() != null ? pe.getErrorMessage() : (pe instanceof InvalidInputError ? new DefaultInvalidInputErrorFormatter().format((InvalidInputError)pe) : pe.getClass().getSimpleName());
            sb.append(message).append(" (line ").append(pos.line).append(", column ").append(pos.column).append(")");
            sb.append('\n');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public List<ParseError> getErrors() {
        return this.errors;
    }
}

