/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.css;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.FileUtils;
import org.geotools.brewer.styling.builder.ChannelSelectionBuilder;
import org.geotools.brewer.styling.builder.ColorMapBuilder;
import org.geotools.brewer.styling.builder.ColorMapEntryBuilder;
import org.geotools.brewer.styling.builder.ContrastEnhancementBuilder;
import org.geotools.brewer.styling.builder.FeatureTypeStyleBuilder;
import org.geotools.brewer.styling.builder.FillBuilder;
import org.geotools.brewer.styling.builder.FontBuilder;
import org.geotools.brewer.styling.builder.GraphicBuilder;
import org.geotools.brewer.styling.builder.HaloBuilder;
import org.geotools.brewer.styling.builder.LineSymbolizerBuilder;
import org.geotools.brewer.styling.builder.MarkBuilder;
import org.geotools.brewer.styling.builder.PointPlacementBuilder;
import org.geotools.brewer.styling.builder.PointSymbolizerBuilder;
import org.geotools.brewer.styling.builder.PolygonSymbolizerBuilder;
import org.geotools.brewer.styling.builder.RasterSymbolizerBuilder;
import org.geotools.brewer.styling.builder.RuleBuilder;
import org.geotools.brewer.styling.builder.StrokeBuilder;
import org.geotools.brewer.styling.builder.StyleBuilder;
import org.geotools.brewer.styling.builder.SymbolizerBuilder;
import org.geotools.brewer.styling.builder.TextSymbolizerBuilder;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.NameImpl;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.filter.visitor.SimplifyingFilterVisitor;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.css.CachedSimplifyingFilterVisitor;
import org.geotools.styling.css.CssParser;
import org.geotools.styling.css.CssRule;
import org.geotools.styling.css.CssRuleComparator;
import org.geotools.styling.css.DomainCoverage;
import org.geotools.styling.css.Property;
import org.geotools.styling.css.RulePowerSetBuilder;
import org.geotools.styling.css.RulesCombiner;
import org.geotools.styling.css.Stylesheet;
import org.geotools.styling.css.Value;
import org.geotools.styling.css.ZIndexComparator;
import org.geotools.styling.css.selector.AbstractSelectorVisitor;
import org.geotools.styling.css.selector.Data;
import org.geotools.styling.css.selector.Or;
import org.geotools.styling.css.selector.PseudoClass;
import org.geotools.styling.css.selector.Selector;
import org.geotools.styling.css.selector.TypeName;
import org.geotools.styling.css.util.FeatureTypeGuesser;
import org.geotools.styling.css.util.OgcFilterBuilder;
import org.geotools.styling.css.util.PseudoClassRemover;
import org.geotools.styling.css.util.ScaleRangeExtractor;
import org.geotools.styling.css.util.TypeNameExtractor;
import org.geotools.styling.css.util.TypeNameSimplifier;
import org.geotools.styling.css.util.UnboundSimplifyingFilterVisitor;
import org.geotools.util.Converters;
import org.geotools.util.Range;
import org.geotools.util.logging.Logging;
import org.geotools.xml.styling.SLDTransformer;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;

public class CssTranslator {
    static final Logger LOGGER = Logging.getLogger(CssTranslator.class);
    static final String DIRECTIVE_MAX_OUTPUT_RULES = "maxOutputRules";
    static final String DIRECTIVE_AUTO_THRESHOLD = "autoThreshold";
    static final String DIRECTIVE_TRANSLATION_MODE = "mode";
    static final String DIRECTIVE_STYLE_TITLE = "styleTitle";
    static final String DIRECTIVE_STYLE_ABSTRACT = "styleAbstract";
    static final int MAX_OUTPUT_RULES_DEFAULT = Integer.valueOf(System.getProperty("org.geotools.css.maxOutputRules", "10000"));
    static final int AUTO_THRESHOLD_DEFAULT = Integer.valueOf(System.getProperty("org.geotools.css.autoThreshold", "100"));
    static final FilterFactory2 FF = CommonFactoryFinder.getFilterFactory2();
    static final Pattern TITLE_PATTERN = Pattern.compile("^.*@title\\s*(?:\\:\\s*)?(.+)\\s*$");
    static final Pattern ABSTRACT_PATTERN = Pattern.compile("^.*@abstract\\s*(?:\\:\\s*)?(.+)\\s*$");
    static final String COMPOSITE = "composite";
    static final String COMPOSITE_BASE = "composite-base";
    static final String SORT_BY = "sort-by";
    static final String SORT_BY_GROUP = "sort-by-group";
    static final String TRANSFORM = "transform";
    static final String BACKGROUND = "background";
    static final Map<String, String> POLYGON_VENDOR_OPTIONS = new HashMap<String, String>(){
        {
            this.put("graphic-margin", "graphic-margin");
            this.put("fill-label-obstacle", "labelObstacle");
            this.put("fill-random", "random");
            this.put("fill-random-seed", "random-seed");
            this.put("fill-random-tile-size", "random-tile-size");
            this.put("fill-random-symbol-count", "random-symbol-count");
            this.put("fill-random-space-around", "random-space-around");
            this.put("fill-random-rotation", "random-rotation");
            this.put("fill-composite", CssTranslator.COMPOSITE);
        }
    };
    static final Map<String, String> TEXT_VENDOR_OPTIONS = new HashMap<String, String>(){
        {
            this.put("label-padding", "spaceAround");
            this.put("label-group", "group");
            this.put("label-max-displacement", "maxDisplacement");
            this.put("label-min-group-distance", "minGroupDistance");
            this.put("label-repeat", "repeat");
            this.put("label-all-group", "labelAllGroup");
            this.put("label-remove-overlaps", "removeOverlaps");
            this.put("label-allow-overruns", "allowOverruns");
            this.put("label-follow-line", "followLine");
            this.put("label-underline-text", "underlineText");
            this.put("label-strikethrough-text", "strikethroughText");
            this.put("label-char-spacing", "charSpacing");
            this.put("label-word-spacing", "wordSpacing");
            this.put("label-max-angle-delta", "maxAngleDelta");
            this.put("label-auto-wrap", "autoWrap");
            this.put("label-force-ltr", "forceLeftToRight");
            this.put("label-conflict-resolution", "conflictResolution");
            this.put("label-fit-goodness", "goodnessOfFit");
            this.put("label-kerning", "kerning");
            this.put("label-polygon-align", "polygonAlign");
            this.put("shield-resize", "graphic-resize");
            this.put("shield-margin", "graphic-margin");
            this.put("shield-placement", "graphicPlacement");
        }
    };
    static final Map<String, String> LINE_VENDOR_OPTIONS = new HashMap<String, String>(){
        {
            this.put("stroke-label-obstacle", "labelObstacle");
            this.put("stroke-composite", CssTranslator.COMPOSITE);
        }
    };
    static final Map<String, String> POINT_VENDOR_OPTIONS = new HashMap<String, String>(){
        {
            this.put("mark-label-obstacle", "labelObstacle");
            this.put("mark-composite", CssTranslator.COMPOSITE);
        }
    };
    static final Map<String, String> RASTER_VENDOR_OPTIONS = new HashMap<String, String>(){
        {
            this.put("raster-composite", CssTranslator.COMPOSITE);
        }
    };
    static final Map<String, String> CONTRASTENHANCMENT_VENDOR_OPTIONS = new HashMap<String, String>(){
        {
            this.put("raster-contrast-enhancement-algorithm", "algorithm");
            this.put("raster-contrast-enhancement-min", "minValue");
            this.put("raster-contrast-enhancement-max", "maxValue");
            this.put("raster-contrast-enhancement-normalizationfactor", "normalizationFactor");
            this.put("raster-contrast-enhancement-correctionfactor", "correctionFactor");
            this.put("rce-algorithm", "algorithm");
            this.put("rce-min", "minValue");
            this.put("rce-max", "maxValue");
            this.put("rce-normalizationfactor", "normalizationFactor");
            this.put("rce-correctionfactor", "correctionFactor");
        }
    };
    int maxCombinations = MAX_OUTPUT_RULES_DEFAULT;

    public int getMaxCombinations() {
        return this.maxCombinations;
    }

    public void setMaxCombinations(int maxCombinations) {
        this.maxCombinations = maxCombinations;
    }

    public org.opengis.style.Style translate(Stylesheet stylesheet) {
        int maxCombinations = this.getMaxCombinations(stylesheet);
        TranslationMode mode = this.getTranslationMode(stylesheet);
        int autoThreshold = this.getAutoThreshold(stylesheet);
        List<CssRule> topRules = stylesheet.getRules();
        StyleBuilder styleBuilder = new StyleBuilder();
        styleBuilder.name("Default Styler");
        styleBuilder.title(stylesheet.getDirectiveValue(DIRECTIVE_STYLE_TITLE));
        styleBuilder.styleAbstract(stylesheet.getDirectiveValue(DIRECTIVE_STYLE_ABSTRACT));
        int translatedRuleCount = 0;
        if (mode == TranslationMode.Flat) {
            List<CssRule> flattened = topRules.stream().map(CssRule::flattenPseudoSelectors).collect(Collectors.toList());
            List<CssRule> allRules = this.expandNested(flattened);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Starting cascaded translation with " + allRules.size() + "  rules in the stylesheet");
            }
            translatedRuleCount = this.translateFlat(allRules, styleBuilder);
        } else {
            List<CssRule> allRules = this.expandNested(topRules);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Starting cascaded translation with " + allRules.size() + "  rules in the stylesheet");
            }
            translatedRuleCount = this.translateCss(mode, allRules, styleBuilder, maxCombinations, autoThreshold);
        }
        if (translatedRuleCount == 0) {
            throw new IllegalArgumentException("Invalid CSS style, no rule seems to activate any symbolization. The properties activating the symbolizers are fill, stroke, mark, label, raster-channels, have any been used in a rule matching any feature?");
        }
        return styleBuilder.build();
    }

    private List<CssRule> expandNested(List<CssRule> topRules) {
        RulesCombiner combiner = new RulesCombiner(new UnboundSimplifyingFilterVisitor());
        List<CssRule> expanded = topRules.stream().flatMap(r -> r.expandNested(combiner).stream()).collect(Collectors.toList());
        return expanded;
    }

    private int translateCss(TranslationMode mode, List<CssRule> allRules, StyleBuilder styleBuilder, int maxCombinations, int autoThreshold) {
        Map<Integer, List<CssRule>> zIndexRules = this.organizeByZIndex(allRules, CssRule.ZIndexMode.NoZIndexAll);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Split the rules into " + zIndexRules + "  sets after z-index separation");
        }
        int translatedRuleCount = 0;
        boolean backgroundFound = false;
        for (Map.Entry<Integer, List<CssRule>> zEntry : zIndexRules.entrySet()) {
            final Integer zIndex = zEntry.getKey();
            List<CssRule> rules = zEntry.getValue();
            Collections.sort(rules, CssRuleComparator.DESCENDING);
            Map<String, List<CssRule>> typenameRules = this.organizeByTypeName(rules);
            for (Map.Entry<String, List<CssRule>> entry : typenameRules.entrySet()) {
                CachedSimplifyingFilterVisitor cachedSimplifier;
                RulePowerSetBuilder builder;
                List combinedRules;
                List<CssRule> localRules;
                String featureTypeName = entry.getKey();
                final FeatureType targetFeatureType = this.getTargetFeatureType(featureTypeName, localRules = entry.getValue());
                if (targetFeatureType != null) {
                    for (CssRule rule : localRules) {
                        rule.getSelector().accept(new AbstractSelectorVisitor(){

                            @Override
                            public Object visit(Data data) {
                                data.featureType = targetFeatureType;
                                return super.visit(data);
                            }
                        });
                    }
                }
                List<CssRule> flattenedRules = this.flattenScaleRanges(localRules);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Preparing power set expansion with " + flattenedRules.size() + "  rules for feature type: " + featureTypeName);
                }
                if ((combinedRules = (builder = new RulePowerSetBuilder(flattenedRules, cachedSimplifier = new CachedSimplifyingFilterVisitor(targetFeatureType), maxCombinations){

                    @Override
                    protected List<CssRule> buildResult(List<CssRule> rules) {
                        TreeSet zIndexes;
                        if (zIndex != null && zIndex > 0 && !(zIndexes = CssTranslator.this.getZIndexesForRules(rules)).contains(zIndex)) {
                            return null;
                        }
                        return super.buildResult(rules);
                    }
                }).buildPowerSet()).isEmpty()) continue;
                FeatureTypeStyleBuilder ftsBuilder = styleBuilder.featureTypeStyle();
                ftsBuilder.option("ruleEvaluation", "first");
                if (featureTypeName != null) {
                    ftsBuilder.setFeatureTypeNames(Arrays.asList(new NameImpl(featureTypeName)));
                }
                Collections.sort(combinedRules, CssRuleComparator.DESCENDING);
                int rulesCount = combinedRules.size();
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Generated " + rulesCount + " combined rules after filtered power set expansion");
                }
                String composite = null;
                Boolean compositeBase = null;
                String sortBy = null;
                String sortByGroup = null;
                Expression transform = null;
                DomainCoverage coverage = new DomainCoverage(targetFeatureType, cachedSimplifier);
                if (mode == TranslationMode.Exclusive) {
                    coverage.exclusiveRulesEnabled = true;
                } else if (mode == TranslationMode.Auto) {
                    if (rulesCount < autoThreshold) {
                        LOGGER.fine("Sticking to Exclusive translation mode, rules number is " + rulesCount + " with a threshold of " + autoThreshold);
                        coverage.exclusiveRulesEnabled = true;
                        coverage.complexityThreshold = autoThreshold;
                    } else {
                        LOGGER.info("Switching to Simple translation mode, rules number is " + rulesCount + " with a threshold of " + autoThreshold);
                        coverage.exclusiveRulesEnabled = false;
                        mode = TranslationMode.Simple;
                    }
                } else {
                    coverage.exclusiveRulesEnabled = false;
                }
                for (int i = 0; i < rulesCount; ++i) {
                    CssRule cssRule = (CssRule)combinedRules.get(i);
                    if (!cssRule.hasSymbolizerProperty()) continue;
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Current domain coverage: " + coverage);
                        LOGGER.fine("Adding rule to domain coverage: " + cssRule);
                        LOGGER.fine("Rules left to process: " + (rulesCount - i));
                    }
                    List<CssRule> derivedRules = coverage.addRule(cssRule);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Derived rules not yet covered in domain coverage: " + derivedRules.size() + "\n" + derivedRules);
                    }
                    for (CssRule derived : derivedRules) {
                        List<Value> values;
                        if (!derived.hasNonNullSymbolizerProperty()) continue;
                        this.buildSldRule(derived, ftsBuilder, targetFeatureType, null);
                        ++translatedRuleCount;
                        if (composite == null && (values = derived.getPropertyValues(PseudoClass.ROOT, COMPOSITE).get(COMPOSITE)) != null && !values.isEmpty()) {
                            composite = values.get(0).toLiteral();
                        }
                        if (compositeBase == null && (values = derived.getPropertyValues(PseudoClass.ROOT, COMPOSITE_BASE).get(COMPOSITE_BASE)) != null && !values.isEmpty()) {
                            compositeBase = Boolean.valueOf(values.get(0).toLiteral());
                        }
                        if (sortBy == null && (values = derived.getPropertyValues(PseudoClass.ROOT, SORT_BY).get(SORT_BY)) != null && !values.isEmpty()) {
                            sortBy = values.get(0).toLiteral();
                        }
                        if (sortByGroup == null && (values = derived.getPropertyValues(PseudoClass.ROOT, SORT_BY_GROUP).get(SORT_BY_GROUP)) != null && !values.isEmpty()) {
                            sortByGroup = values.get(0).toLiteral();
                        }
                        if (transform == null && (values = derived.getPropertyValues(PseudoClass.ROOT, TRANSFORM).get(TRANSFORM)) != null && !values.isEmpty()) {
                            transform = values.get(0).toExpression();
                        }
                        if (backgroundFound) continue;
                        backgroundFound = this.buildBackground(styleBuilder, derived);
                    }
                    if (composite != null) {
                        ftsBuilder.option(COMPOSITE, composite);
                    }
                    if (Boolean.TRUE.equals(compositeBase)) {
                        ftsBuilder.option(COMPOSITE_BASE, "true");
                    }
                    if (sortBy != null) {
                        ftsBuilder.option("sortBy", sortBy);
                    }
                    if (sortByGroup != null) {
                        ftsBuilder.option("sortByGroup", sortByGroup);
                    }
                    if (transform == null) continue;
                    ftsBuilder.transformation(transform);
                }
            }
        }
        return translatedRuleCount;
    }

    private int translateFlat(List<CssRule> allRules, StyleBuilder styleBuilder) {
        ArrayList<CssRule> finalRules = new ArrayList<CssRule>();
        CssRule actualRule = null;
        LinkedHashMap<PseudoClass, List<Property>> properties = null;
        Set<PseudoClass> mixablePseudoClasses = null;
        int translatedRuleCount = 0;
        for (CssRule rule : allRules) {
            if (rule.getProperties().get(PseudoClass.ROOT) == null) {
                Selector simplified = (Selector)rule.selector.accept(new PseudoClassRemover());
                if (actualRule == null || !actualRule.getSelector().equals(simplified)) continue;
                boolean changed = false;
                for (Map.Entry<PseudoClass, List<Property>> item : rule.properties.entrySet()) {
                    if (!mixablePseudoClasses.contains(item.getKey())) continue;
                    properties.put(item.getKey(), item.getValue());
                    changed = true;
                }
                if (!changed) continue;
                actualRule = new CssRule(actualRule.selector, properties, actualRule.comment);
                continue;
            }
            if (actualRule != null) {
                finalRules.add(actualRule);
            }
            actualRule = rule;
            mixablePseudoClasses = actualRule.getMixablePseudoClasses();
            properties = new LinkedHashMap<PseudoClass, List<Property>>(actualRule.properties);
        }
        if (actualRule != null) {
            finalRules.add(actualRule);
        }
        if (finalRules.isEmpty()) {
            return 0;
        }
        Map<Integer, List<CssRule>> zIndexRules = this.organizeByZIndex(finalRules, CssRule.ZIndexMode.NoZIndexZero);
        for (Map.Entry<Integer, List<CssRule>> zEntry : zIndexRules.entrySet()) {
            List<CssRule> rules = zEntry.getValue();
            Map<String, List<CssRule>> typenameRules = this.organizeByTypeName(rules);
            boolean backgroundFound = false;
            for (Map.Entry<String, List<CssRule>> entry : typenameRules.entrySet()) {
                String featureTypeName = entry.getKey();
                List<CssRule> localRules = entry.getValue();
                FeatureType targetFeatureType = this.getTargetFeatureType(featureTypeName, localRules);
                List<CssRule> flattenedRules = this.flattenScaleRanges(localRules);
                FeatureTypeStyleBuilder ftsBuilder = styleBuilder.featureTypeStyle();
                if (featureTypeName != null) {
                    ftsBuilder.setFeatureTypeNames(Arrays.asList(new NameImpl(featureTypeName)));
                }
                String composite = null;
                Boolean compositeBase = null;
                String sortBy = null;
                String sortByGroup = null;
                CachedSimplifyingFilterVisitor cachedSimplifier = new CachedSimplifyingFilterVisitor(targetFeatureType);
                for (CssRule cssRule : flattenedRules) {
                    if (!cssRule.hasNonNullSymbolizerProperty()) continue;
                    List<CssRule> derivedRules = this.removeNested(cssRule, targetFeatureType, cachedSimplifier);
                    for (CssRule derived : derivedRules) {
                        List<Value> values;
                        this.buildSldRule(derived, ftsBuilder, targetFeatureType, cachedSimplifier);
                        ++translatedRuleCount;
                        if (composite == null && (values = derived.getPropertyValues(PseudoClass.ROOT, COMPOSITE).get(COMPOSITE)) != null && !values.isEmpty()) {
                            composite = values.get(0).toLiteral();
                        }
                        if (compositeBase == null && (values = derived.getPropertyValues(PseudoClass.ROOT, COMPOSITE_BASE).get(COMPOSITE_BASE)) != null && !values.isEmpty()) {
                            compositeBase = Boolean.valueOf(values.get(0).toLiteral());
                        }
                        if (sortBy == null && (values = derived.getPropertyValues(PseudoClass.ROOT, SORT_BY).get(SORT_BY)) != null && !values.isEmpty()) {
                            sortBy = values.get(0).toLiteral();
                        }
                        if (sortByGroup == null && (values = derived.getPropertyValues(PseudoClass.ROOT, SORT_BY_GROUP).get(SORT_BY_GROUP)) != null && !values.isEmpty()) {
                            sortByGroup = values.get(0).toLiteral();
                        }
                        if (backgroundFound) continue;
                        backgroundFound = this.buildBackground(styleBuilder, derived);
                    }
                }
                if (composite != null) {
                    ftsBuilder.option(COMPOSITE, composite);
                }
                if (Boolean.TRUE.equals(compositeBase)) {
                    ftsBuilder.option(COMPOSITE_BASE, "true");
                }
                if (sortBy != null) {
                    ftsBuilder.option("sortBy", sortBy);
                }
                if (sortByGroup == null) continue;
                ftsBuilder.option("sortByGroup", sortByGroup);
            }
        }
        return translatedRuleCount;
    }

    private boolean buildBackground(StyleBuilder styleBuilder, CssRule rule) {
        List<Value> values = rule.getPropertyValues(PseudoClass.ROOT, BACKGROUND).get(BACKGROUND);
        if (values != null && !values.isEmpty()) {
            FillBuilder fb = styleBuilder.background();
            this.buildFill(rule, fb, rule.getPropertyValues(PseudoClass.ROOT, new String[0]), 0, BACKGROUND);
            return true;
        }
        return false;
    }

    private List<CssRule> removeNested(CssRule cssRule, FeatureType featureType, UnboundSimplifyingFilterVisitor simplifier) {
        List<CssRule> nested = cssRule.getNestedRules();
        if (nested == null || nested.isEmpty()) {
            return Collections.singletonList(cssRule);
        }
        DomainCoverage coverage = new DomainCoverage(featureType, simplifier);
        coverage.setExclusiveRulesEnabled(true);
        for (CssRule r : cssRule.getNestedRules()) {
            coverage.addRule(r);
        }
        return coverage.addRule(cssRule);
    }

    private TranslationMode getTranslationMode(Stylesheet stylesheet) {
        String value = stylesheet.getDirectiveValue(DIRECTIVE_TRANSLATION_MODE);
        if (value != null) {
            try {
                return TranslationMode.valueOf(value);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid translation mode '" + value + "', supported values are: " + Arrays.toString((Object[])TranslationMode.values()));
            }
        }
        return TranslationMode.Auto;
    }

    private int getMaxCombinations(Stylesheet stylesheet) {
        int maxCombinations = this.maxCombinations;
        String maxOutputRulesDirective = stylesheet.getDirectiveValue(DIRECTIVE_MAX_OUTPUT_RULES);
        if (maxOutputRulesDirective != null) {
            Integer converted = (Integer)Converters.convert((Object)maxOutputRulesDirective, Integer.class);
            if (converted == null) {
                throw new IllegalArgumentException("Invalid value for maxOutputRules, it should be a positive integer value, it was " + maxOutputRulesDirective);
            }
            maxCombinations = converted;
        }
        return maxCombinations;
    }

    private int getAutoThreshold(Stylesheet stylesheet) {
        int result = AUTO_THRESHOLD_DEFAULT;
        String autoThreshold = stylesheet.getDirectiveValue(DIRECTIVE_AUTO_THRESHOLD);
        if (autoThreshold != null) {
            Integer converted = (Integer)Converters.convert((Object)autoThreshold, Integer.class);
            if (converted == null) {
                throw new IllegalArgumentException("Invalid value for autoThreshold, it should be a positive integer value, it was " + autoThreshold);
            }
            result = converted;
        }
        return result;
    }

    private List<CssRule> flattenScaleRanges(List<CssRule> rules) {
        ArrayList<CssRule> result = new ArrayList<CssRule>();
        for (CssRule rule : rules) {
            if (rule.getSelector() instanceof Or) {
                CssRule r;
                Or or = (Or)rule.getSelector();
                ArrayList<Selector> others = new ArrayList<Selector>();
                for (Selector child : or.getChildren()) {
                    ScaleRangeExtractor extractor = new ScaleRangeExtractor();
                    Range<Double> range = ScaleRangeExtractor.getScaleRange(child);
                    if (range == null) {
                        others.add(child);
                        continue;
                    }
                    CssRule r2 = this.deriveWithSelector(rule, child);
                    result.add(r2);
                }
                if (others.size() == 1) {
                    r = this.deriveWithSelector(rule, (Selector)others.get(0));
                    result.add(r);
                    continue;
                }
                if (others.size() <= 0) continue;
                r = this.deriveWithSelector(rule, new Or(others));
                result.add(r);
                continue;
            }
            result.add(rule);
        }
        return result;
    }

    private CssRule deriveWithSelector(CssRule rule, Selector child) {
        CssRule r = new CssRule(child, rule.getProperties(), rule.getComment());
        r.nestedRules = rule.nestedRules;
        return r;
    }

    protected FeatureType getTargetFeatureType(String featureTypeName, List<CssRule> rules) {
        FeatureTypeGuesser guesser = new FeatureTypeGuesser();
        for (CssRule rule : rules) {
            guesser.addRule(rule);
        }
        return guesser.getFeatureType();
    }

    private Map<String, List<CssRule>> organizeByTypeName(List<CssRule> rules) {
        TypeNameExtractor extractor = new TypeNameExtractor();
        for (CssRule rule : rules) {
            rule.getSelector().accept(extractor);
        }
        LinkedHashMap<String, List<CssRule>> result = new LinkedHashMap<String, List<CssRule>>();
        Set<TypeName> typeNames = extractor.getTypeNames();
        if (typeNames.size() == 1 && typeNames.contains(TypeName.DEFAULT)) {
            result.put(TypeName.DEFAULT.name, rules);
        }
        for (TypeName tn : typeNames) {
            ArrayList typeNameRules = new ArrayList();
            for (CssRule rule : rules) {
                TypeNameSimplifier simplifier = new TypeNameSimplifier(tn);
                Selector simplified = (Selector)rule.getSelector().accept(simplifier);
                if (simplified != Selector.REJECT && !simplified.equals(rule.getSelector()) && rule.getSelector() instanceof Or) {
                    Or or = (Or)rule.getSelector();
                    ArrayList<CssRule> reduced = new ArrayList<CssRule>();
                    for (Selector child : or.getChildren()) {
                        Selector cs = (Selector)child.accept(simplifier);
                        if (cs == Selector.REJECT) continue;
                        CssRule r = this.deriveWithSelector(rule, cs);
                        reduced.add(r);
                    }
                    if (reduced.size() > or.getChildren().size()) {
                        typeNameRules.addAll(reduced);
                        continue;
                    }
                    CssRule r = this.deriveWithSelector(rule, simplified);
                    typeNameRules.add(r);
                    continue;
                }
                if (simplified == Selector.REJECT) continue;
                CssRule r = this.deriveWithSelector(rule, simplified);
                typeNameRules.add(r);
            }
            result.put(tn.name, typeNameRules);
        }
        return result;
    }

    private Map<Integer, List<CssRule>> organizeByZIndex(List<CssRule> rules, CssRule.ZIndexMode zIndexMode) {
        TreeSet<Integer> indexes = this.getZIndexesForRules(rules);
        TreeMap<Integer, List<CssRule>> result = new TreeMap<Integer, List<CssRule>>();
        if (indexes.size() == 1) {
            result.put(indexes.first(), rules);
        } else {
            int symbolizerPropertyCount = 0;
            for (Integer index : indexes) {
                ArrayList<CssRule> rulesByIndex = new ArrayList<CssRule>();
                for (CssRule rule : rules) {
                    CssRule subRule = rule.getSubRuleByZIndex(index, zIndexMode);
                    if (subRule == null) continue;
                    if (subRule.hasSymbolizerProperty()) {
                        ++symbolizerPropertyCount;
                    }
                    rulesByIndex.add(subRule);
                }
                if (symbolizerPropertyCount <= 0) continue;
                result.put(index, rulesByIndex);
            }
        }
        return result;
    }

    private TreeSet<Integer> getZIndexesForRules(List<CssRule> rules) {
        TreeSet<Integer> indexes = new TreeSet<Integer>(new ZIndexComparator());
        for (CssRule rule : rules) {
            Set<Integer> ruleIndexes = rule.getZIndexes();
            if (ruleIndexes.contains(null)) {
                ruleIndexes.remove(null);
                ruleIndexes.add(0);
            }
            indexes.addAll(ruleIndexes);
        }
        return indexes;
    }

    void buildSldRule(CssRule cssRule, FeatureTypeStyleBuilder fts, FeatureType targetFeatureType, SimplifyingFilterVisitor visitor) {
        String ruleAbstract;
        Range<Double> scaleRange = ScaleRangeExtractor.getScaleRange(cssRule);
        if (scaleRange != null && scaleRange.isEmpty()) {
            return;
        }
        Filter filter = OgcFilterBuilder.buildFilter(cssRule.getSelector(), targetFeatureType);
        if (visitor != null) {
            filter = (Filter)filter.accept((FilterVisitor)visitor, null);
        }
        if (filter == Filter.EXCLUDE) {
            return;
        }
        RuleBuilder ruleBuilder = fts.rule();
        ruleBuilder.filter(filter);
        String title = this.getCombinedTag(cssRule.getComment(), TITLE_PATTERN, ", ");
        if (title != null) {
            ruleBuilder.title(title);
        }
        if ((ruleAbstract = this.getCombinedTag(cssRule.getComment(), ABSTRACT_PATTERN, "\n")) != null) {
            ruleBuilder.ruleAbstract(ruleAbstract);
        }
        if (scaleRange != null) {
            Double maxValue;
            Double minValue = (Double)scaleRange.getMinValue();
            if (minValue != null && minValue > 0.0) {
                ruleBuilder.min(minValue.doubleValue());
            }
            if ((maxValue = (Double)scaleRange.getMaxValue()) != null && maxValue < Double.POSITIVE_INFINITY) {
                ruleBuilder.max(maxValue.doubleValue());
            }
        }
        boolean generateStroke = cssRule.hasProperty(PseudoClass.ROOT, "stroke");
        boolean lineSymbolizerSpecificProperties = cssRule.hasAnyVendorProperty(PseudoClass.ROOT, LINE_VENDOR_OPTIONS.keySet()) || !this.sameGeometry(cssRule, "stroke-geometry", "fill-geometry");
        boolean includeStrokeInPolygonSymbolizer = generateStroke && !lineSymbolizerSpecificProperties;
        boolean generatePolygonSymbolizer = cssRule.hasProperty(PseudoClass.ROOT, "fill");
        if (generatePolygonSymbolizer) {
            this.addPolygonSymbolizer(cssRule, ruleBuilder, includeStrokeInPolygonSymbolizer);
        }
        if (!(!generateStroke || generatePolygonSymbolizer && includeStrokeInPolygonSymbolizer)) {
            this.addLineSymbolizer(cssRule, ruleBuilder);
        }
        if (cssRule.hasProperty(PseudoClass.ROOT, "mark")) {
            this.addPointSymbolizer(cssRule, ruleBuilder);
        }
        if (cssRule.hasProperty(PseudoClass.ROOT, "label")) {
            this.addTextSymbolizer(cssRule, ruleBuilder);
        }
        if (cssRule.hasProperty(PseudoClass.ROOT, "raster-channels")) {
            this.addRasterSymbolizer(cssRule, ruleBuilder);
        }
    }

    private boolean sameGeometry(CssRule cssRule, String geomProperty1, String geomProperty2) {
        Property p1 = cssRule.getProperty(PseudoClass.ROOT, geomProperty1);
        Property p2 = cssRule.getProperty(PseudoClass.ROOT, geomProperty2);
        return Objects.equals(p1, p2);
    }

    private String getCombinedTag(String comment, Pattern p, String separator) {
        if (comment == null || comment.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String line : comment.split("\n")) {
            String text;
            Matcher matcher = p.matcher(line);
            if (!matcher.matches() || (text = matcher.group(1).trim()).isEmpty()) continue;
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(text);
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    private void addPolygonSymbolizer(CssRule cssRule, RuleBuilder ruleBuilder, boolean includeStrokeInPolygonSymbolizer) {
        Map<String, List<Value>> values = includeStrokeInPolygonSymbolizer ? cssRule.getPropertyValues(PseudoClass.ROOT, "fill", "graphic-margin", "-gt-graphic-margin", "stroke") : cssRule.getPropertyValues(PseudoClass.ROOT, "fill", "graphic-margin", "-gt-graphic-margin");
        if (values == null || values.isEmpty()) {
            return;
        }
        int repeatCount = this.getMaxRepeatCount(values);
        for (int i = 0; i < repeatCount; ++i) {
            Value fill = this.getValue(values, "fill", i);
            if (fill == null) continue;
            PolygonSymbolizerBuilder pb = ruleBuilder.polygon();
            Expression fillGeometry = this.getExpression(values, "fill-geometry", i);
            if (fillGeometry != null) {
                pb.geometry(fillGeometry);
            }
            FillBuilder fb = pb.fill();
            this.buildFill(cssRule, fb, values, i, "fill");
            if (includeStrokeInPolygonSymbolizer) {
                StrokeBuilder sb = pb.stroke();
                this.buildStroke(cssRule, sb, values, i);
            }
            this.addVendorOptions((SymbolizerBuilder<?>)pb, POLYGON_VENDOR_OPTIONS, values, i);
        }
    }

    private void addPointSymbolizer(CssRule cssRule, RuleBuilder ruleBuilder) {
        Map<String, List<Value>> values = cssRule.getPropertyValues(PseudoClass.ROOT, "mark");
        if (values == null || values.isEmpty()) {
            return;
        }
        int repeatCount = this.getMaxRepeatCount(values);
        for (int i = 0; i < repeatCount; ++i) {
            final PointSymbolizerBuilder pb = ruleBuilder.point();
            Expression markGeometry = this.getExpression(values, "mark-geometry", i);
            if (markGeometry != null) {
                pb.geometry(markGeometry);
            }
            for (Value markValue : this.getMultiValue(values, "mark", i)) {
                new SubgraphicBuilder("mark", markValue, values, cssRule, i){

                    @Override
                    protected GraphicBuilder getGraphicBuilder() {
                        return pb.graphic();
                    }
                };
            }
            this.addVendorOptions((SymbolizerBuilder<?>)pb, POINT_VENDOR_OPTIONS, values, i);
        }
    }

    private void addTextSymbolizer(CssRule cssRule, RuleBuilder ruleBuilder) {
        Map<String, List<Value>> values = cssRule.getPropertyValues(PseudoClass.ROOT, "label", "font", "shield", "halo");
        if (values == null || values.isEmpty()) {
            return;
        }
        int repeatCount = this.getMaxRepeatCount(values);
        for (int i = 0; i < repeatCount; ++i) {
            Expression priority;
            Map<String, List<Value>> fontLikeProperties;
            Expression opacity;
            Expression labelExpression;
            Value labelValue;
            final TextSymbolizerBuilder tb = ruleBuilder.text();
            Expression labelGeometry = this.getExpression(values, "label-geometry", i);
            if (labelGeometry != null) {
                tb.geometry(labelGeometry);
            }
            if ((labelValue = this.getValue(values, "label", i)) instanceof Value.MultiValue) {
                Value.MultiValue m = (Value.MultiValue)labelValue;
                ArrayList<Expression> parts = new ArrayList<Expression>();
                for (Value value : m.values) {
                    parts.add(value.toExpression());
                }
                labelExpression = FF.function("Concatenate", parts.toArray(new Expression[parts.size()]));
            } else {
                labelExpression = labelValue.toExpression();
            }
            tb.label(labelExpression);
            Expression[] anchor = this.getExpressionArray(values, "label-anchor", i);
            Expression[] offsets = this.getExpressionArray(values, "label-offset", i);
            if (offsets != null && offsets.length == 1) {
                tb.linePlacement().offset(offsets[0]);
            } else if (offsets != null || anchor != null) {
                PointPlacementBuilder ppb = tb.pointPlacement();
                if (anchor != null) {
                    if (anchor.length == 2) {
                        ppb.anchor().x(anchor[0]);
                        ppb.anchor().y(anchor[1]);
                    } else if (anchor.length == 1) {
                        ppb.anchor().x(anchor[0]);
                        ppb.anchor().y(anchor[0]);
                    } else {
                        throw new IllegalArgumentException("Invalid anchor specification, should be two floats between 0 and 1 with a space in between, instead it is " + this.getValue(values, "label-anchor", i));
                    }
                }
                if (offsets != null) {
                    if (offsets.length == 2) {
                        ppb.displacement().x(offsets[0]);
                        ppb.displacement().y(offsets[1]);
                    } else if (offsets.length == 1) {
                        ppb.displacement().x(offsets[0]);
                        ppb.displacement().y(offsets[0]);
                    } else {
                        throw new IllegalArgumentException("Invalid anchor specification, should be two floats (or 1 for line placement with a certain offset) instead it is " + this.getValue(values, "label-anchor", i));
                    }
                }
            }
            Expression rotation = this.getMeasureExpression(values, "label-rotation", i, "deg");
            if (rotation != null) {
                tb.pointPlacement().rotation(rotation);
            }
            for (Value shieldValue : this.getMultiValue(values, "shield", i)) {
                new SubgraphicBuilder("shield", shieldValue, values, cssRule, i){

                    @Override
                    protected GraphicBuilder getGraphicBuilder() {
                        return tb.shield();
                    }
                };
            }
            Expression expression = this.getExpression(values, "font-fill", i);
            if (expression != null) {
                tb.fill().color(expression);
            }
            if ((opacity = this.getExpression(values, "font-opacity", i)) != null) {
                tb.fill().opacity(opacity);
            }
            if (!((fontLikeProperties = cssRule.getPropertyValues(PseudoClass.ROOT, "font")).isEmpty() || fontLikeProperties.size() <= 1 && fontLikeProperties.get("font-fill") != null)) {
                int maxSize = this.getMaxMultiValueSize(values, i, "font-family", "font-style", "font-weight", "font-family");
                for (int j = 0; j < maxSize; ++j) {
                    Expression fontSize;
                    Expression fontWeight;
                    Expression fontStyle;
                    FontBuilder fb = tb.newFont();
                    Expression fontFamily = this.getExpression(this.getValueInMulti(values, "font-family", i, j));
                    if (fontFamily != null) {
                        fb.family(fontFamily);
                    }
                    if ((fontStyle = this.getExpression(this.getValueInMulti(values, "font-style", i, j))) != null) {
                        fb.style(fontStyle);
                    }
                    if ((fontWeight = this.getExpression(this.getValueInMulti(values, "font-weight", i, j))) != null) {
                        fb.weight(fontWeight);
                    }
                    if ((fontSize = this.getMeasureExpression(this.getValueInMulti(values, "font-size", i, j), "px")) == null) continue;
                    fb.size(fontSize);
                }
            }
            if (!cssRule.getPropertyValues(PseudoClass.ROOT, "halo").isEmpty()) {
                Expression haloOpacity;
                Expression haloColor;
                HaloBuilder hb = tb.halo();
                Expression haloRadius = this.getMeasureExpression(values, "halo-radius", i, "px");
                if (haloRadius != null) {
                    hb.radius(haloRadius);
                }
                if ((haloColor = this.getExpression(values, "halo-color", i)) != null) {
                    hb.fill().color(haloColor);
                }
                if ((haloOpacity = this.getExpression(values, "halo-opacity", i)) != null) {
                    hb.fill().opacity(haloOpacity);
                }
            }
            if ((priority = this.getExpression(values, "label-priority", i)) == null) {
                priority = this.getExpression(values, "-gt-label-priority", i);
            }
            if (priority != null) {
                tb.priority(priority);
            }
            this.addVendorOptions((SymbolizerBuilder<?>)tb, TEXT_VENDOR_OPTIONS, values, i);
        }
    }

    private void addRasterSymbolizer(CssRule cssRule, RuleBuilder ruleBuilder) {
        Map<String, List<Value>> values = cssRule.getPropertyValues(PseudoClass.ROOT, "raster", "rce");
        if (values == null || values.isEmpty()) {
            return;
        }
        int repeatCount = this.getMaxRepeatCount(values);
        for (int i = 0; i < repeatCount; ++i) {
            Value v;
            Expression geom;
            RasterSymbolizerBuilder rb = ruleBuilder.raster();
            Expression[] channelExpressions = this.getExpressionArray(values, "raster-channels", i);
            String[] constrastEnhancements = this.getStringArray(values, "raster-contrast-enhancement", i);
            HashMap<String, Expression> constrastParameters = new HashMap<String, Expression>();
            for (String cssKey : values.keySet()) {
                String sldKey;
                String vendorOptionKey = cssKey;
                if (vendorOptionKey.startsWith("-gt-")) {
                    vendorOptionKey = vendorOptionKey.substring(4);
                }
                if ((sldKey = CONTRASTENHANCMENT_VENDOR_OPTIONS.get(vendorOptionKey)) == null) continue;
                constrastParameters.put(sldKey, this.getExpression(values, cssKey, i));
            }
            Expression[] gammas = this.getExpressionArray(values, "raster-gamma", i);
            if (!"auto".equals(channelExpressions[0].evaluate(null, String.class))) {
                ChannelSelectionBuilder cs = rb.channelSelection();
                if (channelExpressions.length == 1) {
                    this.applyContrastEnhancement(cs.gray().channelName(channelExpressions[0]).contrastEnhancement(), constrastEnhancements, constrastParameters, gammas, 0);
                } else {
                    if (channelExpressions.length == 2 || channelExpressions.length > 3) {
                        throw new IllegalArgumentException("raster-channels can accept the name of one or three bands, not " + channelExpressions.length);
                    }
                    this.applyContrastEnhancement(cs.red().channelName(channelExpressions[0]).contrastEnhancement(), constrastEnhancements, constrastParameters, gammas, 0);
                    this.applyContrastEnhancement(cs.green().channelName(channelExpressions[1]).contrastEnhancement(), constrastEnhancements, constrastParameters, gammas, 1);
                    this.applyContrastEnhancement(cs.blue().channelName(channelExpressions[2]).contrastEnhancement(), constrastEnhancements, constrastParameters, gammas, 2);
                }
            } else {
                this.applyContrastEnhancement(rb.contrastEnhancement(), constrastEnhancements, constrastParameters, gammas, 0);
            }
            Expression opacity = this.getExpression(values, "raster-opacity", i);
            if (opacity != null) {
                rb.opacity(opacity);
            }
            if ((geom = this.getExpression(values, "raster-geometry", i)) != null) {
                rb.geometry(geom);
            }
            if ((v = this.getValue(values, "raster-color-map", i)) != null) {
                if (v instanceof Value.Function) {
                    v = new Value.MultiValue(v);
                }
                if (!(v instanceof Value.MultiValue)) {
                    throw new IllegalArgumentException("Invalid color map, it must be comprised of one or more color-map-entry function: " + v);
                }
                Value.MultiValue cm = (Value.MultiValue)v;
                ColorMapBuilder cmb = rb.colorMap();
                for (Value entry : cm.values) {
                    if (!(entry instanceof Value.Function)) {
                        throw new IllegalArgumentException("Invalid color map content, it must be a color-map-entry function" + entry);
                    }
                    Value.Function f = (Value.Function)entry;
                    if (!"color-map-entry".equals(f.name)) {
                        throw new IllegalArgumentException("Invalid color map content, it must be a color-map-entry function" + entry);
                    }
                    if (f.parameters.size() < 2 || f.parameters.size() > 4) {
                        throw new IllegalArgumentException("Invalid color map content, it must be a color-map-entry function with either 2 parameters (color and value) or 3 parameters (color, value and opacity) or 4 parameters (color, value, opacity and label) " + entry);
                    }
                    ColorMapEntryBuilder eb = cmb.entry();
                    eb.colorAsLiteral(this.wrapColorMapAttribute(f.parameters.get(0).toExpression()));
                    eb.quantityAsLiteral(this.wrapColorMapAttribute(f.parameters.get(1).toExpression()));
                    if (f.parameters.size() > 2) {
                        eb.opacityAsLiteral(this.wrapColorMapAttribute(f.parameters.get(2).toExpression()));
                    }
                    if (f.parameters.size() != 4) continue;
                    eb.label(f.parameters.get(3).toLiteral());
                }
                String type = this.getLiteral(values, "raster-color-map-type", i, null);
                if (type != null) {
                    if ("intervals".equals(type)) {
                        cmb.type(2);
                    } else if ("ramp".equals(type)) {
                        cmb.type(1);
                    } else if ("values".equals(type)) {
                        cmb.type(3);
                    } else {
                        throw new IllegalArgumentException("Invalid color map type " + type);
                    }
                }
            }
            this.addVendorOptions((SymbolizerBuilder<?>)rb, RASTER_VENDOR_OPTIONS, values, i);
        }
    }

    private String wrapColorMapAttribute(Expression expression) {
        if (expression instanceof Literal) {
            return expression.toString();
        }
        return "${" + CQL.toCQL((Expression)expression) + "}";
    }

    private void applyContrastEnhancement(ContrastEnhancementBuilder ceb, String[] constrastEnhancements, Map<String, Expression> constrastParameters, Expression[] gammas, int i) {
        if (constrastEnhancements != null && constrastEnhancements.length > 0) {
            String contrastEnhancementName = constrastEnhancements.length > i ? constrastEnhancements[0] : constrastEnhancements[i];
            if ("histogram".equals(contrastEnhancementName)) {
                ceb.histogram(constrastParameters);
            } else if ("normalize".equals(contrastEnhancementName)) {
                ceb.normalize(constrastParameters);
            } else if ("exponential".equals(contrastEnhancementName)) {
                ceb.exponential(constrastParameters);
            } else if ("logarithmic".equals(contrastEnhancementName)) {
                ceb.logarithmic(constrastParameters);
            } else if (!"none".equals(contrastEnhancementName)) {
                throw new IllegalArgumentException("Invalid contrast enhancement name " + contrastEnhancementName + ", valid values are 'none', 'histogram', 'normalize', 'exponential' or 'logarithmic'");
            }
        } else {
            ceb.unset();
        }
        if (gammas != null && gammas.length > 0) {
            Expression gamma = gammas.length > i ? gammas[0] : gammas[i];
            ceb.gamma(gamma);
        }
    }

    private void buildFill(CssRule cssRule, final FillBuilder fb, Map<String, List<Value>> values, int i, String fillPropertyName) {
        for (Value fillValue : this.getMultiValue(values, fillPropertyName, i)) {
            if (Value.Function.isGraphicsFunction(fillValue)) {
                new SubgraphicBuilder(fillPropertyName, fillValue, values, cssRule, i){

                    @Override
                    protected GraphicBuilder getGraphicBuilder() {
                        return fb.graphicFill();
                    }
                };
                continue;
            }
            if (fillValue == null) continue;
            fb.color(this.getExpression(fillValue));
        }
        Expression opacity = this.getExpression(values, fillPropertyName + "-opacity", i);
        if (opacity != null) {
            fb.opacity(opacity);
        }
    }

    private void addLineSymbolizer(CssRule cssRule, RuleBuilder ruleBuilder) {
        Map<String, List<Value>> values = cssRule.getPropertyValues(PseudoClass.ROOT, "stroke");
        if (values == null || values.isEmpty()) {
            return;
        }
        int repeatCount = this.getMaxRepeatCount(values);
        for (int i = 0; i < repeatCount; ++i) {
            Expression strokeOffset;
            if (this.getValue(values, "stroke", i) == null) continue;
            LineSymbolizerBuilder lb = ruleBuilder.line();
            Expression strokeGeometry = this.getExpression(values, "stroke-geometry", i);
            if (strokeGeometry != null) {
                lb.geometry(strokeGeometry);
            }
            if ((strokeOffset = this.getExpression(values, "stroke-offset", i)) != null && !this.isZero(strokeOffset)) {
                lb.perpendicularOffset(strokeOffset);
            }
            StrokeBuilder strokeBuilder = lb.stroke();
            this.buildStroke(cssRule, strokeBuilder, values, i);
            this.addVendorOptions((SymbolizerBuilder<?>)lb, LINE_VENDOR_OPTIONS, values, i);
        }
    }

    private boolean isZero(Expression expression) {
        if (!(expression instanceof Literal)) {
            return false;
        }
        Literal l = (Literal)expression;
        return (Double)l.evaluate(null, Double.class) == 0.0;
    }

    private void buildStroke(CssRule cssRule, final StrokeBuilder strokeBuilder, final Map<String, List<Value>> values, final int i) {
        Value dasharrayValue;
        boolean simpleStroke = false;
        for (Value strokeValue : this.getMultiValue(values, "stroke", i)) {
            if (Value.Function.isGraphicsFunction(strokeValue)) {
                new SubgraphicBuilder("stroke", strokeValue, values, cssRule, i){

                    @Override
                    protected GraphicBuilder getGraphicBuilder() {
                        String repeat = CssTranslator.this.getLiteral(values, "stroke-repeat", i, "repeat");
                        if ("repeat".equals(repeat)) {
                            return strokeBuilder.graphicStroke();
                        }
                        return strokeBuilder.fillBuilder();
                    }
                };
                continue;
            }
            if (strokeValue == null) continue;
            simpleStroke = true;
            strokeBuilder.color(strokeValue.toExpression());
        }
        if (simpleStroke) {
            Expression lineJoin;
            Expression lineCap;
            Expression width;
            Expression opacity = this.getExpression(values, "stroke-opacity", i);
            if (opacity != null) {
                strokeBuilder.opacity(opacity);
            }
            if ((width = this.getMeasureExpression(values, "stroke-width", i, "px")) != null) {
                strokeBuilder.width(width);
            }
            if ((lineCap = this.getExpression(values, "stroke-linecap", i)) != null) {
                strokeBuilder.lineCap(lineCap);
            }
            if ((lineJoin = this.getExpression(values, "stroke-linejoin", i)) != null) {
                strokeBuilder.lineJoin(lineJoin);
            }
        }
        if (this.isLiterals(dasharrayValue = this.getValue(values, "stroke-dasharray", i))) {
            float[] dasharray = this.getFloatArray(values, "stroke-dasharray", i);
            if (dasharray != null) {
                strokeBuilder.dashArray(dasharray);
            }
        } else if (dasharrayValue instanceof Value.MultiValue) {
            Value.MultiValue mv = (Value.MultiValue)dasharrayValue;
            ArrayList<Expression> expressions = new ArrayList<Expression>();
            for (Value v : mv.values) {
                expressions.add(v.toExpression());
            }
            strokeBuilder.dashArray(expressions);
        } else if (dasharrayValue != null) {
            ArrayList<Expression> expressions = new ArrayList<Expression>();
            expressions.add(dasharrayValue.toExpression());
            strokeBuilder.dashArray(expressions);
        }
        Expression dashOffset = this.getMeasureExpression(values, "stroke-dashoffset", i, "px");
        if (dashOffset != null) {
            strokeBuilder.dashOffset(dashOffset);
        }
    }

    private boolean isLiterals(Value value) {
        if (value instanceof Value.Literal) {
            return true;
        }
        if (value instanceof Value.MultiValue) {
            Value.MultiValue mv = (Value.MultiValue)value;
            for (Value v : mv.values) {
                if (v instanceof Value.Literal) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void addVendorOptions(SymbolizerBuilder<?> sb, Map<String, String> vendorOptions, Map<String, List<Value>> values, int idx) {
        for (String cssKey : values.keySet()) {
            String value;
            String sldKey;
            String vendorOptionKey = cssKey;
            if (vendorOptionKey.startsWith("-gt-")) {
                vendorOptionKey = vendorOptionKey.substring(4);
            }
            if ((sldKey = vendorOptions.get(vendorOptionKey)) == null || (value = this.getLiteral(values, cssKey, idx, null)) == null) continue;
            sb.option(sldKey, value);
        }
    }

    private void buildMark(Value markName, CssRule cssRule, String indexedPseudoClass, int idx, GraphicBuilder gb) {
        Expression rotation;
        MarkBuilder mark = gb.mark();
        mark.name(markName.toExpression());
        Map<String, List<Value>> values = this.getValuesForIndexedPseudoClass(cssRule, indexedPseudoClass, idx);
        if (values == null || values.isEmpty()) {
            mark.fill().reset();
            mark.stroke().reset();
        } else {
            if (values.containsKey("fill") && values.get("fill") != null) {
                FillBuilder fb = mark.fill();
                this.buildFill(cssRule, fb, values, idx, "fill");
            } else if (!values.containsKey("fill")) {
                mark.fill();
            }
            if (values.containsKey("stroke") && values.get("stroke") != null) {
                StrokeBuilder sb = mark.stroke();
                this.buildStroke(cssRule, sb, values, idx);
            } else if (!values.containsKey("stroke")) {
                mark.stroke();
            }
        }
        Expression size = this.getMeasureExpression(values, "size", idx, "px");
        if (size != null) {
            gb.size(size);
        }
        if ((rotation = this.getMeasureExpression(values, "rotation", idx, "deg")) != null) {
            gb.rotation(rotation);
        }
    }

    private Map<String, List<Value>> getValuesForIndexedPseudoClass(CssRule cssRule, String pseudoClassName, int idx) {
        LinkedHashMap<String, List<Value>> combined = new LinkedHashMap<String, List<Value>>();
        combined.putAll(cssRule.getPropertyValues(PseudoClass.newPseudoClass("symbol"), new String[0]));
        combined.putAll(cssRule.getPropertyValues(PseudoClass.newPseudoClass("symbol", idx + 1), new String[0]));
        combined.putAll(cssRule.getPropertyValues(PseudoClass.newPseudoClass(pseudoClassName), new String[0]));
        combined.putAll(cssRule.getPropertyValues(PseudoClass.newPseudoClass(pseudoClassName, idx + 1), new String[0]));
        return combined;
    }

    private Expression getExpression(Map<String, List<Value>> valueMap, String name, int i) {
        Value v = this.getValue(valueMap, name, i);
        return this.getExpression(v);
    }

    private Expression getExpression(Value v) {
        if (v == null) {
            return null;
        }
        if (v instanceof Value.MultiValue) {
            return ((Value.MultiValue)v).values.get(0).toExpression();
        }
        return v.toExpression();
    }

    private Expression getMeasureExpression(Map<String, List<Value>> valueMap, String name, int i, String defaultUnit) {
        Value v = this.getValue(valueMap, name, i);
        return this.getMeasureExpression(v, defaultUnit);
    }

    private Expression getMeasureExpression(Value v, String defaultUnit) {
        if (v == null) {
            return null;
        }
        if (v instanceof Value.Literal) {
            String literal = v.toLiteral();
            if (literal.endsWith(defaultUnit)) {
                String simplified = literal.substring(0, literal.length() - defaultUnit.length());
                return FF.literal((Object)simplified);
            }
            return FF.literal((Object)literal);
        }
        return v.toExpression();
    }

    private Value getValue(Map<String, List<Value>> valueMap, String name, int i) {
        List<Value> values = valueMap.get(name);
        if (values == null || values.isEmpty()) {
            return null;
        }
        Value result = null;
        if (values.size() == 1) {
            result = values.get(0);
        } else if (i < values.size()) {
            result = values.get(i);
        }
        if (result == null || result instanceof Value.None) {
            return null;
        }
        return result;
    }

    private List<Value> getMultiValue(Map<String, List<Value>> valueMap, String name, int i) {
        Value value = this.getValue(valueMap, name, i);
        if (value instanceof Value.MultiValue) {
            return ((Value.MultiValue)value).values;
        }
        if (value == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(value);
    }

    public int getMaxMultiValueSize(Map<String, List<Value>> valueMap, int i, String ... names) {
        int max = 0;
        for (String name : names) {
            List<Value> values = this.getMultiValue(valueMap, name, i);
            int size = values.size();
            if (size <= max) continue;
            max = size;
        }
        return max;
    }

    public Value getValueInMulti(Map<String, List<Value>> valueMap, String name, int i, int valueIdx) {
        List<Value> values = this.getMultiValue(valueMap, name, i);
        if (values.isEmpty()) {
            return null;
        }
        if (values.size() <= valueIdx) {
            return values.get(values.size() - 1);
        }
        return values.get(valueIdx);
    }

    private String getLiteral(Map<String, List<Value>> valueMap, String name, int i, String defaultValue) {
        Value v = this.getValue(valueMap, name, i);
        if (v == null) {
            return defaultValue;
        }
        return v.toLiteral();
    }

    private float[] getFloatArray(Map<String, List<Value>> valueMap, String name, int i) {
        double[] doubles = this.getDoubleArray(valueMap, name, i);
        if (doubles == null) {
            return null;
        }
        float[] floats = new float[doubles.length];
        for (int j = 0; j < doubles.length; ++j) {
            floats[j] = (float)doubles[j];
        }
        return floats;
    }

    private double[] getDoubleArray(Map<String, List<Value>> valueMap, String name, int i) {
        Value v = this.getValue(valueMap, name, i);
        if (v == null) {
            return null;
        }
        if (v instanceof Value.MultiValue) {
            Value.MultiValue m = (Value.MultiValue)v;
            if (m.values.size() == 0) {
                return null;
            }
            double[] result = new double[m.values.size()];
            for (int j = 0; j < m.values.size(); ++j) {
                String literal = m.values.get(j).toLiteral();
                if (literal.endsWith("%")) {
                    literal = literal.substring(0, literal.length() - 1);
                    double d = Double.parseDouble(literal);
                    result[j] = d / 100.0;
                    continue;
                }
                result[j] = Double.parseDouble(literal);
            }
            return result;
        }
        return new double[]{Double.parseDouble(v.toLiteral())};
    }

    private String[] getStringArray(Map<String, List<Value>> valueMap, String name, int i) {
        Value v = this.getValue(valueMap, name, i);
        if (v == null) {
            return null;
        }
        if (v instanceof Value.MultiValue) {
            Value.MultiValue m = (Value.MultiValue)v;
            if (m.values.size() == 0) {
                return null;
            }
            String[] result = new String[m.values.size()];
            for (int j = 0; j < m.values.size(); ++j) {
                result[j] = m.values.get(j).toLiteral();
            }
            return result;
        }
        return new String[]{v.toLiteral()};
    }

    private Expression[] getExpressionArray(Map<String, List<Value>> valueMap, String name, int i) {
        Value v = this.getValue(valueMap, name, i);
        if (v == null) {
            return null;
        }
        if (v instanceof Value.MultiValue) {
            Value.MultiValue m = (Value.MultiValue)v;
            if (m.values.size() == 0) {
                return null;
            }
            Expression[] result = new Expression[m.values.size()];
            for (int j = 0; j < m.values.size(); ++j) {
                result[j] = m.values.get(j).toExpression();
            }
            return result;
        }
        return new Expression[]{v.toExpression()};
    }

    private int getMaxRepeatCount(Map<String, List<Value>> valueMap) {
        int max = 1;
        for (List<Value> values : valueMap.values()) {
            max = Math.max(max, values.size());
        }
        return max;
    }

    public static void main(String[] args) throws IOException, TransformerException {
        File output;
        File outputParent;
        File input;
        if (args.length != 2) {
            System.err.println("Usage: CssTranslator <input.css> <output.sld>");
            System.exit(-1);
        }
        if (!(input = new File(args[0])).exists()) {
            System.err.println("Could not locate input file " + input.getPath());
            System.exit(-2);
        }
        if (!(outputParent = (output = new File(args[1])).getParentFile()).exists() && !outputParent.mkdirs()) {
            System.err.println("Output file parent directory does not exist, and cannot be created: " + outputParent.getPath());
            System.exit(-2);
        }
        long start = System.currentTimeMillis();
        String css = FileUtils.readFileToString((File)input, (String)"UTF-8");
        Stylesheet styleSheet = CssParser.parse(css);
        ConsoleHandler handler = new ConsoleHandler();
        handler.setLevel(Level.FINE);
        Logging.getLogger(CssTranslator.class).setLevel(Level.FINE);
        Logging.getLogger(CssTranslator.class).addHandler(handler);
        CssTranslator translator = new CssTranslator();
        org.opengis.style.Style style = translator.translate(styleSheet);
        StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory();
        StyledLayerDescriptor sld = styleFactory.createStyledLayerDescriptor();
        NamedLayer layer = styleFactory.createNamedLayer();
        layer.addStyle((Style)style);
        sld.layers().add(layer);
        SLDTransformer tx = new SLDTransformer();
        tx.setIndentation(2);
        try (FileOutputStream fos = new FileOutputStream(output);){
            tx.transform((Object)sld, (OutputStream)fos);
        }
        long end = System.currentTimeMillis();
        System.out.println("Translation performed in " + (double)(end - start) / 1000.0 + " seconds");
    }

    abstract class SubgraphicBuilder {
        public SubgraphicBuilder(String propertyName, Value v, Map<String, List<Value>> values, CssRule cssRule, int i) {
            if (v != null) {
                Expression opacity;
                Expression size;
                if (!(v instanceof Value.Function)) {
                    throw new IllegalArgumentException("The value of '" + propertyName + "' must be a symbol or a url");
                }
                Value.Function f = (Value.Function)v;
                GraphicBuilder gb = this.getGraphicBuilder();
                if ("symbol".equals(f.name)) {
                    CssTranslator.this.buildMark(f.parameters.get(0), cssRule, propertyName, i, gb);
                } else if ("url".equals(f.name)) {
                    Value graphicLocation = f.parameters.get(0);
                    String location = graphicLocation.toLiteral();
                    String mime = CssTranslator.this.getLiteral(values, propertyName + "-mime", i, "image/jpeg");
                    gb.externalGraphic(location, mime);
                } else {
                    throw new IllegalArgumentException("'" + propertyName + "' accepts either a 'symbol' or a 'url' function, the following function is unrecognized: " + f);
                }
                Expression rotation = CssTranslator.this.getMeasureExpression(values, propertyName + "-rotation", i, "deg");
                if (rotation != null) {
                    gb.rotation(rotation);
                }
                if ((size = CssTranslator.this.getMeasureExpression(values, propertyName + "-size", i, "px")) != null) {
                    gb.size(size);
                }
                Expression[] anchor = CssTranslator.this.getExpressionArray(values, propertyName + "-anchor", i);
                Expression[] offsets = CssTranslator.this.getExpressionArray(values, propertyName + "-offset", i);
                if (anchor != null) {
                    if (anchor.length == 2) {
                        gb.anchor().x(anchor[0]);
                        gb.anchor().y(anchor[1]);
                    } else if (anchor.length == 1) {
                        gb.anchor().x(anchor[0]);
                        gb.anchor().y(anchor[0]);
                    } else {
                        throw new IllegalArgumentException("Invalid anchor specification, should be two floats between 0 and 1 with a space in between, instead it is " + CssTranslator.this.getValue(values, propertyName + "-anchor", i));
                    }
                }
                if (offsets != null) {
                    if (offsets.length == 2) {
                        gb.displacement().x(offsets[0]);
                        gb.displacement().y(offsets[1]);
                    } else if (offsets.length == 1) {
                        gb.displacement().x(offsets[0]);
                        gb.displacement().y(offsets[0]);
                    } else {
                        throw new IllegalArgumentException("Invalid anchor specification, should be two floats (or 1 for line placement with a certain offset) instead it is " + CssTranslator.this.getValue(values, propertyName + "-anchor", i));
                    }
                }
                if ("mark".equals(propertyName) && (opacity = CssTranslator.this.getExpression(values, "mark-opacity", i)) != null) {
                    gb.opacity(opacity);
                }
            }
        }

        protected abstract GraphicBuilder getGraphicBuilder();
    }

    static enum TranslationMode {
        Exclusive,
        Simple,
        Flat,
        Auto;

    }
}

