/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.css.selector;

import java.util.ArrayList;
import java.util.List;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.filter.visitor.SimplifyingFilterVisitor;
import org.geotools.styling.css.selector.Selector;
import org.geotools.styling.css.selector.SelectorVisitor;
import org.geotools.styling.css.selector.Specificity;
import org.geotools.styling.css.util.FilterSpecificityExtractor;
import org.geotools.styling.css.util.UnboundSimplifyingFilterVisitor;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;

public class Data
extends Selector {
    public static final FilterFactory2 FF = CommonFactoryFinder.getFilterFactory2();
    public Filter filter;
    public FeatureType featureType;

    public static Selector combineAnd(List<Data> selectors, Object ctx) {
        SimplifyingFilterVisitor visitor;
        if (selectors.size() == 1) {
            return selectors.get(0);
        }
        ArrayList<Filter> filters = new ArrayList<Filter>();
        FeatureType featureType = null;
        for (Data selector : selectors) {
            filters.add(selector.filter);
            featureType = selector.featureType;
        }
        And and = FF.and(filters);
        if (ctx instanceof SimplifyingFilterVisitor) {
            visitor = (SimplifyingFilterVisitor)ctx;
        } else {
            visitor = new UnboundSimplifyingFilterVisitor();
            visitor.setFeatureType(featureType);
        }
        Filter simplified = (Filter)and.accept((FilterVisitor)visitor, null);
        if (Filter.INCLUDE.equals(simplified)) {
            return ACCEPT;
        }
        if (Filter.EXCLUDE.equals(simplified)) {
            return REJECT;
        }
        return new Data(simplified);
    }

    public Data(Filter filter) {
        this.filter = filter;
    }

    public Data(String filter) {
        try {
            this.filter = ECQL.toFilter((String)filter);
        }
        catch (CQLException e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.filter == null ? 0 : this.filter.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Data other = (Data)obj;
        return !(this.filter == null ? other.filter != null : !this.filter.equals(other.filter));
    }

    public String toString() {
        return "OGCFilter [filter=" + ECQL.toCQL((Filter)this.filter) + "]";
    }

    @Override
    public Specificity getSpecificity() {
        FilterSpecificityExtractor extractor = new FilterSpecificityExtractor();
        this.filter.accept((FilterVisitor)extractor, null);
        return new Specificity(0, extractor.getSpecificityScore(), 0);
    }

    @Override
    public Object accept(SelectorVisitor visitor) {
        return visitor.visit(this);
    }
}

