/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.css.selector;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.styling.css.selector.Accept;
import org.geotools.styling.css.selector.And;
import org.geotools.styling.css.selector.Composite;
import org.geotools.styling.css.selector.Data;
import org.geotools.styling.css.selector.Id;
import org.geotools.styling.css.selector.Or;
import org.geotools.styling.css.selector.PseudoClass;
import org.geotools.styling.css.selector.Reject;
import org.geotools.styling.css.selector.ScaleRange;
import org.geotools.styling.css.selector.SelectorVisitor;
import org.geotools.styling.css.selector.Specificity;
import org.geotools.styling.css.selector.TypeName;
import org.geotools.util.logging.Logging;

public abstract class Selector
implements Comparable<Selector> {
    private static List<AndCombiner> AND_COMBINERS;
    static final Logger LOGGER;
    public static final Selector ACCEPT;
    public static final Selector REJECT;

    public static Selector and(Selector s1, Selector s2) {
        return Selector.and(s1, s2, null);
    }

    public static Selector and(Selector s1, Selector s2, Object context) {
        Selector result = Selector.andInternal(s1, s2, context);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Combined " + s1 + " and " + s2 + " into: " + result);
        }
        return result;
    }

    private static Selector andInternal(Selector s1, Selector s2, Object context) {
        if (s1 instanceof Accept) {
            return s2;
        }
        if (s2 instanceof Accept) {
            return s1;
        }
        if (s1 instanceof Reject || s2 instanceof Reject) {
            return REJECT;
        }
        if (s1 instanceof Or) {
            return Selector.foldInOr((Or)s1, s2, context);
        }
        if (s2 instanceof Or) {
            return Selector.foldInOr((Or)s2, s1, context);
        }
        ArrayList<Selector> selectors = new ArrayList<Selector>();
        Selector.flatten(selectors, s1, And.class);
        Selector.flatten(selectors, s2, And.class);
        Map<Class, List<Selector>> classifieds = Selector.mapByClass(selectors);
        if (classifieds.get(Reject.class) != null) {
            return REJECT;
        }
        classifieds.remove(Accept.class);
        for (AndCombiner combiner : AND_COMBINERS) {
            List<Selector> classSelectors = classifieds.get(combiner.clazz);
            if (classSelectors == null || classSelectors.size() <= 1) continue;
            try {
                Selector result = (Selector)combiner.andMethod.invoke(null, classSelectors, context);
                if (result == REJECT) {
                    return REJECT;
                }
                if (result == ACCEPT) {
                    classifieds.remove(combiner.clazz);
                    continue;
                }
                if (result instanceof And) {
                    classifieds.put(combiner.clazz, new ArrayList<Selector>(((Composite)result).getChildren()));
                    continue;
                }
                classifieds.put(combiner.clazz, Collections.singletonList(result));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        ArrayList<Selector> finalList = new ArrayList<Selector>();
        for (Class c : classifieds.keySet()) {
            List<Selector> list = classifieds.get(c);
            if (list == null) continue;
            finalList.addAll(list);
        }
        if (finalList.size() == 0) {
            return ACCEPT;
        }
        if (finalList.size() == 1) {
            return (Selector)finalList.get(0);
        }
        return new And(finalList);
    }

    private static Selector foldInOr(Or or, Selector anded, Object context) {
        ArrayList<Selector> newChildren = new ArrayList<Selector>();
        for (Selector s : or.getChildren()) {
            Selector combined = Selector.and(s, anded, context);
            if (combined == ACCEPT) {
                return ACCEPT;
            }
            if (combined == REJECT) continue;
            newChildren.add(combined);
        }
        if (newChildren.size() == 0) {
            return REJECT;
        }
        ArrayList<Selector> selectors = new ArrayList<Selector>();
        for (Selector child : newChildren) {
            Selector.flatten(selectors, child, Or.class);
        }
        return new Or(selectors);
    }

    public static Selector or(Selector s1, Selector s2, Object context) {
        if (s1 instanceof Reject) {
            return s2;
        }
        if (s2 instanceof Reject) {
            return s1;
        }
        if (s1 instanceof Accept || s2 instanceof Accept) {
            return ACCEPT;
        }
        ArrayList<Selector> selectors = new ArrayList<Selector>();
        Selector.flatten(selectors, s1, Or.class);
        Selector.flatten(selectors, s2, Or.class);
        Map<Class, List<Selector>> classifieds = Selector.mapByClass(selectors);
        if (classifieds.get(Accept.class) != null) {
            return ACCEPT;
        }
        classifieds.remove(Reject.class);
        ArrayList<Selector> finalList = new ArrayList<Selector>();
        for (Class c : classifieds.keySet()) {
            List<Selector> list = classifieds.get(c);
            if (list == null) continue;
            finalList.addAll(list);
        }
        if (finalList.size() == 0) {
            return REJECT;
        }
        if (finalList.size() == 1) {
            return (Selector)finalList.get(0);
        }
        return new Or(finalList);
    }

    private static void flatten(List<Selector> selectors, Selector s, Class<? extends Composite> clazz) {
        if (!clazz.isInstance(s)) {
            selectors.add(s);
        } else {
            Composite composite = (Composite)s;
            for (Selector child : composite.getChildren()) {
                Selector.flatten(selectors, child, clazz);
            }
        }
    }

    private static Map<Class, List<Selector>> mapByClass(List<Selector> selectors) {
        LinkedHashMap<Class, List<Selector>> result = new LinkedHashMap<Class, List<Selector>>();
        for (Selector s : selectors) {
            Class<?> clazz = s.getClass();
            ArrayList<Selector> list = (ArrayList<Selector>)result.get(clazz);
            if (list == null) {
                list = new ArrayList<Selector>();
                result.put(clazz, list);
            }
            list.add(s);
        }
        return result;
    }

    public abstract Specificity getSpecificity();

    @Override
    public int compareTo(Selector o) {
        return this.getSpecificity().compareTo(o.getSpecificity());
    }

    public abstract Object accept(SelectorVisitor var1);

    static {
        Class[] baseClasses = new Class[]{TypeName.class, ScaleRange.class, Id.class, Data.class, PseudoClass.class};
        AND_COMBINERS = new ArrayList<AndCombiner>();
        for (Class baseClass : baseClasses) {
            try {
                Method combineAnd = baseClass.getDeclaredMethod("combineAnd", List.class, Object.class);
                AND_COMBINERS.add(new AndCombiner(baseClass, combineAnd));
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new RuntimeException(e);
            }
        }
        LOGGER = Logging.getLogger(Selector.class);
        ACCEPT = new Accept();
        REJECT = new Reject();
    }

    private static class AndCombiner {
        Class clazz;
        Method andMethod;

        public AndCombiner(Class clazz, Method method) {
            this.clazz = clazz;
            this.andMethod = method;
        }
    }
}

