/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.css.util;

import java.util.ArrayList;
import java.util.List;
import org.geotools.styling.css.util.Signature;

public abstract class FilteredPowerSetBuilder<T, R> {
    private List<T> domain;
    private List<List<Signature>> rejects = new ArrayList<List<Signature>>();

    public FilteredPowerSetBuilder(List<T> domain) {
        this.domain = domain;
    }

    protected boolean rejected(Signature s, int k) {
        int cardinality = s.cardinality();
        int max = Math.min(this.rejects.size(), cardinality);
        for (int i = 0; i < max; ++i) {
            List<Signature> signatures = this.rejects.get(i);
            if (signatures == null || !this.rejected(s, k, signatures)) continue;
            return true;
        }
        return false;
    }

    private boolean rejected(Signature s, int k, List<Signature> signatures) {
        for (Signature reject : signatures) {
            if (!s.contains(reject, k)) continue;
            return true;
        }
        return false;
    }

    public List<R> buildPowerSet() {
        List result = new ArrayList();
        Signature s = Signature.newSignature(this.domain.size());
        this.fill(s, 0, this.domain.size(), result);
        result = this.postFilterResult(result);
        return result;
    }

    protected List<R> postFilterResult(List<R> result) {
        return result;
    }

    void fill(Signature s, int k, int n, List<R> result) {
        List<T> objects = this.listFromSignature(s);
        if (!objects.isEmpty() && !this.accept(objects)) {
            Signature cloned = (Signature)s.clone();
            int cardinality = cloned.cardinality();
            while (this.rejects.size() <= cardinality) {
                this.rejects.add(null);
            }
            List<Signature> signatures = this.rejects.get(cardinality);
            if (signatures == null) {
                signatures = new ArrayList<Signature>();
                this.rejects.set(cardinality, signatures);
            }
            signatures.add(cloned);
            return;
        }
        if (k == n) {
            List<R> combined = this.buildResult(objects);
            if (combined != null) {
                result.addAll(combined);
            }
        } else {
            s.set(k, true);
            List<List<Signature>> storedRejects = this.cloneRejects();
            if (!this.rejected(s, k)) {
                this.fill(s, k + 1, n, result);
            }
            this.rejects = storedRejects;
            if (!this.isInclude(this.domain.get(k))) {
                s.set(k, false);
                if (!this.rejected(s, k)) {
                    this.fill(s, k + 1, n, result);
                }
            }
        }
    }

    protected abstract boolean isInclude(T var1);

    List<List<Signature>> cloneRejects() {
        ArrayList<List<Signature>> result = new ArrayList<List<Signature>>();
        for (List<Signature> l : this.rejects) {
            result.add(new ArrayList<Signature>(l));
        }
        return result;
    }

    protected abstract List<R> buildResult(List<T> var1);

    protected abstract boolean accept(List<T> var1);

    private List<T> listFromSignature(Signature signature) {
        ArrayList test = new ArrayList();
        signature.foreach(i -> test.add(this.domain.get(i)));
        return test;
    }
}

