/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.css.util;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.identity.FeatureId;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.css.selector.Accept;
import org.geotools.styling.css.selector.And;
import org.geotools.styling.css.selector.Data;
import org.geotools.styling.css.selector.Id;
import org.geotools.styling.css.selector.Or;
import org.geotools.styling.css.selector.PseudoClass;
import org.geotools.styling.css.selector.Reject;
import org.geotools.styling.css.selector.ScaleRange;
import org.geotools.styling.css.selector.Selector;
import org.geotools.styling.css.selector.SelectorVisitor;
import org.geotools.styling.css.selector.TypeName;
import org.geotools.styling.css.selector.ZoomRange;
import org.geotools.styling.css.util.UnboundSimplifyingFilterVisitor;

public class OgcFilterBuilder
implements SelectorVisitor {
    public static OgcFilterBuilder INSTANCE = new OgcFilterBuilder();
    static final FilterFactory FF = CommonFactoryFinder.getFilterFactory();

    @Override
    public Object visit(Accept accept) {
        return Filter.INCLUDE;
    }

    @Override
    public Object visit(Reject reject) {
        return Filter.EXCLUDE;
    }

    @Override
    public Object visit(Id id) {
        if (id.ids == null || id.ids.isEmpty()) {
            return Filter.INCLUDE;
        }
        LinkedHashSet<FeatureId> identifiers = new LinkedHashSet<FeatureId>();
        for (String identifier : id.ids) {
            FeatureId featureId = FF.featureId(identifier);
            identifiers.add(featureId);
        }
        return FF.id(identifiers);
    }

    @Override
    public Object visit(Data data) {
        return data.filter;
    }

    @Override
    public Object visit(And and) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        for (Selector child : and.getChildren()) {
            Filter filter = (Filter)child.accept(this);
            if (filter == Filter.EXCLUDE) {
                return Filter.EXCLUDE;
            }
            if (filter == Filter.INCLUDE) continue;
            filters.add(filter);
        }
        if (filters.isEmpty()) {
            return Filter.INCLUDE;
        }
        return FF.and(filters);
    }

    @Override
    public Object visit(Or or) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        for (Selector child : or.getChildren()) {
            Filter filter = (Filter)child.accept(this);
            if (filter == Filter.INCLUDE) {
                return Filter.INCLUDE;
            }
            if (filter == Filter.EXCLUDE) continue;
            filters.add(filter);
        }
        if (filters.isEmpty()) {
            return Filter.EXCLUDE;
        }
        return FF.or(filters);
    }

    @Override
    public Object visit(TypeName typeName) {
        return Filter.INCLUDE;
    }

    @Override
    public Object visit(ScaleRange scaleRange) {
        return Filter.INCLUDE;
    }

    @Override
    public Object visit(ZoomRange zoomRange) {
        return Filter.INCLUDE;
    }

    @Override
    public Object visit(PseudoClass pseudoClass) {
        return Filter.INCLUDE;
    }

    public static Filter buildFilter(Selector selector, FeatureType targetFeatureType) {
        Filter filter = (Filter)selector.accept(INSTANCE);
        UnboundSimplifyingFilterVisitor simplifier = new UnboundSimplifyingFilterVisitor();
        simplifier.setFeatureType(targetFeatureType);
        return (Filter)filter.accept((FilterVisitor)simplifier, null);
    }
}

