/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.css;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.filter.And;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.filter.visitor.SimplifyingFilterVisitor;
import org.geotools.styling.css.CssRule;
import org.geotools.styling.css.FilterComplexityVisitor;
import org.geotools.styling.css.selector.Data;
import org.geotools.styling.css.selector.Or;
import org.geotools.styling.css.selector.ScaleRange;
import org.geotools.styling.css.selector.Selector;
import org.geotools.styling.css.util.OgcFilterBuilder;
import org.geotools.styling.css.util.ScaleRangeExtractor;
import org.geotools.styling.css.util.UnboundSimplifyingFilterVisitor;
import org.geotools.styling.zoom.ZoomContext;
import org.geotools.util.NumberRange;
import org.geotools.util.Range;
import org.geotools.util.logging.Logging;

class DomainCoverage {
    static final NumberRange<Double> FULL_SCALE_RANGE = new NumberRange(Double.class, (Number)0.0, (Number)Double.POSITIVE_INFINITY);
    static final Logger LOGGER = Logging.getLogger(DomainCoverage.class);
    static final FilterFactory FF = CommonFactoryFinder.getFilterFactory();
    private List<SLDSelector> elements;
    private FeatureType targetFeatureType;
    private UnboundSimplifyingFilterVisitor simplifier;
    Set<SLDSelector> generatedSelectors = new HashSet<SLDSelector>();
    boolean exclusiveRulesEnabled = true;
    int complexityThreshold = 0;
    private final ZoomContext zoomContext;

    public DomainCoverage(FeatureType targetFeatureType, UnboundSimplifyingFilterVisitor simplifier, ZoomContext zoomContext) {
        this.elements = new ArrayList<SLDSelector>();
        this.targetFeatureType = targetFeatureType;
        this.simplifier = simplifier;
        this.zoomContext = zoomContext;
    }

    public List<CssRule> addRule(CssRule rule) {
        int totalComplexity;
        Selector selector = rule.getSelector();
        List<SLDSelector> ruleCoverage = this.toSLDSelectors(selector, this.targetFeatureType).stream().filter(s -> !this.generatedSelectors.contains(s)).collect(Collectors.toList());
        if (ruleCoverage.isEmpty()) {
            return Collections.emptyList();
        }
        this.generatedSelectors.addAll(ruleCoverage);
        if (this.exclusiveRulesEnabled && this.complexityThreshold > 0 && (totalComplexity = this.getTotalComplexity()) > this.complexityThreshold) {
            LOGGER.log(Level.INFO, "Switching CSS translation to non exclusive mode as total domain coverage complexity {0} went above threshold {1}", new Object[]{totalComplexity, this.complexityThreshold});
            this.exclusiveRulesEnabled = false;
        }
        if (!this.exclusiveRulesEnabled) {
            return this.coverageToRules(rule, ruleCoverage);
        }
        if (this.elements.isEmpty()) {
            this.elements.addAll(ruleCoverage);
            return this.coverageToRules(rule, ruleCoverage);
        }
        List<SLDSelector> reducedCoverage = new ArrayList<SLDSelector>(ruleCoverage);
        for (SLDSelector element : this.elements) {
            ArrayList<SLDSelector> difference = new ArrayList<SLDSelector>();
            for (SLDSelector rc : reducedCoverage) {
                List<SLDSelector> ruleDifference = rc.difference(element);
                difference.addAll(ruleDifference);
            }
            reducedCoverage = difference;
            if (!reducedCoverage.isEmpty()) continue;
            break;
        }
        if (!reducedCoverage.isEmpty()) {
            ArrayList<CssRule> derivedRules = new ArrayList<CssRule>();
            reducedCoverage = this.combineSLDSelectors(reducedCoverage);
            for (SLDSelector rc : reducedCoverage) {
                derivedRules.add(new CssRule(rc.toSelector(this.simplifier), rule.getProperties(), rule.getComment()));
            }
            this.elements.addAll(reducedCoverage);
            this.elements = this.combineSLDSelectors(this.elements);
            return derivedRules;
        }
        return Collections.emptyList();
    }

    private List<SLDSelector> combineSLDSelectors(List<SLDSelector> elements) {
        Collections.sort(elements, new SLDSelectorComparator());
        ArrayList<SLDSelector> combined = new ArrayList<SLDSelector>();
        SLDSelector prev = null;
        for (SLDSelector ss : elements) {
            if (prev == null) {
                prev = ss;
                continue;
            }
            if (prev.scaleRange.equals(ss.scaleRange)) {
                org.geotools.api.filter.Or or = FF.or(ss.filter, prev.filter);
                Filter simplified = this.simplify((Filter)or);
                prev = new SLDSelector(prev.scaleRange, simplified);
                continue;
            }
            if (prev.scaleRange.getMaximum() == ss.scaleRange.getMinimum() && prev.filter.equals(ss.filter)) {
                NumberRange combinedRange = new NumberRange(Double.class, (Number)prev.scaleRange.getMinimum(), prev.scaleRange.isMinIncluded(), (Number)ss.scaleRange.getMaximum(), ss.scaleRange.isMaxIncluded());
                prev = new SLDSelector(combinedRange, prev.filter);
                continue;
            }
            combined.add(prev);
            prev = ss;
        }
        if (prev != null) {
            combined.add(prev);
        }
        return combined;
    }

    private int getTotalComplexity() {
        int total = 0;
        for (SLDSelector selector : this.elements) {
            total += selector.getComplexity();
        }
        return total;
    }

    private List<CssRule> coverageToRules(CssRule rule, List<SLDSelector> ruleCoverage) {
        ArrayList<CssRule> result = new ArrayList<CssRule>();
        for (SLDSelector ss : ruleCoverage) {
            result.add(new CssRule(ss.toSelector(this.simplifier), rule.getProperties(), rule.getComment()));
        }
        return result;
    }

    List<SLDSelector> toSLDSelectors(Selector selector, FeatureType targetFeatureType) {
        ArrayList<SLDSelector> result = new ArrayList<SLDSelector>();
        if (selector instanceof Or) {
            Or or = (Or)selector;
            for (Selector s : or.getChildren()) {
                if (s instanceof Or) {
                    throw new IllegalArgumentException("Unexpected or selector nested inside another one, at this point they should have been all flattened: " + selector);
                }
                this.toIndependentSLDSelectors(s, targetFeatureType, result);
            }
        } else {
            this.toIndependentSLDSelectors(selector, targetFeatureType, result);
        }
        return result;
    }

    private void toIndependentSLDSelectors(Selector selector, FeatureType targetFeatureType, List<SLDSelector> scaleDependentFilters) {
        Range<Double> range = ScaleRangeExtractor.getScaleRange(selector, this.zoomContext);
        if (range == null) {
            range = FULL_SCALE_RANGE;
        }
        Filter filter = OgcFilterBuilder.buildFilter(selector, targetFeatureType);
        boolean merged = false;
        for (SLDSelector existing : scaleDependentFilters) {
            if (!existing.scaleRange.equals(range)) continue;
            if (existing.filter instanceof org.geotools.api.filter.Or) {
                org.geotools.api.filter.Or or = (org.geotools.api.filter.Or)existing.filter;
                ArrayList<Filter> children = new ArrayList<Filter>(or.getChildren());
                children.add(filter);
                existing.filter = this.simplify((Filter)FF.or(children));
            } else {
                existing.filter = this.simplify((Filter)FF.or(existing.filter, filter));
            }
            merged = true;
            break;
        }
        if (!merged) {
            scaleDependentFilters.add(new SLDSelector(new NumberRange(range), filter));
        }
    }

    Filter simplify(Filter filter) {
        return (Filter)filter.accept((FilterVisitor)this.simplifier, null);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DomainCoverage[items=").append(this.elements.size()).append(",\n");
        for (SLDSelector selector : this.elements) {
            sb.append(selector).append("\n");
        }
        sb.append("] // DomainCoverage end");
        return sb.toString();
    }

    void setExclusiveRulesEnabled(boolean exclusiveRulesEnabled) {
        this.exclusiveRulesEnabled = exclusiveRulesEnabled;
    }

    private class SLDSelectorComparator
    implements Comparator<SLDSelector> {
        private SLDSelectorComparator() {
        }

        @Override
        public int compare(SLDSelector o1, SLDSelector o2) {
            NumberRange<Double> sr1 = o1.scaleRange;
            NumberRange<Double> sr2 = o2.scaleRange;
            if (sr1.getMinimum() == sr2.getMinimum()) {
                if (sr1.isMinIncluded()) {
                    return sr2.isMinIncluded() ? 0 : -1;
                }
                return sr2.isMinIncluded() ? 1 : 0;
            }
            return sr1.getMinimum() > sr2.getMinimum() ? 1 : -1;
        }
    }

    class SLDSelector {
        NumberRange<Double> scaleRange;
        Filter filter;
        Integer complexity;

        public SLDSelector(NumberRange<?> scaleRange, Filter filter) {
            this.scaleRange = new NumberRange(Double.class, (Number)scaleRange.getMinimum(), scaleRange.isMinIncluded(), (Number)scaleRange.getMaximum(), scaleRange.isMaxIncluded());
            this.filter = filter;
        }

        public List<SLDSelector> difference(SLDSelector other) {
            And difference;
            Filter simplifiedDifference;
            NumberRange[] scaleRangeDifferences;
            ArrayList<SLDSelector> result = new ArrayList<SLDSelector>();
            if (!this.scaleRange.intersects(other.scaleRange)) {
                return Collections.singletonList(this);
            }
            for (NumberRange scaleRangeDifference : scaleRangeDifferences = this.scaleRange.subtract(other.scaleRange)) {
                result.add(new SLDSelector(scaleRangeDifference, this.filter));
            }
            NumberRange scaleRangeIntersection = this.scaleRange.intersect(other.scaleRange);
            if (scaleRangeIntersection != null && !scaleRangeIntersection.isEmpty() && (simplifiedDifference = DomainCoverage.this.simplify((Filter)(difference = FF.and(this.filter, (Filter)FF.not(other.filter))))) != Filter.EXCLUDE) {
                result.add(new SLDSelector(scaleRangeIntersection, simplifiedDifference));
            }
            return result;
        }

        public String toString() {
            return "SLDSelector [scaleRange=" + this.scaleRange + ", filter=" + ECQL.toCQL((Filter)this.filter) + "]";
        }

        public Selector toSelector(SimplifyingFilterVisitor visitor) {
            Selector selector = Selector.and(new ScaleRange((Range<Double>)this.scaleRange), new Data(this.filter), visitor);
            return selector;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.filter == null ? 0 : this.filter.hashCode());
            result = 31 * result + (this.scaleRange == null ? 0 : this.scaleRange.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SLDSelector other = (SLDSelector)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.filter == null ? other.filter != null : !this.filter.equals(other.filter)) {
                return false;
            }
            return !(this.scaleRange == null ? other.scaleRange != null : !this.scaleRange.equals(other.scaleRange));
        }

        private DomainCoverage getOuterType() {
            return DomainCoverage.this;
        }

        public int getComplexity() {
            if (this.complexity == null) {
                FilterComplexityVisitor visitor = new FilterComplexityVisitor();
                this.filter.accept((FilterVisitor)visitor, null);
                this.complexity = visitor.count;
            }
            return this.complexity;
        }
    }
}

