/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.css.selector;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.geotools.styling.css.selector.Selector;
import org.geotools.styling.css.selector.SelectorVisitor;
import org.geotools.styling.css.selector.Specificity;

public class Id
extends Selector {
    public Set<String> ids;

    public static Selector combineAnd(List<Id> selectors, Object ctx) {
        HashSet<String> identifiers = new HashSet<String>(selectors.get((int)0).ids);
        for (Id selector : selectors) {
            identifiers.retainAll(selector.ids);
        }
        if (identifiers.isEmpty()) {
            return REJECT;
        }
        return new Id(identifiers);
    }

    public Id(String ... ids) {
        this.ids = new HashSet<String>(Arrays.asList(ids));
    }

    public Id(Set<String> ids) {
        this.ids = ids;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ids == null ? 0 : this.ids.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Id other = (Id)obj;
        return !(this.ids == null ? other.ids != null : !this.ids.equals(other.ids));
    }

    public String toString() {
        return "Id [" + this.ids + "]";
    }

    @Override
    public Specificity getSpecificity() {
        if (this.ids.size() == 1) {
            return Specificity.ID_1;
        }
        return new Specificity(this.ids.size(), 0, 0);
    }

    @Override
    public Object accept(SelectorVisitor visitor) {
        return visitor.visit(this);
    }
}

