/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.css.util;

import org.geotools.styling.css.CssRule;
import org.geotools.styling.css.selector.AbstractSelectorVisitor;
import org.geotools.styling.css.selector.Or;
import org.geotools.styling.css.selector.Selector;
import org.geotools.styling.css.selector.ZoomRange;
import org.geotools.styling.zoom.ScaleRange;
import org.geotools.styling.zoom.WellKnownZoomContextFinder;
import org.geotools.styling.zoom.ZoomContext;
import org.geotools.util.Range;

public class ScaleRangeExtractor
extends AbstractSelectorVisitor {
    public static final ZoomContext WEB_MERCATOR_ZOOM_CONTEXT = WellKnownZoomContextFinder.getInstance().get("WebMercatorQuad");
    private boolean insideOr;
    private Range<Double> range;
    private ZoomContext zoomContext = WEB_MERCATOR_ZOOM_CONTEXT;

    public static Range<Double> getScaleRange(CssRule cssRule) {
        Selector selector = cssRule.getSelector();
        return ScaleRangeExtractor.getScaleRange(selector, WEB_MERCATOR_ZOOM_CONTEXT);
    }

    public static Range<Double> getScaleRange(CssRule cssRule, ZoomContext zoomContext) {
        Selector selector = cssRule.getSelector();
        return ScaleRangeExtractor.getScaleRange(selector, zoomContext);
    }

    public static Range<Double> getScaleRange(Selector selector) {
        return ScaleRangeExtractor.getScaleRange(selector, WEB_MERCATOR_ZOOM_CONTEXT);
    }

    public static Range<Double> getScaleRange(Selector selector, ZoomContext zoomContext) {
        try {
            ScaleRangeExtractor extractor = new ScaleRangeExtractor(zoomContext);
            selector.accept(extractor);
            return extractor.range;
        }
        catch (IllegalStateException e) {
            throw new IllegalArgumentException("Failed to extract scale range from: " + selector);
        }
    }

    public ScaleRangeExtractor() {
    }

    public ScaleRangeExtractor(ZoomContext zoomContext) {
        this.zoomContext = zoomContext;
    }

    @Override
    public Object visit(Or or) {
        try {
            this.insideOr = true;
            super.visit(or);
        }
        finally {
            this.insideOr = false;
        }
        return null;
    }

    @Override
    public Object visit(org.geotools.styling.css.selector.ScaleRange scaleRange) {
        if (this.insideOr) {
            throw new IllegalStateException("Cannot translate to SLD when a scale range is used inside a OR in the selector");
        }
        if (this.range == null) {
            this.range = scaleRange.range;
        } else {
            this.range.intersect(scaleRange.range);
        }
        return null;
    }

    @Override
    public Object visit(ZoomRange zoomRange) {
        Integer n;
        Integer n2;
        if (this.insideOr) {
            throw new IllegalStateException("Cannot translate to SLD when a scale range is used inside a OR in the selector");
        }
        Integer min = (Integer)zoomRange.range.getMinValue();
        Integer max = (Integer)zoomRange.range.getMaxValue();
        if (min == 0) {
            min = null;
        } else if (!zoomRange.range.isMinIncluded()) {
            n2 = min;
            n = min = Integer.valueOf(min + 1);
        }
        if (max == Integer.MAX_VALUE) {
            max = null;
        } else if (!zoomRange.range.isMaxIncluded()) {
            n2 = max;
            n = max = Integer.valueOf(max - 1);
        }
        ScaleRange scaleRange = this.zoomContext.getRange(min, max);
        Range localRange = new Range(Double.class, (Comparable)Double.valueOf(scaleRange.getMinDenom()), (Comparable)Double.valueOf(scaleRange.getMaxDenom()));
        if (this.range == null) {
            this.range = localRange;
        } else {
            this.range.intersect(localRange);
        }
        return null;
    }
}

