/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.css.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.locationtech.jts.geom.Geometry;

class TypeAggregator {
    Map<String, Class> types = new LinkedHashMap<String, Class>();
    static final List<Class<?>> INTEGRAL_NUMBER_TYPES = Arrays.asList(Byte.class, Short.class, Integer.class, Long.class, BigInteger.class);
    static final List<Class<?>> FLOAT_NUMBER_TYPES = Arrays.asList(Float.class, Double.class, BigDecimal.class);

    TypeAggregator() {
    }

    public void addType(String name, Class<?> binding) {
        Class existingBinding = this.types.get(name);
        if (existingBinding == null) {
            this.types.put(name, binding);
        } else if (!existingBinding.isAssignableFrom(binding)) {
            if (binding.isAssignableFrom(existingBinding)) {
                this.types.put(name, binding);
            } else if (Number.class.isAssignableFrom(binding) && Number.class.isAssignableFrom(existingBinding)) {
                if (INTEGRAL_NUMBER_TYPES.contains(existingBinding)) {
                    if (INTEGRAL_NUMBER_TYPES.contains(binding)) {
                        if (INTEGRAL_NUMBER_TYPES.indexOf(binding) > INTEGRAL_NUMBER_TYPES.indexOf(existingBinding)) {
                            this.types.put(name, binding);
                        }
                    } else if (FLOAT_NUMBER_TYPES.contains(binding)) {
                        this.types.put(name, binding);
                    } else {
                        this.types.put(name, Number.class);
                    }
                } else if (FLOAT_NUMBER_TYPES.contains(existingBinding) && FLOAT_NUMBER_TYPES.contains(binding)) {
                    if (FLOAT_NUMBER_TYPES.indexOf(binding) > FLOAT_NUMBER_TYPES.indexOf(existingBinding)) {
                        this.types.put(name, binding);
                    } else if (!INTEGRAL_NUMBER_TYPES.contains(binding)) {
                        this.types.put(name, Number.class);
                    }
                }
            } else {
                this.types.put(name, Object.class);
            }
        }
    }

    public SimpleFeatureType getFeatureType() {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        for (Map.Entry<String, Class> entry : this.types.entrySet()) {
            String name = entry.getKey();
            Class type = entry.getValue();
            if (Geometry.class.isAssignableFrom(type)) {
                builder.add(name, type, (CoordinateReferenceSystem)DefaultEngineeringCRS.GENERIC_2D);
                continue;
            }
            builder.add(name, type);
        }
        builder.setName("GuessedFeatureType");
        return builder.buildFeatureType();
    }
}

