/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.csv.parse;

import com.opencsv.CSVWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import org.geotools.data.csv.CSVFileState;
import org.geotools.data.csv.parse.CSVStrategy;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;

public class CSVAttributesOnlyStrategy
extends CSVStrategy {
    public CSVAttributesOnlyStrategy(CSVFileState csvFileState) {
        super(csvFileState);
    }

    @Override
    protected SimpleFeatureType buildFeatureType() {
        SimpleFeatureTypeBuilder builder = CSVAttributesOnlyStrategy.createBuilder(this.csvFileState);
        return builder.buildFeatureType();
    }

    @Override
    public void createSchema(SimpleFeatureType featureType) throws IOException {
        ArrayList<String> header = new ArrayList<String>();
        this.featureType = featureType;
        for (AttributeDescriptor descriptor : featureType.getAttributeDescriptors()) {
            if (descriptor instanceof GeometryDescriptor) continue;
            header.add(descriptor.getLocalName());
        }
        try (CSVWriter writer = new CSVWriter((Writer)new FileWriter(this.csvFileState.getFile()), this.getSeparator(), this.getQuotechar(), this.getEscapechar(), this.getLineSeparator());){
            writer.writeNext(header.toArray(new String[header.size()]), this.isQuoteAllFields());
        }
    }

    @Override
    public String[] encode(SimpleFeature feature) {
        ArrayList<String> csvRecord = new ArrayList<String>();
        for (Property property : feature.getProperties()) {
            Object value = property.getValue();
            if (value == null) {
                csvRecord.add("");
                continue;
            }
            if (Geometry.class.isAssignableFrom(value.getClass())) continue;
            String txt = value.toString();
            csvRecord.add(txt);
        }
        return csvRecord.toArray(new String[csvRecord.size() - 1]);
    }

    @Override
    public SimpleFeature decode(String recordId, String[] csvRecord) {
        SimpleFeatureType featureType = this.getFeatureType();
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(featureType);
        String[] headers = this.csvFileState.getCSVHeaders();
        for (int i = 0; i < headers.length; ++i) {
            String header = headers[i];
            if (i < csvRecord.length) {
                String value = csvRecord[i].trim();
                builder.set(header, (Object)value);
                continue;
            }
            LOGGER.warning("record had fewer values than header");
            if (csvRecord.length == 1 && csvRecord[0].isEmpty()) {
                return null;
            }
            builder.set(header, null);
        }
        return builder.buildFeature(this.csvFileState.getTypeName() + "-" + recordId);
    }
}

