/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.csv;

import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFactorySpi;
import org.geotools.data.csv.CSVDataStore;
import org.geotools.data.csv.CSVFileState;
import org.geotools.data.csv.parse.CSVAttributesOnlyStrategy;
import org.geotools.data.csv.parse.CSVLatLonStrategy;
import org.geotools.data.csv.parse.CSVSpecifiedWKTStrategy;
import org.geotools.data.csv.parse.CSVStrategy;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.type.FeatureTypeFactoryImpl;
import org.geotools.util.KVP;
import org.geotools.util.URLs;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.feature.type.FeatureTypeFactory;

public class CSVDataStoreFactory
implements FileDataStoreFactorySpi {
    Logger logger = Logging.getLogger((String)"org.geotools.data.csv");
    public static final String GUESS_STRATEGY = "guess";
    public static final String ATTRIBUTES_ONLY_STRATEGY = "AttributesOnly";
    public static final String SPECIFC_STRATEGY = "specify";
    public static final String WKT_STRATEGY = "wkt";
    private static final String FILE_TYPE = "csv";
    public static final String[] EXTENSIONS = new String[]{".csv"};
    public static final DataAccessFactory.Param FILE_PARAM = new DataAccessFactory.Param("file", File.class, "csv file", false);
    public static final DataAccessFactory.Param URL_PARAM = new DataAccessFactory.Param("url", URL.class, "csv file", false);
    public static final DataAccessFactory.Param NAMESPACEP = new DataAccessFactory.Param("namespace", URI.class, "uri to the namespace", false, null, (Map)new KVP(new Object[]{"level", "advanced"}));
    public static final DataAccessFactory.Param STRATEGYP = new DataAccessFactory.Param("strategy", String.class, "strategy", false);
    public static final DataAccessFactory.Param LATFIELDP = new DataAccessFactory.Param("latField", String.class, "Latitude field. Assumes a CSVSpecifiedLatLngStrategy", false);
    public static final DataAccessFactory.Param LnGFIELDP = new DataAccessFactory.Param("lngField", String.class, "Longitude field. Assumes a CSVSpecifiedLatLngStrategy", false);
    public static final DataAccessFactory.Param WKTP = new DataAccessFactory.Param("wktField", String.class, "WKT field. Assumes a CSVSpecifiedWKTStrategy", false);
    public static final DataAccessFactory.Param QUOTEALL = new DataAccessFactory.Param("quoteAll", Boolean.class, "Should all fields be quoted (true) or just ones that need it (false)", false, (Object)Boolean.FALSE, (Map)new KVP(new Object[]{"level", "advanced"}));
    public static final DataAccessFactory.Param QUOTECHAR = new DataAccessFactory.Param("quoteChar", Character.class, "Character to be used to quote attributes", false, (Object)Character.valueOf('\"'), (Map)new KVP(new Object[]{"level", "advanced"}));
    public static final DataAccessFactory.Param SEPERATORCHAR = new DataAccessFactory.Param("seperator", Character.class, "Character to be used to seperate fields", false, (Object)Character.valueOf(','), (Map)new KVP(new Object[]{"level", "advanced"}));
    public static final DataAccessFactory.Param LINESEPSTRING = new DataAccessFactory.Param("lineSeperator", String.class, "String to be used to seperate records", false, (Object)System.lineSeparator(), (Map)new KVP(new Object[]{"level", "advanced"}));
    public static final DataAccessFactory.Param ESCAPECHAR = new DataAccessFactory.Param("escapeChar", Character.class, "Character used to escape quotes", false, (Object)Character.valueOf('\\'), (Map)new KVP(new Object[]{"level", "advanced"}));
    public static final DataAccessFactory.Param WRITEPRJ = new DataAccessFactory.Param("writeprj", Boolean.class, "Should the CSVDatastore create a .prj file", false, (Object)false, (Map)new KVP(new Object[]{"level", "advanced"}));
    public static final DataAccessFactory.Param[] parametersInfo = new DataAccessFactory.Param[]{FILE_PARAM, NAMESPACEP, STRATEGYP, LATFIELDP, LnGFIELDP, WKTP, WRITEPRJ, QUOTEALL, QUOTECHAR, SEPERATORCHAR, LINESEPSTRING};

    public String getDisplayName() {
        return FILE_TYPE.toUpperCase();
    }

    public String getDescription() {
        return "Comma delimited text file";
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        return parametersInfo;
    }

    private boolean canProcessExtension(String filename) {
        String extension = FilenameUtils.getExtension((String)filename);
        return FILE_TYPE.equalsIgnoreCase(extension);
    }

    private File fileFromParams(Map<String, Serializable> params) throws IOException {
        File file = (File)FILE_PARAM.lookUp(params);
        if (file != null) {
            return file;
        }
        URL url = (URL)URL_PARAM.lookUp(params);
        if (url != null) {
            return URLs.urlToFile((URL)url);
        }
        return null;
    }

    public boolean canProcess(Map<String, Serializable> params) {
        try {
            File file = this.fileFromParams(params);
            if (file != null) {
                return this.canProcessExtension(file.getPath());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public boolean isAvailable() {
        try {
            CSVDataStore.class.getName();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return Collections.emptyMap();
    }

    public FileDataStore createDataStoreFromFile(File file) throws IOException {
        return this.createDataStoreFromFile(file, null);
    }

    public FileDataStore createDataStoreFromFile(File file, URI namespace) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Cannot create store from null file");
        }
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                this.logger.log(Level.FINE, "problem creating file", e);
                this.logger.info("unable to create CSV file " + file + "\n" + e.getLocalizedMessage());
                throw e;
            }
        }
        Map<String, Serializable> noParams = Collections.emptyMap();
        return this.createDataStoreFromFile(file, namespace, noParams);
    }

    public FileDataStore createDataStore(Map<String, Serializable> params) throws IOException {
        File file = this.fileFromParams(params);
        if (file == null) {
            throw new IllegalArgumentException("Could not find file from params to create csv data store");
        }
        URI namespace = (URI)NAMESPACEP.lookUp(params);
        return this.createDataStoreFromFile(file, namespace, params);
    }

    private FileDataStore createDataStoreFromFile(File file, URI namespace, Map<String, Serializable> params) throws IOException {
        String lineSep;
        Character escapeChar;
        Character sepChar;
        Character quoteChar;
        Boolean quotes;
        CSVFileState csvFileState = new CSVFileState(file, namespace);
        Object strategyParam = STRATEGYP.lookUp(params);
        CSVStrategy csvStrategy = null;
        if (strategyParam != null) {
            String strategyString = strategyParam.toString();
            if (strategyString.equalsIgnoreCase(GUESS_STRATEGY)) {
                csvStrategy = new CSVLatLonStrategy(csvFileState);
            } else if (strategyString.equalsIgnoreCase(ATTRIBUTES_ONLY_STRATEGY)) {
                csvStrategy = new CSVAttributesOnlyStrategy(csvFileState);
            } else if (strategyString.equalsIgnoreCase(SPECIFC_STRATEGY)) {
                Object latParam = LATFIELDP.lookUp(params);
                Object lngParam = LnGFIELDP.lookUp(params);
                if (latParam == null || lngParam == null) {
                    throw new IllegalArgumentException("'specify' csv strategy selected, but lat/lng params both not specified");
                }
                csvStrategy = new CSVLatLonStrategy(csvFileState, latParam.toString(), lngParam.toString());
            } else if (strategyString.equalsIgnoreCase(WKT_STRATEGY)) {
                Object wktParam = WKTP.lookUp(params);
                if (wktParam == null) {
                    throw new IllegalArgumentException("'wkt' csv strategy selected, but wktField param not specified");
                }
                csvStrategy = new CSVSpecifiedWKTStrategy(csvFileState, wktParam.toString());
            } else {
                csvStrategy = new CSVAttributesOnlyStrategy(csvFileState);
            }
        } else {
            csvStrategy = new CSVAttributesOnlyStrategy(csvFileState);
        }
        Boolean writeprj = (Boolean)WRITEPRJ.lookUp(params);
        if (writeprj != null) {
            csvStrategy.setWritePrj(writeprj);
        }
        if ((quotes = (Boolean)QUOTEALL.lookUp(params)) != null && quotes.booleanValue()) {
            csvStrategy.setQuoteAllFields(quotes);
        }
        if ((quoteChar = (Character)QUOTECHAR.lookUp(params)) != null) {
            csvStrategy.setQuotechar(quoteChar.charValue());
        }
        if ((sepChar = (Character)SEPERATORCHAR.lookUp(params)) != null) {
            csvStrategy.setSeparator(sepChar.charValue());
        }
        if ((escapeChar = (Character)ESCAPECHAR.lookUp(params)) != null) {
            csvStrategy.setEscapechar(escapeChar.charValue());
        }
        if ((lineSep = (String)LINESEPSTRING.lookUp(params)) != null) {
            csvStrategy.setLineSeparator(lineSep);
        }
        CSVDataStore store = new CSVDataStore(csvFileState, csvStrategy);
        if (namespace != null) {
            store.setNamespaceURI(namespace.toString());
        }
        store.setDataStoreFactory((DataStoreFactorySpi)this);
        store.setGeometryFactory(new GeometryFactory());
        store.setFeatureTypeFactory((FeatureTypeFactory)new FeatureTypeFactoryImpl());
        store.setFeatureFactory(CommonFactoryFinder.getFeatureFactory(null));
        return store;
    }

    public DataStore createNewDataStore(Map<String, Serializable> params) throws IOException {
        return this.createDataStore(params);
    }

    public FileDataStore createDataStore(URL url) throws IOException {
        File file = URLs.urlToFile((URL)url);
        return this.createDataStoreFromFile(file);
    }

    public String[] getFileExtensions() {
        return EXTENSIONS;
    }

    public boolean canProcess(URL url) {
        return this.canProcessExtension(URLs.urlToFile((URL)url).toString());
    }

    public String getTypeName(URL url) throws IOException {
        FileDataStore ds = this.createDataStore(url);
        String[] names = ds.getTypeNames();
        assert (names.length == 1) : "Invalid number of type names for csv file store";
        ds.dispose();
        return names[0];
    }
}

