/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.csv;

import com.opencsv.CSVWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.NoSuchElementException;
import org.apache.commons.io.FilenameUtils;
import org.geotools.api.data.FeatureWriter;
import org.geotools.api.data.Query;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.data.DataUtilities;
import org.geotools.data.csv.CSVFileState;
import org.geotools.data.csv.parse.CSVIterator;
import org.geotools.data.csv.parse.CSVStrategy;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.wkt.Formattable;

public class CSVFeatureWriter
implements FeatureWriter<SimpleFeatureType, SimpleFeature> {
    private SimpleFeatureType featureType;
    private CSVStrategy csvStrategy;
    private CSVFileState csvFileState;
    private File temp;
    private CSVIterator iterator;
    private CSVWriter csvWriter;
    private boolean appending = false;
    int nextRow = 0;
    private SimpleFeature currentFeature;

    public CSVFeatureWriter(CSVFileState csvFileState, CSVStrategy csvStrategy) throws IOException {
        this(csvFileState, csvStrategy, Query.ALL);
    }

    public CSVFeatureWriter(CSVFileState csvFileState, CSVStrategy csvStrategy, Query query) throws IOException {
        this.csvFileState = csvFileState;
        File file = csvFileState.getFile();
        File directory = file.getParentFile();
        String typeName = query.getTypeName();
        this.temp = File.createTempFile(typeName + System.currentTimeMillis(), ".csv", directory);
        this.temp.deleteOnExit();
        this.featureType = csvStrategy.getFeatureType();
        this.iterator = csvStrategy.iterator();
        this.csvStrategy = csvStrategy;
        this.csvWriter = new CSVWriter((Writer)new FileWriter(this.temp), csvStrategy.getSeparator(), csvStrategy.getQuotechar(), csvStrategy.getEscapechar(), csvStrategy.getLineSeparator());
        this.csvWriter.writeNext(this.csvFileState.getCSVHeaders(), csvStrategy.isQuoteAllFields());
    }

    public SimpleFeatureType getFeatureType() {
        return this.featureType;
    }

    public boolean hasNext() throws IOException {
        if (this.csvWriter == null) {
            return false;
        }
        if (this.appending) {
            return false;
        }
        return this.iterator.hasNext();
    }

    public SimpleFeature next() throws IOException, IllegalArgumentException, NoSuchElementException {
        if (this.csvWriter == null) {
            throw new IOException("Writer has been closed");
        }
        if (this.currentFeature != null) {
            this.write();
        }
        try {
            if (!this.appending) {
                if (this.iterator.hasNext()) {
                    this.currentFeature = this.iterator.next();
                    return this.currentFeature;
                }
                this.appending = true;
            }
            String fid = this.featureType.getTypeName() + "-fid" + this.nextRow;
            Object[] values = DataUtilities.defaultValues((SimpleFeatureType)this.featureType);
            this.currentFeature = SimpleFeatureBuilder.build((SimpleFeatureType)this.featureType, (Object[])values, (String)fid);
            return this.currentFeature;
        }
        catch (IllegalArgumentException invalid) {
            throw new IOException("Unable to create feature:" + invalid.getMessage(), invalid);
        }
    }

    public void remove() throws IOException {
        this.currentFeature = null;
    }

    public void write() throws IOException {
        if (this.currentFeature == null) {
            return;
        }
        this.csvWriter.writeNext(this.csvStrategy.encode(this.currentFeature), this.csvStrategy.isQuoteAllFields());
        ++this.nextRow;
        this.currentFeature = null;
    }

    public void close() throws IOException {
        if (this.csvWriter == null) {
            throw new IOException("Writer already closed");
        }
        if (this.currentFeature != null) {
            this.write();
        }
        while (this.hasNext()) {
            this.next();
            this.write();
        }
        this.csvWriter.close();
        this.csvWriter = null;
        if (this.iterator != null) {
            this.iterator.close();
            this.iterator = null;
        }
        File file = this.csvFileState.getFile();
        Files.copy(this.temp.toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        if (this.csvStrategy.isWritePrj()) {
            File prjFile = new File(file.getParent(), FilenameUtils.getBaseName((String)file.getName()) + ".prj");
            if (prjFile.exists()) {
                prjFile.delete();
            }
            try (FileWriter writer = new FileWriter(prjFile);){
                writer.write(((Formattable)this.csvFileState.getCrs()).toWKT(Citations.EPSG, 2));
            }
        }
        this.temp.delete();
    }
}

