/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.elasticsearch;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.FeatureReader;
import org.geotools.data.FilteringFeatureReader;
import org.geotools.data.Query;
import org.geotools.data.elasticsearch.ElasticAttribute;
import org.geotools.data.elasticsearch.ElasticConstants;
import org.geotools.data.elasticsearch.ElasticDataStore;
import org.geotools.data.elasticsearch.ElasticDataStoreFactory;
import org.geotools.data.elasticsearch.ElasticFeatureReader;
import org.geotools.data.elasticsearch.ElasticFeatureReaderScroll;
import org.geotools.data.elasticsearch.ElasticFeatureTypeBuilder;
import org.geotools.data.elasticsearch.ElasticLayerConfiguration;
import org.geotools.data.elasticsearch.ElasticRequest;
import org.geotools.data.elasticsearch.ElasticResponse;
import org.geotools.data.elasticsearch.FilterToElastic;
import org.geotools.data.elasticsearch.GeohashUtil;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.filter.visitor.ExtractBoundsFilterVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.process.elasticsearch.ElasticBucketVisitor;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ElasticFeatureSource
extends ContentFeatureSource {
    private static final Logger LOGGER = Logging.getLogger(ElasticFeatureSource.class);
    private Boolean filterFullySupported;

    public ElasticFeatureSource(ContentEntry entry, Query query) throws IOException {
        super(entry, query);
        ElasticDataStore dataStore = this.getDataStore();
        if (dataStore.getLayerConfigurations().get(entry.getName().getLocalPart()) == null) {
            List<ElasticAttribute> attributes = dataStore.getElasticAttributes(entry.getName());
            ElasticLayerConfiguration config = new ElasticLayerConfiguration(entry.getName().getLocalPart());
            config.getAttributes().addAll(attributes);
            dataStore.setLayerConfiguration(config);
        }
    }

    public ElasticDataStore getDataStore() {
        return (ElasticDataStore)super.getDataStore();
    }

    protected ReferencedEnvelope getBoundsInternal(Query query) throws IOException {
        LOGGER.fine("getBoundsInternal");
        CoordinateReferenceSystem crs = this.getSchema().getCoordinateReferenceSystem();
        ReferencedEnvelope bounds = new ReferencedEnvelope(crs);
        try (FeatureReader<SimpleFeatureType, SimpleFeature> featureReader = this.getReaderInternal(query);){
            while (featureReader.hasNext()) {
                SimpleFeature feature = (SimpleFeature)featureReader.next();
                bounds.include(feature.getBounds());
            }
        }
        return bounds;
    }

    protected int getCountInternal(Query query) throws IOException {
        int hits;
        block10: {
            LOGGER.fine("getCountInternal");
            hits = 0;
            ElasticRequest searchRequest = this.prepareSearchRequest(query, false);
            try {
                if (!this.filterFullySupported.booleanValue()) {
                    try (FeatureReader<SimpleFeatureType, SimpleFeature> reader = this.getReaderInternal(query);){
                        while (reader.hasNext()) {
                            reader.next();
                            ++hits;
                        }
                        break block10;
                    }
                }
                searchRequest.setSize(0);
                ElasticDataStore dataStore = this.getDataStore();
                String docType = dataStore.getDocType(this.entry.getName());
                ElasticResponse sr = dataStore.getClient().search(dataStore.getIndexName(), docType, searchRequest);
                int totalHits = (int)sr.getTotalNumHits();
                int size = this.getSize(query);
                int from = this.getStartIndex(query);
                hits = Math.max(0, Math.min(totalHits - from, size));
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
                throw new IOException("Error executing count search", e);
            }
        }
        return hits;
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query query) throws IOException {
        Object reader;
        LOGGER.fine("getReaderInternal");
        try {
            ElasticDataStore dataStore = this.getDataStore();
            String docType = dataStore.getDocType(this.entry.getName());
            boolean scroll = !this.useSortOrPagination(query) && dataStore.getScrollEnabled() != false && !this.isAggregation(query);
            ElasticRequest searchRequest = this.prepareSearchRequest(query, scroll);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Search request: " + String.valueOf(searchRequest));
            }
            ElasticResponse sr = dataStore.getClient().search(dataStore.getIndexName(), docType, searchRequest);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Search response: " + String.valueOf(sr));
            }
            reader = !scroll ? new ElasticFeatureReader(this.getState(), sr) : new ElasticFeatureReaderScroll(this.getState(), sr, this.getSize(query));
            if (!this.filterFullySupported.booleanValue()) {
                reader = new FilteringFeatureReader((FeatureReader)reader, query.getFilter());
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw new IOException("Error executing query search", e);
        }
        return reader;
    }

    private boolean isAggregation(Query query) {
        return query.getHints().get((Object)ElasticBucketVisitor.ES_AGGREGATE_BUCKET) != null;
    }

    /*
     * Exception decompiling
     */
    protected boolean handleVisitor(Query query, FeatureVisitor visitor) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ElasticRequest prepareSearchRequest(Query query, boolean scroll) throws IOException {
        String naturalSortOrder = SortOrder.ASCENDING.toSQL().toLowerCase();
        ElasticRequest searchRequest = new ElasticRequest();
        ElasticDataStore dataStore = this.getDataStore();
        String docType = dataStore.getDocType(this.entry.getName());
        LOGGER.fine("Preparing " + docType + " (" + String.valueOf(this.entry.getName()) + ") query");
        if (!scroll) {
            if (query.getSortBy() != null) {
                for (SortBy sort : query.getSortBy()) {
                    String sortOrder = sort.getSortOrder().toSQL().toLowerCase();
                    if (sort.getPropertyName() != null) {
                        String name = sort.getPropertyName().getPropertyName();
                        searchRequest.addSort(name, sortOrder);
                        continue;
                    }
                    naturalSortOrder = sortOrder;
                }
            }
            searchRequest.setSize(this.getSize(query));
            searchRequest.setFrom(this.getStartIndex(query));
        } else {
            if (dataStore.getScrollSize() != null) {
                searchRequest.setSize(dataStore.getScrollSize().intValue());
            }
            if (dataStore.getScrollTime() != null) {
                searchRequest.setScroll(dataStore.getScrollTime());
            }
        }
        if (dataStore.isSourceFilteringEnabled()) {
            if (query.getProperties() != Query.ALL_PROPERTIES) {
                SimpleFeatureType schema = this.getSchema();
                for (String property : query.getPropertyNames()) {
                    AttributeDescriptor descriptor = schema.getDescriptor(property);
                    if (descriptor == null) continue;
                    String sourceName = (String)descriptor.getUserData().get("full_name");
                    searchRequest.addSourceInclude(sourceName);
                }
            } else {
                this.setSourceIncludes(searchRequest);
            }
        }
        FilterToElastic filterToElastic = new FilterToElastic();
        filterToElastic.setFeatureType(this.buildFeatureType());
        filterToElastic.encode(query);
        this.filterFullySupported = filterToElastic.getFullySupported();
        if (!this.filterFullySupported.booleanValue()) {
            LOGGER.fine("Filter is not fully supported by native Elasticsearch. Additional post-query filtering will be performed.");
        }
        Map<String, Object> queryBuilder = filterToElastic.getQueryBuilder();
        Map<String, Object> nativeQueryBuilder = filterToElastic.getNativeQueryBuilder();
        searchRequest.setQuery(queryBuilder);
        if (this.isSort(query) && nativeQueryBuilder.equals(ElasticConstants.MATCH_ALL)) {
            String sortKey = dataStore.getClient().getVersion() < 7.0 ? "_uid" : "_id";
            searchRequest.addSort(sortKey, naturalSortOrder);
        }
        if (filterToElastic.getAggregations() != null) {
            Map<String, Map<String, Map<String, Object>>> aggregations = filterToElastic.getAggregations();
            Envelope envelope = this.getQueryEnvelope(query);
            long gridSize = dataStore.getGridSize() != null ? dataStore.getGridSize().longValue() : ((Long)ElasticDataStoreFactory.GRID_SIZE.getDefaultValue()).longValue();
            double gridThreshold = dataStore.getGridThreshold() != null ? dataStore.getGridThreshold().doubleValue() : ((Double)ElasticDataStoreFactory.GRID_THRESHOLD.getDefaultValue()).doubleValue();
            int precision = GeohashUtil.computePrecision(envelope, gridSize, gridThreshold);
            GeohashUtil.updateGridAggregationPrecision(aggregations, precision);
            searchRequest.setAggregations(aggregations);
            searchRequest.setSize(0);
        }
        return searchRequest;
    }

    private Envelope getQueryEnvelope(Query query) {
        Envelope envelope = (Envelope)query.getFilter().accept((FilterVisitor)ExtractBoundsFilterVisitor.BOUNDS_VISITOR, null);
        if (Double.isInfinite(envelope.getWidth())) {
            envelope = new ReferencedEnvelope(-180.0, 180.0, -90.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        }
        return envelope;
    }

    private void setSourceIncludes(ElasticRequest searchRequest) throws IOException {
        ElasticDataStore dataStore = this.getDataStore();
        List<ElasticAttribute> attributes = dataStore.getElasticAttributes(this.entry.getName());
        for (ElasticAttribute attribute : attributes) {
            if (attribute.isUse().booleanValue() && attribute.isStored()) {
                searchRequest.addField(attribute.getName());
                continue;
            }
            if (!attribute.isUse().booleanValue()) continue;
            searchRequest.addSourceInclude(attribute.getName());
        }
    }

    private boolean isSort(Query query) {
        return query.getSortBy() != null && query.getSortBy().length > 0;
    }

    private boolean useSortOrPagination(Query query) {
        return query.getSortBy() != null && query.getSortBy().length > 0 || query.getStartIndex() != null;
    }

    private int getSize(Query query) {
        int size;
        if (!query.isMaxFeaturesUnlimited()) {
            size = query.getMaxFeatures();
        } else {
            size = this.getDataStore().getDefaultMaxFeatures();
            LOGGER.fine("Unlimited maxFeatures not supported. Using default: " + size);
        }
        return size;
    }

    private int getStartIndex(Query query) {
        int from = query.getStartIndex() != null ? query.getStartIndex() : 0;
        return from;
    }

    protected SimpleFeatureType buildFeatureType() {
        ElasticDataStore ds = this.getDataStore();
        ElasticLayerConfiguration layerConfig = ds.getLayerConfigurations().get(this.entry.getTypeName());
        List<ElasticAttribute> attributes = layerConfig != null ? layerConfig.getAttributes() : null;
        ElasticFeatureTypeBuilder typeBuilder = new ElasticFeatureTypeBuilder(attributes, this.entry.getName());
        return typeBuilder.buildFeatureType();
    }

    protected boolean canLimit() {
        return true;
    }

    protected boolean canOffset() {
        return true;
    }

    protected boolean canFilter() {
        return true;
    }

    protected boolean canSort() {
        return true;
    }
}

