/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.elasticsearch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.http.HttpHost;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.common.joda.Joda;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.elasticsearch.ElasticAttribute;
import org.geotools.data.elasticsearch.ElasticClient;
import org.geotools.data.elasticsearch.ElasticFeatureSource;
import org.geotools.data.elasticsearch.ElasticLayerConfiguration;
import org.geotools.data.elasticsearch.ElasticParserUtil;
import org.geotools.data.elasticsearch.RestElasticClient;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.NameImpl;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.type.Name;

public class ElasticDataStore
extends ContentDataStore {
    private static final Logger LOGGER = Logging.getLogger(ElasticDataStore.class);
    private ElasticClient client;
    private final String indexName;
    private final List<Name> baseTypeNames;
    private final Map<Name, String> docTypes;
    private Map<String, ElasticLayerConfiguration> layerConfigurations;
    private boolean sourceFilteringEnabled;
    private Integer defaultMaxFeatures;
    private Long scrollSize;
    private boolean scrollEnabled;
    private Integer scrollTime;
    private ArrayEncoding arrayEncoding;
    private Long gridSize;
    private Double gridThreshold;

    public ElasticDataStore(String searchHost, Integer hostPort, String indexName) throws IOException {
        this(RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(searchHost, hostPort.intValue(), "http")}).build(), indexName);
    }

    public ElasticDataStore(RestClient restClient, String indexName) throws IOException {
        this(restClient, null, indexName, false);
    }

    public ElasticDataStore(RestClient restClient, RestClient proxyRestClient, String indexName, boolean enableRunAs) throws IOException {
        LOGGER.fine("Initializing data store for " + indexName);
        this.indexName = indexName;
        try {
            ElasticDataStore.checkRestClient(restClient);
            if (proxyRestClient != null) {
                ElasticDataStore.checkRestClient(proxyRestClient);
            }
            this.client = new RestElasticClient(restClient, proxyRestClient, enableRunAs);
        }
        catch (Exception e) {
            throw new IOException("Unable to create REST client", e);
        }
        LOGGER.fine("Created REST client: " + this.client);
        List<String> types = this.getClient().getTypes(indexName);
        this.baseTypeNames = !types.isEmpty() ? types.stream().map(NameImpl::new).collect(Collectors.toList()) : new ArrayList<Name>();
        this.layerConfigurations = new ConcurrentHashMap<String, ElasticLayerConfiguration>();
        this.docTypes = new HashMap<Name, String>();
        this.arrayEncoding = ArrayEncoding.JSON;
    }

    protected List<Name> createTypeNames() {
        ArrayList<Name> names = new ArrayList<Name>();
        names.addAll(this.baseTypeNames);
        names.addAll(this.docTypes.keySet());
        return names;
    }

    protected ContentFeatureSource createFeatureSource(ContentEntry entry) throws IOException {
        return new ElasticFeatureSource(entry, Query.ALL);
    }

    public ContentFeatureSource getFeatureSource(Name name, Transaction tx) throws IOException {
        ElasticLayerConfiguration layerConfig = this.layerConfigurations.get(name.getLocalPart());
        if (layerConfig != null) {
            this.docTypes.put(name, layerConfig.getDocType());
        }
        ContentFeatureSource featureSource = super.getFeatureSource(name, tx);
        featureSource.getEntry().getState(Transaction.AUTO_COMMIT).flush();
        return featureSource;
    }

    public void dispose() {
        try {
            this.client.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getCause());
        }
        super.dispose();
    }

    public List<ElasticAttribute> getElasticAttributes(Name layerName) throws IOException {
        List<ElasticAttribute> elasticAttributes;
        String localPart = layerName.getLocalPart();
        ElasticLayerConfiguration layerConfig = this.layerConfigurations.get(localPart);
        if (layerConfig == null || layerConfig.getAttributes().isEmpty()) {
            String docType = this.docTypes.getOrDefault(layerName, localPart);
            Map<String, Object> mapping = this.getClient().getMapping(this.indexName, docType);
            elasticAttributes = new ArrayList<ElasticAttribute>();
            if (mapping != null) {
                this.add(elasticAttributes, "_id", "string", mapping, false);
                this.add(elasticAttributes, "_index", "string", mapping, false);
                this.add(elasticAttributes, "_type", "string", mapping, false);
                this.add(elasticAttributes, "_score", "float", mapping, false);
                this.add(elasticAttributes, "_relative_score", "float", mapping, false);
                this.add(elasticAttributes, "_aggregation", "binary", mapping, false);
                this.walk(elasticAttributes, mapping, "", false, false);
            }
        } else {
            elasticAttributes = layerConfig.getAttributes();
        }
        return elasticAttributes;
    }

    String getIndexName() {
        return this.indexName;
    }

    ElasticClient getClient() {
        return this.client;
    }

    boolean isSourceFilteringEnabled() {
        return this.sourceFilteringEnabled;
    }

    public void setSourceFilteringEnabled(boolean sourceFilteringEnabled) {
        this.sourceFilteringEnabled = sourceFilteringEnabled;
    }

    public Integer getDefaultMaxFeatures() {
        return this.defaultMaxFeatures;
    }

    public void setDefaultMaxFeatures(Integer defaultMaxFeatures) {
        this.defaultMaxFeatures = defaultMaxFeatures;
    }

    public Long getScrollSize() {
        return this.scrollSize;
    }

    public Boolean getScrollEnabled() {
        return this.scrollEnabled;
    }

    public Integer getScrollTime() {
        return this.scrollTime;
    }

    public void setScrollSize(Long scrollSize) {
        this.scrollSize = scrollSize;
    }

    public void setScrollEnabled(Boolean scrollEnabled) {
        this.scrollEnabled = scrollEnabled;
    }

    public void setScrollTime(Integer scrollTime) {
        this.scrollTime = scrollTime;
    }

    public ArrayEncoding getArrayEncoding() {
        return this.arrayEncoding;
    }

    public void setArrayEncoding(ArrayEncoding arrayEncoding) {
        this.arrayEncoding = arrayEncoding;
    }

    public Long getGridSize() {
        return this.gridSize;
    }

    public void setGridSize(Long gridSize) {
        this.gridSize = gridSize;
    }

    public Double getGridThreshold() {
        return this.gridThreshold;
    }

    public void setGridThreshold(Double gridThreshold) {
        this.gridThreshold = gridThreshold;
    }

    public Map<String, ElasticLayerConfiguration> getLayerConfigurations() {
        return this.layerConfigurations;
    }

    public void setLayerConfiguration(ElasticLayerConfiguration layerConfig) {
        String layerName = layerConfig.getLayerName();
        this.layerConfigurations.put(layerName, layerConfig);
    }

    public Map<Name, String> getDocTypes() {
        return this.docTypes;
    }

    public String getDocType(Name typeName) {
        String docType = this.docTypes.containsKey(typeName) ? this.docTypes.get(typeName) : typeName.getLocalPart();
        return docType;
    }

    private void walk(List<ElasticAttribute> elasticAttributes, Map<String, Object> map, String propertyKey, boolean startType, boolean nested) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (!key.equals("_timestamp") && Map.class.isAssignableFrom(value.getClass())) {
                String newPropertyKey = !startType && key.equals("properties") ? propertyKey : (propertyKey.isEmpty() ? entry.getKey() : propertyKey + "." + key);
                boolean bl = startType = !startType && key.equals("properties");
                if (!nested && map.containsKey("type")) {
                    nested = map.get("type").equals("nested");
                }
                if (ElasticParserUtil.isGeoPointFeature((Map)value)) {
                    this.add(elasticAttributes, propertyKey + ".coordinates", "geo_point", (Map)value, nested);
                    continue;
                }
                this.walk(elasticAttributes, (Map)value, newPropertyKey, startType, nested);
                continue;
            }
            if (key.equals("type") && !value.equals("nested")) {
                this.add(elasticAttributes, propertyKey, (String)value, map, nested);
                continue;
            }
            if (!key.equals("_timestamp")) continue;
            this.add(elasticAttributes, "_timestamp", "date", map, nested);
        }
    }

    private void add(List<ElasticAttribute> elasticAttributes, String propertyKey, String propertyType, Map<String, Object> map, boolean nested) {
        if (propertyKey != null) {
            Class binding;
            ElasticAttribute elasticAttribute = new ElasticAttribute(propertyKey);
            switch (propertyType) {
                case "geo_point": {
                    binding = Point.class;
                    elasticAttribute.setSrid(4326);
                    elasticAttribute.setGeometryType(ElasticAttribute.ElasticGeometryType.GEO_POINT);
                    break;
                }
                case "geo_shape": {
                    binding = Geometry.class;
                    elasticAttribute.setSrid(4326);
                    elasticAttribute.setGeometryType(ElasticAttribute.ElasticGeometryType.GEO_SHAPE);
                    break;
                }
                case "string": 
                case "keyword": 
                case "text": {
                    binding = String.class;
                    elasticAttribute.setAnalyzed(ElasticDataStore.isAnalyzed(map));
                    break;
                }
                case "integer": {
                    binding = Integer.class;
                    break;
                }
                case "long": {
                    binding = Long.class;
                    break;
                }
                case "float": {
                    binding = Float.class;
                    break;
                }
                case "double": {
                    binding = Double.class;
                    break;
                }
                case "boolean": {
                    binding = Boolean.class;
                    break;
                }
                case "date": {
                    ArrayList<String> validFormats = new ArrayList<String>();
                    String availableFormat = (String)map.get("format");
                    if (availableFormat == null) {
                        validFormats.add("date_optional_time");
                    } else if (!availableFormat.contains("\\|\\|")) {
                        try {
                            Joda.forPattern(availableFormat);
                            validFormats.add(availableFormat);
                        }
                        catch (Exception e) {
                            LOGGER.fine("Unable to parse date format ('" + availableFormat + "') for " + propertyKey);
                        }
                    } else {
                        String[] formats;
                        for (String format : formats = availableFormat.split("\\|\\|")) {
                            try {
                                Joda.forPattern(format);
                                validFormats.add(format);
                            }
                            catch (Exception e) {
                                LOGGER.fine("Unable to parse date format ('" + format + "') for " + propertyKey);
                            }
                        }
                    }
                    if (validFormats.isEmpty()) {
                        validFormats.add("date_optional_time");
                    }
                    elasticAttribute.setValidDateFormats(validFormats);
                    binding = Date.class;
                    break;
                }
                case "binary": {
                    binding = byte[].class;
                    break;
                }
                default: {
                    binding = null;
                }
            }
            if (binding != null) {
                boolean stored = map.get("store") != null ? (Boolean)map.get("store") : false;
                elasticAttribute.setStored(stored);
                elasticAttribute.setType(binding);
                elasticAttribute.setNested(nested);
                elasticAttributes.add(elasticAttribute);
            }
        }
    }

    private static void checkRestClient(RestClient client) throws IOException {
        Response response = client.performRequest(new Request("GET", "/"));
        int status = response.getStatusLine().getStatusCode();
        if (status >= 400) {
            String reason = response.getStatusLine().getReasonPhrase();
            throw new IOException(String.format("Unexpected response from Elasticsearch: %d %s", status, reason));
        }
    }

    static boolean isAnalyzed(Map<String, Object> map) {
        boolean analyzed = false;
        Object value = map.get("type");
        if (value instanceof String && value.equals("text")) {
            analyzed = true;
        }
        return analyzed;
    }

    public static enum ArrayEncoding {
        JSON,
        CSV;

    }
}

