/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.elasticsearch;

import com.github.davidmoten.geo.GeoHash;
import java.util.Map;
import org.locationtech.jts.geom.Envelope;

class GeohashUtil {
    GeohashUtil() {
    }

    public static int computePrecision(Envelope envelope, long size, double threshold) {
        return GeohashUtil.computePrecision(envelope, size, threshold, 1);
    }

    private static int computePrecision(Envelope envelope, long size, double threshold, int n) {
        return GeohashUtil.computeSize(envelope, n) / (double)size > threshold ? n : GeohashUtil.computePrecision(envelope, size, threshold, n + 1);
    }

    private static double computeSize(Envelope envelope, int n) {
        double area = Math.min(64800.0, envelope.getArea());
        return area / (GeoHash.widthDegrees((int)n) * GeoHash.heightDegrees((int)n));
    }

    public static void updateGridAggregationPrecision(Map<String, Map<String, Map<String, Object>>> aggregations, int precision) {
        aggregations.values().stream().filter(a -> a.containsKey("geohash_grid")).forEach(a -> ((Map)a.get("geohash_grid")).put("precision", precision));
    }
}

