/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.elasticsearch;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.RestClient;
import org.geotools.data.elasticsearch.ElasticClient;
import org.geotools.data.elasticsearch.ElasticMappings;
import org.geotools.data.elasticsearch.ElasticRequest;
import org.geotools.data.elasticsearch.ElasticResponse;
import org.geotools.util.logging.Logging;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class RestElasticClient
implements ElasticClient {
    static final double DEFAULT_VERSION = 7.0;
    private static final Logger LOGGER = Logging.getLogger(RestElasticClient.class);
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private final RestClient client;
    private final RestClient proxyClient;
    private final boolean enableRunAs;
    private final ObjectMapper mapper;
    private Double version;

    public RestElasticClient(RestClient client) {
        this(client, null, false);
    }

    public RestElasticClient(RestClient client, RestClient proxyClient, boolean enableRunAs) {
        this.client = client;
        this.proxyClient = proxyClient;
        this.mapper = new ObjectMapper();
        this.mapper.setDateFormat(DATE_FORMAT);
        this.enableRunAs = enableRunAs;
    }

    @Override
    public double getVersion() {
        if (this.version != null) {
            return this.version;
        }
        Pattern pattern = Pattern.compile("(\\d+\\.\\d+)\\.\\d+");
        try {
            Response response = this.performRequest("GET", "/", null, true);
            try (InputStream inputStream = response.getEntity().getContent();){
                Map info = (Map)this.mapper.readValue(inputStream, (TypeReference)new TypeReference<Map<String, Object>>(){});
                Map ver = info.getOrDefault("version", Collections.EMPTY_MAP);
                Matcher m = pattern.matcher((String)ver.get("number"));
                this.version = !m.find() ? Double.valueOf(7.0) : Double.valueOf(m.group(1));
            }
        }
        catch (Exception e) {
            LOGGER.warning("Error getting server version: " + e);
            this.version = 7.0;
        }
        return this.version;
    }

    @Override
    public List<String> getTypes(String indexName) throws IOException {
        return new ArrayList<String>(this.getMappings(indexName, null).keySet());
    }

    @Override
    public Map<String, Object> getMapping(String indexName, String type) throws IOException {
        ElasticMappings.Mapping mapping;
        Map<String, ElasticMappings.Mapping> mappings = this.getMappings(indexName, type);
        Map<String, Object> properties = this.getVersion() < 7.0 && mappings.containsKey(type) ? mappings.get(type).getProperties() : (this.getVersion() >= 7.0 ? ((mapping = (ElasticMappings.Mapping)mappings.values().stream().findFirst().orElse(null)) != null ? mapping.getProperties() : null) : null);
        return properties;
    }

    private Map<String, ElasticMappings.Mapping> getMappings(String indexName, String type) throws IOException {
        Response response;
        try {
            StringBuilder path = new StringBuilder("/").append(indexName).append("/_mapping");
            if (type != null && this.getVersion() < 7.0) {
                path.append("/").append(type);
            }
            response = this.performRequest("GET", path.toString(), null, true);
        }
        catch (ResponseException e) {
            if (e.getResponse().getStatusLine().getStatusCode() == 404) {
                return Collections.emptyMap();
            }
            throw e;
        }
        String aliasedIndex = this.getIndices(indexName).stream().findFirst().orElse(null);
        try (InputStream inputStream = response.getEntity().getContent();){
            Map<String, ElasticMappings.Mapping> mappings;
            HashMap<String, ElasticMappings> values;
            if (this.getVersion() < 7.0) {
                values = (HashMap<String, ElasticMappings>)this.mapper.readValue(inputStream, (TypeReference)new TypeReference<Map<String, ElasticMappings>>(){});
            } else {
                Map res = (Map)this.mapper.readValue(inputStream, (TypeReference)new TypeReference<Map<String, ElasticMappings.Untyped>>(){});
                values = new HashMap<String, ElasticMappings>();
                for (Map.Entry entry : res.entrySet()) {
                    ElasticMappings mappings2 = new ElasticMappings();
                    mappings2.setMappings(new HashMap<String, ElasticMappings.Mapping>());
                    if (aliasedIndex != null && aliasedIndex.equals(entry.getKey())) {
                        mappings2.getMappings().put(aliasedIndex, ((ElasticMappings.Untyped)entry.getValue()).getMappings());
                        values.put(aliasedIndex, mappings2);
                        continue;
                    }
                    mappings2.getMappings().put(indexName, ((ElasticMappings.Untyped)entry.getValue()).getMappings());
                    values.put((String)entry.getKey(), mappings2);
                }
            }
            if (values.containsKey(indexName)) {
                mappings = ((ElasticMappings)values.get(indexName)).getMappings();
            } else if (values.containsKey(aliasedIndex)) {
                mappings = ((ElasticMappings)values.get(aliasedIndex)).getMappings();
            } else if (!values.isEmpty()) {
                mappings = ((ElasticMappings)values.values().iterator().next()).getMappings();
            } else {
                LOGGER.severe("No types found for index/alias " + indexName);
                mappings = Collections.emptyMap();
            }
            Map<String, ElasticMappings.Mapping> map = mappings;
            return map;
        }
    }

    @Override
    public ElasticResponse search(String searchIndices, String type, ElasticRequest request) throws IOException {
        List<String> sourceIncludes;
        StringBuilder pathBuilder = new StringBuilder("/" + searchIndices);
        if (this.getVersion() < 7.0) {
            pathBuilder.append("/" + type);
        }
        pathBuilder.append("/_search");
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        if (request.getSize() != null) {
            requestBody.put("size", request.getSize());
        }
        if (request.getFrom() != null) {
            requestBody.put("from", request.getFrom());
        }
        if (request.getScroll() != null) {
            pathBuilder.append("?scroll=").append(request.getScroll()).append("s");
        }
        if ((sourceIncludes = request.getSourceIncludes()).size() == 1) {
            requestBody.put("_source", sourceIncludes.get(0));
        } else if (!sourceIncludes.isEmpty()) {
            requestBody.put("_source", sourceIncludes);
        }
        if (!request.getFields().isEmpty()) {
            String key = this.getVersion() >= 5.0 ? "stored_fields" : "fields";
            requestBody.put(key, request.getFields());
        }
        if (!request.getSorts().isEmpty()) {
            requestBody.put("sort", request.getSorts());
        }
        if (request.getQuery() != null) {
            requestBody.put("query", request.getQuery());
        }
        if (request.getAggregations() != null) {
            requestBody.put("aggregations", request.getAggregations());
        }
        return this.parseResponse(this.performRequest("POST", pathBuilder.toString(), requestBody));
    }

    private Response performRequest(String method, String path, Map<String, Object> requestBody, boolean isAdmin) throws IOException {
        ByteArrayEntity entity;
        if (requestBody != null) {
            byte[] data = this.mapper.writeValueAsBytes(requestBody);
            entity = new ByteArrayEntity(data, ContentType.APPLICATION_JSON);
        } else {
            entity = null;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Method: " + method);
            LOGGER.fine("Path: " + path);
            String requestString = this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString(requestBody);
            LOGGER.fine("RequestBody: " + requestString);
        }
        RestClient client = isAdmin || this.proxyClient == null ? this.client : this.proxyClient;
        Request request = new Request(method, path);
        request.setEntity((HttpEntity)entity);
        if (!isAdmin && this.enableRunAs) {
            SecurityContext ctx = SecurityContextHolder.getContext();
            Authentication auth = ctx.getAuthentication();
            if (auth == null) {
                throw new IllegalStateException("Authentication could not be determined!");
            }
            if (!auth.isAuthenticated()) {
                throw new IllegalStateException(String.format("User is not authenticated: %s", auth.getName()));
            }
            RequestOptions.Builder optionsBuilder = RequestOptions.DEFAULT.toBuilder();
            optionsBuilder.addHeader("es-security-runas-user", auth.getName());
            request.setOptions(optionsBuilder);
            LOGGER.fine(String.format("Performing request on behalf of user %s", auth.getName()));
        } else {
            LOGGER.fine(String.format("Performing request with %s credentials", isAdmin ? "user" : "proxy"));
        }
        Response response = client.performRequest(request);
        if (response.getStatusLine().getStatusCode() >= 400) {
            throw new IOException("Error executing request: " + response.getStatusLine().getReasonPhrase());
        }
        return response;
    }

    Response performRequest(String method, String path, Map<String, Object> requestBody) throws IOException {
        return this.performRequest(method, path, requestBody, false);
    }

    private ElasticResponse parseResponse(Response response) throws IOException {
        try (InputStream inputStream = response.getEntity().getContent();){
            ElasticResponse elasticResponse = (ElasticResponse)this.mapper.readValue(inputStream, ElasticResponse.class);
            return elasticResponse;
        }
    }

    @Override
    public ElasticResponse scroll(String scrollId, Integer scrollTime) throws IOException {
        String path = "/_search/scroll";
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("scroll_id", scrollId);
        requestBody.put("scroll", scrollTime + "s");
        return this.parseResponse(this.performRequest("POST", "/_search/scroll", requestBody));
    }

    @Override
    public void clearScroll(Set<String> scrollIds) throws IOException {
        String path = "/_search/scroll";
        if (!scrollIds.isEmpty()) {
            HashMap<String, Object> requestBody = new HashMap<String, Object>();
            requestBody.put("scroll_id", scrollIds);
            this.performRequest("DELETE", "/_search/scroll", requestBody);
        }
    }

    @Override
    public void close() throws IOException {
        LOGGER.fine("Closing proxyClient: " + this.client);
        try {
            this.client.close();
        }
        finally {
            if (this.proxyClient != null) {
                LOGGER.fine("Closing proxyClient: " + this.proxyClient);
                this.proxyClient.close();
            }
        }
    }

    public static void removeMapping(String parent, String key, Map<String, Object> data, String currentParent) {
        Iterator<Map.Entry<String, Object>> it = data.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            if (Objects.equals(currentParent, parent) && entry.getKey().equals(key)) {
                it.remove();
                continue;
            }
            if (entry.getValue() instanceof Map) {
                RestElasticClient.removeMapping(parent, key, (Map)entry.getValue(), entry.getKey());
                continue;
            }
            if (!(entry.getValue() instanceof List)) continue;
            ((List)entry.getValue()).stream().filter(item -> item instanceof Map).forEach(item -> RestElasticClient.removeMapping(parent, key, (Map)item, currentParent));
        }
    }

    private Set<String> getIndices(String alias) {
        Set<String> indices;
        try {
            Response response = this.performRequest("GET", "/_alias/" + alias, null, true);
            try (InputStream inputStream = response.getEntity().getContent();){
                Map result = (Map)this.mapper.readValue(inputStream, (TypeReference)new TypeReference<Map<String, Object>>(){});
                indices = result.keySet();
            }
        }
        catch (IOException e) {
            indices = new HashSet<String>();
        }
        return indices;
    }
}

