/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.elasticsearch;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.davidmoten.geo.GeoHash;
import com.github.davidmoten.geo.LatLong;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.process.elasticsearch.GridCell;
import org.geotools.process.elasticsearch.RasterScale;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

abstract class GeoHashGrid {
    private static final Logger LOGGER = Logging.getLogger(GeoHashGrid.class);
    private static final int DEFAULT_PRECISION = 2;
    public static final String BUCKET_NAME_KEY = "key";
    public static final String BUCKETS_KEY = "buckets";
    public static final String DOC_COUNT_KEY = "doc_count";
    public static final String VALUE_KEY = "value";
    private double cellWidth;
    private double cellHeight;
    private double lonOffset;
    private Envelope envelope;
    private ReferencedEnvelope boundingBox;
    private float emptyCellValue = 0.0f;
    private float[][] grid;
    private RasterScale scale = new RasterScale();

    GeoHashGrid() {
    }

    public void initalize(ReferencedEnvelope srcEnvelope, SimpleFeatureCollection features) throws TransformException, FactoryException {
        int precision;
        String firstGeohash;
        List<Map<String, Object>> buckets = this.readFeatures(features);
        String string = firstGeohash = buckets.isEmpty() ? null : (String)buckets.get(0).get(BUCKET_NAME_KEY);
        if (!this.isValid(firstGeohash)) {
            LOGGER.fine("No aggregations found or missing/invalid geohash key");
            precision = 2;
        } else {
            precision = ((String)buckets.get(0).get(BUCKET_NAME_KEY)).length();
        }
        this.cellWidth = GeoHash.widthDegrees((int)precision);
        this.cellHeight = GeoHash.heightDegrees((int)precision);
        if (srcEnvelope.getCoordinateReferenceSystem() != null) {
            srcEnvelope = srcEnvelope.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, false);
        }
        this.computeMinLonOffset(srcEnvelope);
        this.envelope = this.computeEnvelope(srcEnvelope, precision);
        this.boundingBox = new ReferencedEnvelope(this.envelope.getMinX() - this.cellWidth / 2.0, this.envelope.getMaxX() + this.cellWidth / 2.0, this.envelope.getMinY() - this.cellHeight / 2.0, this.envelope.getMaxY() + this.cellHeight / 2.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        int numCol = (int)Math.round((this.envelope.getMaxX() - this.envelope.getMinX()) / this.cellWidth + 1.0);
        int numRow = (int)Math.round((this.envelope.getMaxY() - this.envelope.getMinY()) / this.cellHeight + 1.0);
        this.grid = new float[numRow][numCol];
        LOGGER.fine("Created grid with size (" + numCol + ", " + numRow + ")");
        if (this.emptyCellValue != 0.0f) {
            for (float[] row : this.grid) {
                Arrays.fill(row, this.emptyCellValue);
            }
        }
        ArrayList cells = new ArrayList();
        buckets.forEach(bucket -> {
            Number rasterValue = this.computeCellValue((Map<String, Object>)bucket);
            cells.add(new GridCell((String)bucket.get(BUCKET_NAME_KEY), rasterValue));
            this.scale.prepareScale(rasterValue.floatValue());
        });
        cells.forEach(cell -> this.updateGrid(cell.getGeohash(), cell.getValue()));
        LOGGER.fine("Read " + cells.size() + " aggregation buckets");
    }

    protected abstract Number computeCellValue(Map<String, Object> var1);

    private void updateGrid(String geohash, Number value) {
        if (geohash != null && value != null) {
            double lon;
            LatLong latLon = GeoHash.decodeHash((String)geohash);
            double lat = latLon.getLat();
            if (this.isValid(lat, (lon = latLon.getLon() + this.lonOffset) - 360.0)) {
                this.updateGrid(lat, lon - 360.0, value);
            }
            if (this.isValid(lat, lon)) {
                this.updateGrid(lat, lon, value);
            }
            while (this.isValid(lat, lon += 360.0)) {
                this.updateGrid(lat, lon, value);
            }
        }
    }

    private void updateGrid(double lat, double lon, Number value) {
        int row = this.grid.length - (int)Math.round((lat - this.envelope.getMinY()) / this.cellHeight) - 1;
        int col = (int)Math.round((lon - this.envelope.getMinX()) / this.cellWidth);
        this.grid[Math.min((int)row, (int)(this.grid.length - 1))][Math.min((int)col, (int)(this.grid[0].length - 1))] = this.scale.scaleValue(value.floatValue());
    }

    public GridCoverage2D toGridCoverage2D() {
        GridCoverageFactory coverageFactory = CoverageFactoryFinder.getGridCoverageFactory((Hints)GeoTools.getDefaultHints());
        return coverageFactory.create((CharSequence)"geohashGridAgg", this.grid, (org.opengis.geometry.Envelope)this.boundingBox);
    }

    private List<Map<String, Object>> readFeatures(SimpleFeatureCollection features) {
        ArrayList<Map<String, Object>> buckets;
        block10: {
            ObjectMapper mapper = new ObjectMapper();
            buckets = new ArrayList<Map<String, Object>>();
            SimpleFeatureIterator iterator = features.features();
            block7: while (true) {
                while (iterator.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)iterator.next();
                    if (feature.getAttribute("_aggregation") == null) continue;
                    byte[] data = (byte[])feature.getAttribute("_aggregation");
                    try {
                        Map aggregation = (Map)mapper.readValue(data, (TypeReference)new TypeReference<Map<String, Object>>(){});
                        buckets.add(aggregation);
                        continue block7;
                    }
                    catch (IOException e) {
                        LOGGER.fine("Failed to parse aggregation value: " + e);
                    }
                }
                break block10;
                {
                    continue block7;
                    break;
                }
                break;
            }
            finally {
                if (iterator != null) {
                    iterator.close();
                }
            }
        }
        return buckets;
    }

    private Envelope computeEnvelope(ReferencedEnvelope outEnvelope, int precision) {
        String minHash = GeoHash.encodeHash((double)Math.max(-90.0, outEnvelope.getMinY()), (double)outEnvelope.getMinX(), (int)precision);
        LatLong minLatLon = GeoHash.decodeHash((String)minHash);
        double minLon = minLatLon.getLon() + this.lonOffset;
        double width = Math.ceil(outEnvelope.getWidth() / this.cellWidth) * this.cellWidth;
        double maxLon = minLon + width - this.cellWidth;
        String maxHash = GeoHash.encodeHash((double)Math.min(90.0, outEnvelope.getMaxY()), (double)maxLon, (int)precision);
        LatLong maxLatLon = GeoHash.decodeHash((String)maxHash);
        return new Envelope(minLon, maxLon, minLatLon.getLat(), maxLatLon.getLat());
    }

    private void computeMinLonOffset(ReferencedEnvelope env) {
        double minLon = env.getMinX() > 180.0 ? env.getMinX() % 360.0 : (env.getMinX() < -180.0 ? 360.0 - Math.abs(env.getMinX()) % 360.0 : env.getMinX() % 360.0);
        if (minLon > 180.0) {
            minLon -= 360.0;
        }
        this.lonOffset = env.getMinX() - minLon;
    }

    private boolean isValid(double lat, double lon) {
        return lon >= this.envelope.getMinX() && lon <= this.envelope.getMaxX() && lat >= this.envelope.getMinY() && lat <= this.envelope.getMaxY();
    }

    private boolean isValid(String geohash) {
        return geohash != null && geohash.equals(GeoHash.encodeHash((LatLong)GeoHash.decodeHash((String)geohash), (int)geohash.length()));
    }

    String pluckBucketName(Map<String, Object> bucket) {
        if (!bucket.containsKey(BUCKET_NAME_KEY)) {
            LOGGER.warning("Unable to pluck key, bucket does not contain required field:key");
            throw new IllegalArgumentException();
        }
        return bucket.get(BUCKET_NAME_KEY) + "";
    }

    Number pluckDocCount(Map<String, Object> bucket) {
        if (!bucket.containsKey(DOC_COUNT_KEY)) {
            LOGGER.warning("Unable to pluck document count, bucket does not contain required key:doc_count");
            throw new IllegalArgumentException();
        }
        return (Number)bucket.get(DOC_COUNT_KEY);
    }

    Number pluckMetricValue(Map<String, Object> bucket, String metricKey, String valueKey) {
        Number value;
        if (null == metricKey || metricKey.trim().length() == 0) {
            value = this.pluckDocCount(bucket);
        } else {
            if (!bucket.containsKey(metricKey)) {
                LOGGER.warning("Unable to pluck metric, bucket does not contain required key:" + metricKey);
                throw new IllegalArgumentException();
            }
            Map metric = (Map)bucket.get(metricKey);
            if (!metric.containsKey(valueKey)) {
                LOGGER.warning("Unable to pluck value, metric does not contain required key:" + valueKey);
                throw new IllegalArgumentException();
            }
            value = (Number)metric.get(valueKey);
        }
        return value;
    }

    List<Map<String, Object>> pluckAggBuckets(Map<String, Object> parentBucket, String aggKey) {
        if (!parentBucket.containsKey(aggKey)) {
            LOGGER.warning("Unable to pluck aggregation results, parent bucket does not contain required key:" + aggKey);
            throw new IllegalArgumentException();
        }
        Map aggResults = (Map)parentBucket.get(aggKey);
        if (!aggResults.containsKey(BUCKETS_KEY)) {
            LOGGER.warning("Unable to pluck buckets, aggregation results bucket does not contain required key:buckets");
            throw new IllegalArgumentException();
        }
        return (List)aggResults.get(BUCKETS_KEY);
    }

    public void setParams(List<String> params) {
    }

    public void setEmptyCellValue(Float value) {
        if (null != value) {
            this.emptyCellValue = value.floatValue();
        }
    }

    public double getCellWidth() {
        return this.cellWidth;
    }

    public double getCellHeight() {
        return this.cellHeight;
    }

    public Envelope getEnvelope() {
        return this.envelope;
    }

    public ReferencedEnvelope getBoundingBox() {
        return this.boundingBox;
    }

    public float[][] getGrid() {
        return this.grid;
    }

    public void setScale(RasterScale scale) {
        this.scale = scale;
    }
}

