/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.elasticsearch;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.process.elasticsearch.GeoHashGrid;
import org.geotools.util.logging.Logging;

public class NestedAggGeoHashGrid
extends GeoHashGrid {
    private static final Logger LOGGER = Logging.getLogger(NestedAggGeoHashGrid.class);
    private static final int NESTED_KEY_INDEX = 0;
    private static final int METRIC_KEY_INDEX = 1;
    private static final int VALUE_KEY_INDEX = 2;
    private static final int SELECTION_STRATEGY_INDEX = 3;
    private static final int RASTER_STRATEGY_INDEX = 4;
    private static final int TERMS_MAP_INDEX = 5;
    static final String SELECT_LARGEST = "largest";
    static final String SELECT_SMALLEST = "smallest";
    static final String RASTER_FROM_VALUE = "value";
    static final String RASTER_FROM_KEY = "key";
    static final String DEFAULT_AGG_KEY = "nested";
    static final String DEFAULT_METRIC_KEY = "";
    private String nestedAggKey = "nested";
    private String metricKey = "";
    private String valueKey = "value";
    private String selectionStrategy = "largest";
    private String rasterStrategy = "value";
    private Map<String, Integer> termsMap = null;

    @Override
    public void setParams(List<String> params) {
        if (null != params) {
            if (params.size() < 5) {
                LOGGER.warning("Parameters list does not contain required length; you provided " + params.size() + ", expecting: 5 or more");
                throw new IllegalArgumentException();
            }
            this.nestedAggKey = params.get(0);
            this.metricKey = params.get(1);
            this.valueKey = params.get(2);
            switch (params.get(3)) {
                case "smallest": {
                    this.selectionStrategy = params.get(3);
                    break;
                }
                case "largest": {
                    this.selectionStrategy = params.get(3);
                    break;
                }
                default: {
                    LOGGER.warning("Unexpected buckets selection strategy parameter; you provided " + params.get(3) + ", defaulting to: " + this.selectionStrategy);
                }
            }
            switch (params.get(4)) {
                case "value": {
                    this.rasterStrategy = params.get(4);
                    break;
                }
                case "key": {
                    this.rasterStrategy = params.get(4);
                    break;
                }
                default: {
                    LOGGER.warning("Unexpected raster strategy parameter; you provided " + params.get(4) + ", defaulting to: " + this.rasterStrategy);
                }
            }
            if (this.rasterStrategy.equals(RASTER_FROM_KEY) && params.size() >= 6) {
                String[] terms;
                this.termsMap = new HashMap<String, Integer>();
                for (String term : terms = params.get(5).split(";")) {
                    String[] keyValueSplit = term.split(":");
                    if (keyValueSplit.length != 2) {
                        LOGGER.warning("Term " + term + " does not contain required format <key>:<value>");
                        throw new IllegalArgumentException();
                    }
                    this.termsMap.put(keyValueSplit[0], Integer.valueOf(keyValueSplit[1]));
                }
            }
        }
    }

    @Override
    public Number computeCellValue(Map<String, Object> geogridBucket) {
        List<Map<String, Object>> aggBuckets = super.pluckAggBuckets(geogridBucket, this.nestedAggKey);
        Number rasterValue = 0;
        switch (this.selectionStrategy) {
            case "smallest": {
                rasterValue = this.selectSmallest(aggBuckets);
                break;
            }
            case "largest": {
                rasterValue = this.selectLargest(aggBuckets);
            }
        }
        return rasterValue;
    }

    Number selectLargest(List<Map<String, Object>> buckets) {
        String largestKey = this.pluckBucketName(buckets.get(0));
        Number largestValue = super.pluckMetricValue(buckets.get(0), this.metricKey, this.valueKey);
        for (Map<String, Object> bucket : buckets) {
            Number value = super.pluckMetricValue(bucket, this.metricKey, this.valueKey);
            if (!(value.doubleValue() > largestValue.doubleValue())) continue;
            largestKey = super.pluckBucketName(bucket);
            largestValue = value;
        }
        return this.bucketToRaster(largestKey, largestValue);
    }

    Number selectSmallest(List<Map<String, Object>> buckets) {
        String smallestKey = this.pluckBucketName(buckets.get(0));
        Number smallestValue = super.pluckMetricValue(buckets.get(0), this.metricKey, this.valueKey);
        for (Map<String, Object> bucket : buckets) {
            Number value = super.pluckMetricValue(bucket, this.metricKey, this.valueKey);
            if (!(value.doubleValue() < smallestValue.doubleValue())) continue;
            smallestKey = super.pluckBucketName(bucket);
            smallestValue = value;
        }
        return this.bucketToRaster(smallestKey, smallestValue);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Number bucketToRaster(String key, Number value) {
        Number rasterValue = value;
        if (!this.rasterStrategy.equals(RASTER_FROM_KEY)) return rasterValue;
        if (null != this.termsMap) {
            if (this.termsMap.containsKey(key)) {
                return this.termsMap.get(key);
            }
            LOGGER.warning("Cannot convert key (String) to raster value, mapping does not contain key " + key + ". Add key to terms_map argument to resolve.");
            throw new IllegalArgumentException();
        }
        try {
            return Double.valueOf(key);
        }
        catch (NumberFormatException nfe) {
            LOGGER.warning("Cannot convert key (String) to raster value, key, " + key + ", is not a number. Use terms_map argument to map Strings to Numbers.");
            throw new IllegalArgumentException();
        }
    }

    public String getNestedAggKey() {
        return this.nestedAggKey;
    }

    public String getMetricKey() {
        return this.metricKey;
    }

    public String getValueKey() {
        return this.valueKey;
    }

    public String getSelectionStrategy() {
        return this.selectionStrategy;
    }

    public String getRasterStrategy() {
        return this.rasterStrategy;
    }

    public Map<String, Integer> getTermsMap() {
        return this.termsMap;
    }
}

