/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.elasticsearch;

import java.util.HashMap;
import java.util.Map;
import org.geotools.api.filter.ExcludeFilter;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.Id;
import org.geotools.api.filter.IncludeFilter;
import org.geotools.api.filter.PropertyIsBetween;
import org.geotools.api.filter.PropertyIsLike;
import org.geotools.api.filter.PropertyIsNull;
import org.geotools.api.filter.capability.FilterCapabilities;
import org.geotools.api.filter.capability.TemporalCapabilities;
import org.geotools.api.filter.capability.TemporalOperators;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.filter.spatial.Beyond;
import org.geotools.api.filter.spatial.Contains;
import org.geotools.api.filter.spatial.DWithin;
import org.geotools.api.filter.spatial.Disjoint;
import org.geotools.api.filter.spatial.Intersects;
import org.geotools.api.filter.spatial.Within;
import org.geotools.api.filter.temporal.After;
import org.geotools.api.filter.temporal.AnyInteracts;
import org.geotools.api.filter.temporal.Before;
import org.geotools.api.filter.temporal.Begins;
import org.geotools.api.filter.temporal.BegunBy;
import org.geotools.api.filter.temporal.BinaryTemporalOperator;
import org.geotools.api.filter.temporal.During;
import org.geotools.api.filter.temporal.EndedBy;
import org.geotools.api.filter.temporal.Ends;
import org.geotools.api.filter.temporal.Meets;
import org.geotools.api.filter.temporal.MetBy;
import org.geotools.api.filter.temporal.OverlappedBy;
import org.geotools.api.filter.temporal.TContains;
import org.geotools.api.filter.temporal.TEquals;
import org.geotools.api.filter.temporal.TOverlaps;
import org.geotools.filter.Capabilities;
import org.geotools.filter.capability.FilterCapabilitiesImpl;
import org.geotools.filter.capability.TemporalCapabilitiesImpl;
import org.geotools.filter.capability.TemporalOperatorImpl;
import org.geotools.filter.visitor.IsFullySupportedFilterVisitor;

class ElasticCapabilities
extends Capabilities {
    private static final Map<Class<?>, String> temporalNames = new HashMap();
    private IsFullySupportedFilterVisitor fullySupportedVisitor;

    public ElasticCapabilities() {
        super((FilterCapabilities)new ElasticFilterCapabilities());
        this.addAll(LOGICAL_OPENGIS);
        this.addAll(SIMPLE_COMPARISONS_OPENGIS);
        this.addType(PropertyIsNull.class);
        this.addType(PropertyIsBetween.class);
        this.addType(Id.class);
        this.addType(IncludeFilter.class);
        this.addType(ExcludeFilter.class);
        this.addType(PropertyIsLike.class);
        this.addType(BBOX.class);
        this.addType(Contains.class);
        this.addType(Disjoint.class);
        this.addType(Intersects.class);
        this.addType(Within.class);
        this.addType(DWithin.class);
        this.addType(Beyond.class);
        this.addType(After.class);
        this.addType(Before.class);
        this.addType(Begins.class);
        this.addType(BegunBy.class);
        this.addType(During.class);
        this.addType(Ends.class);
        this.addType(EndedBy.class);
        this.addType(TContains.class);
        this.addType(TEquals.class);
    }

    public boolean fullySupports(Filter filter) {
        if (this.fullySupportedVisitor == null) {
            this.fullySupportedVisitor = new ElasticIsFullySupportedFilterVisitor();
        }
        return filter != null ? (Boolean)filter.accept((FilterVisitor)this.fullySupportedVisitor, null) : false;
    }

    public String toOperationName(Class filterType) {
        if (filterType != null && temporalNames.containsKey(filterType)) {
            return temporalNames.get(filterType);
        }
        return super.toOperationName(filterType);
    }

    public void addName(String name) {
        if (name != null && temporalNames.containsValue(name)) {
            TemporalOperators operators = this.getContents().getTemporalCapabilities().getTemporalOperators();
            operators.getOperators().add(new TemporalOperatorImpl(name));
        } else {
            super.addName(name);
        }
    }

    static {
        temporalNames.put(After.class, "After");
        temporalNames.put(AnyInteracts.class, "AnyInteracts");
        temporalNames.put(Before.class, "Before");
        temporalNames.put(Begins.class, "Begins");
        temporalNames.put(BegunBy.class, "BegunBy");
        temporalNames.put(During.class, "During");
        temporalNames.put(EndedBy.class, "EndedBy");
        temporalNames.put(Ends.class, "Ends");
        temporalNames.put(Meets.class, "Meets");
        temporalNames.put(MetBy.class, "MetBy");
        temporalNames.put(OverlappedBy.class, "OverlappedBy");
        temporalNames.put(TContains.class, "TContains");
        temporalNames.put(TEquals.class, "TEquals");
        temporalNames.put(TOverlaps.class, "TOverlaps");
    }

    private class ElasticIsFullySupportedFilterVisitor
    extends IsFullySupportedFilterVisitor {
        ElasticIsFullySupportedFilterVisitor() {
            super((FilterCapabilities)ElasticCapabilities.this.getContents());
        }

        public Object visit(ExcludeFilter filter, Object extraData) {
            return true;
        }

        public Object visit(IncludeFilter filter, Object extraData) {
            return true;
        }

        public Object visit(BegunBy begunBy, Object extraData) {
            return this.visit((BinaryTemporalOperator)begunBy, "BegunBy");
        }
    }

    private static class ElasticFilterCapabilities
    extends FilterCapabilitiesImpl {
        TemporalCapabilitiesImpl temporal;

        private ElasticFilterCapabilities() {
        }

        public TemporalCapabilities getTemporalCapabilities() {
            if (this.temporal == null) {
                this.temporal = new TemporalCapabilitiesImpl();
                super.setTemporal(this.temporal);
            }
            return this.temporal;
        }
    }
}

