/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.elasticsearch;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.davidmoten.geo.GeoHash;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.Unit;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.crs.GeographicCRS;
import org.geotools.api.referencing.crs.SingleCRS;
import org.geotools.data.elasticsearch.ElasticParserUtil;
import org.geotools.data.elasticsearch.FilterToElasticException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;
import si.uom.SI;

public class GeohashUtil {
    static final double OGC_DEGREE_TO_METERS = 111319.49079327358;
    static final double DEFAULT_PIXEL_SIZE_METER = 2.8E-4;
    static final ObjectMapper MAPPER = new ObjectMapper();
    static final Logger LOGGER = Logging.getLogger(GeohashUtil.class);

    public static int computePrecision(Envelope envelope, long size, double threshold) {
        return GeohashUtil.computePrecision(envelope, size, threshold, 1);
    }

    private static int computePrecision(Envelope envelope, long size, double threshold, int n) {
        return GeohashUtil.computeSize(envelope, n) / (double)size >= threshold ? n : GeohashUtil.computePrecision(envelope, size, threshold, n + 1);
    }

    private static double computeSize(Envelope envelope, int n) {
        double area = Math.min(64800.0, envelope.getArea());
        return area / (GeoHash.widthDegrees((int)n) * GeoHash.heightDegrees((int)n));
    }

    public static void updateGridAggregationPrecision(Map<String, Map<String, Map<String, Object>>> aggregations, int precision) {
        aggregations.values().stream().filter(a -> a.containsKey("geohash_grid")).forEach(a -> GeohashUtil.updateAggregatePrecision(precision, a));
    }

    private static void updateAggregatePrecision(int precision, Map<String, Map<String, Object>> a) {
        Map<String, Object> grid = a.get("geohash_grid");
        Object foundPrecision = grid.get("precision");
        if (!(foundPrecision instanceof Number) || ((Number)foundPrecision).intValue() > precision) {
            LOGGER.log(Level.FINE, "Updating aggregation precision from " + foundPrecision + " to " + precision);
            grid.put("precision", precision);
        }
    }

    public static Map<String, Map<String, Map<String, Object>>> parseAggregation(String definition) {
        TypeReference<Map<String, Map<String, Map<String, Object>>>> type = new TypeReference<Map<String, Map<String, Map<String, Object>>>>(){};
        try {
            return (Map)MAPPER.readValue(definition, (TypeReference)type);
        }
        catch (Exception e) {
            try {
                return (Map)MAPPER.readValue(ElasticParserUtil.urlDecode(definition), (TypeReference)type);
            }
            catch (Exception e2) {
                throw new FilterToElasticException("Unable to parse aggregation", e);
            }
        }
    }

    public static int getPrecisionFromScale(ReferencedEnvelope envelope, int imageWidth) {
        double ghh;
        double ghw;
        double ps;
        int precision;
        double targetScaleDenominator = GeohashUtil.calculateOGCScale(envelope, imageWidth);
        double sd = 0.0;
        for (precision = 1; precision <= 12 && !((sd = (ps = Math.sqrt((ghw = GeoHash.widthDegrees((int)precision)) * (ghh = GeoHash.heightDegrees((int)precision)))) * 111319.49079327358 / 2.8E-4) < targetScaleDenominator); ++precision) {
        }
        if (precision > 1 && Math.abs(targetScaleDenominator - sd) > targetScaleDenominator * 0.1) {
            --precision;
        }
        return precision;
    }

    private static double calculateOGCScale(ReferencedEnvelope envelope, int imageWidth) {
        CoordinateReferenceSystem crs = envelope.getCoordinateReferenceSystem();
        double width = envelope.getWidth();
        double widthMeters = GeohashUtil.toMeters(width, crs);
        double dpi = 90.7142857142857;
        return widthMeters / ((double)imageWidth / dpi * 0.0254);
    }

    private static double toMeters(double size, CoordinateReferenceSystem crs) {
        Unit unit;
        if (crs == null) {
            LOGGER.finer("toMeters: assuming the original size is in meters already, as crs is null");
            return size;
        }
        if (crs instanceof GeographicCRS) {
            return size * 111319.49079327358;
        }
        SingleCRS horizontal = CRS.getHorizontalCRS((CoordinateReferenceSystem)crs);
        if (horizontal != null) {
            crs = horizontal;
        }
        if ((unit = crs.getCoordinateSystem().getAxis(0).getUnit()) == null) {
            LOGGER.finer("toMeters: assuming the original size is in meters already, as the first crs axis unit is null. CRS is " + crs);
            return size;
        }
        if (!unit.isCompatible(SI.METRE)) {
            LOGGER.warning("toMeters: could not convert unit " + unit + " to meters");
            return size;
        }
        return unit.getConverterTo(SI.METRE).convert(size);
    }

    public static Integer getPrecision(String aggregationDefinition) {
        Integer precision = null;
        ObjectMapper mapper = new ObjectMapper();
        TypeReference<Map<String, Map<String, Map<String, Object>>>> type = new TypeReference<Map<String, Map<String, Map<String, Object>>>>(){};
        try {
            Map geohashMap;
            Map map = (Map)mapper.readValue(aggregationDefinition, (TypeReference)type);
            Map aggMap = (Map)map.get("agg");
            if (aggMap != null && (geohashMap = (Map)aggMap.get("geohash_grid")) != null && geohashMap.get("precision") != null && geohashMap.get("precision") instanceof Integer) {
                precision = (Integer)geohashMap.get("precision");
            }
        }
        catch (JsonProcessingException e) {
            LOGGER.log(Level.WARNING, "Failure when trying to read precision from aggregation definition: " + aggregationDefinition, e);
        }
        return precision;
    }
}

