/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.epsg.postgresql;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.epsg.FactoryUsingAnsiSQL;
import org.geotools.referencing.factory.epsg.ThreadedEpsgFactory;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.postgresql.ds.PGSimpleDataSource;
import org.postgresql.ds.common.BaseDataSource;

public class ThreadedPostgreSQLEpsgFactory
extends ThreadedEpsgFactory {
    public static final String CONFIGURATION_FILE = "EPSG-DataSource.properties";
    private String schema;

    public ThreadedPostgreSQLEpsgFactory() {
        this(null);
    }

    public ThreadedPostgreSQLEpsgFactory(Hints hints) {
        super(hints, 95);
    }

    private static Properties load() {
        File epsgFixtures;
        File home;
        Properties p = new Properties();
        File file = new File(CONFIGURATION_FILE);
        if (!(file.isFile() || (file = new File(home = new File(System.getProperty("user.home", ".")), CONFIGURATION_FILE)).isFile() || (file = new File(epsgFixtures = new File(new File(home, ".geotools"), "epsg"), "postgresql.properties")).isFile())) {
            return p;
        }
        try (FileInputStream in = new FileInputStream(file);){
            p.load(in);
        }
        catch (IOException exception) {
            Logging.unexpectedException((Logger)LOGGER, DataSource.class, (String)"<init>", (Throwable)exception);
        }
        return p;
    }

    protected DataSource createDataSource() throws SQLException {
        int portNumber;
        DataSource candidate = super.createDataSource();
        if (candidate instanceof BaseDataSource) {
            return candidate;
        }
        PGSimpleDataSource source = new PGSimpleDataSource();
        Properties p = ThreadedPostgreSQLEpsgFactory.load();
        try {
            portNumber = Integer.parseInt(p.getProperty("portNumber", "5432"));
        }
        catch (NumberFormatException exception) {
            portNumber = 5432;
            Logging.unexpectedException((Logger)LOGGER, DataSource.class, (String)"<init>", (Throwable)exception);
        }
        source.setPortNumbers(new int[]{portNumber});
        source.setServerNames(new String[]{p.getProperty("serverName", "localhost")});
        source.setDatabaseName(p.getProperty("databaseName", "EPSG"));
        source.setUser(p.getProperty("user", "Geotools"));
        source.setPassword(p.getProperty("password", "Geotools"));
        source.setProperty("stringtype", "unspecified");
        this.schema = p.getProperty("schema", null);
        return source;
    }

    protected AbstractAuthorityFactory createBackingStore(Hints hints) throws SQLException {
        FactoryUsingAnsiSQL factory = new FactoryUsingAnsiSQL(hints, this.getDataSource());
        factory.setValidationQuery("select now()");
        if (this.schema != null) {
            factory.setSchema(this.schema);
        }
        return factory;
    }
}

