/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.gen.info;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.geotools.data.gen.info.GeneralizationInfo;

public class GeneralizationInfos {
    private Map<String, GeneralizationInfo> infoMap = new HashMap<String, GeneralizationInfo>();
    private String dataSourceName;
    private String dataSourceNameSpace;

    public void addGeneralizationInfo(GeneralizationInfo info) {
        this.infoMap.put(info.getBaseFeatureName(), info);
    }

    public void removeGeneralizationInfo(GeneralizationInfo info) {
        this.infoMap.remove(info.getBaseFeatureName());
    }

    public GeneralizationInfo getGeneralizationInfoForBaseFeatureName(String baseFeatureName) {
        return this.infoMap.get(baseFeatureName);
    }

    public GeneralizationInfo getGeneralizationInfoForFeatureName(String featureName) {
        for (GeneralizationInfo info : this.infoMap.values()) {
            if (!info.getFeatureName().equals(featureName)) continue;
            return info;
        }
        return null;
    }

    public Collection<String> getBaseFeatureNames() {
        TreeSet<String> names = new TreeSet<String>();
        names.addAll(this.infoMap.keySet());
        return names;
    }

    public Collection<String> getFeatureNames() {
        TreeSet<String> names = new TreeSet<String>();
        for (GeneralizationInfo info : this.infoMap.values()) {
            names.add(info.getFeatureName());
        }
        return names;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public String getDataSourceNameSpace() {
        return this.dataSourceNameSpace;
    }

    public void setDataSourceNameSpace(String namespace) {
        this.dataSourceNameSpace = namespace;
    }

    public Collection<GeneralizationInfo> getGeneralizationInfoCollection() {
        return this.infoMap.values();
    }

    public void validate() throws IOException {
        for (GeneralizationInfo gi : this.getGeneralizationInfoCollection()) {
            gi.validate();
        }
    }
}

