/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.gen;

import java.awt.RenderingHints;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.Repository;
import org.geotools.data.gen.DSFinderRepository;
import org.geotools.data.gen.PreGeneralizedDataStore;
import org.geotools.data.gen.info.GeneralizationInfos;
import org.geotools.data.gen.info.GeneralizationInfosProvider;
import org.geotools.data.gen.info.GeneralizationInfosProviderImpl;

public class PreGeneralizedDataStoreFactory
implements DataStoreFactorySpi {
    public static final DataAccessFactory.Param REPOSITORY_CLASS = new DataAccessFactory.Param("RepositoryClassName", String.class, "Class name for data store repository implementation", true, (Object)DSFinderRepository.class.getName());
    public static final DataAccessFactory.Param GENERALIZATION_INFOS_PROVIDER_CLASS = new DataAccessFactory.Param("GeneralizationInfosProviderClassName", String.class, "Class name for GeneralizationInfosProvider implementation", true, (Object)GeneralizationInfosProviderImpl.class.getName());
    public static final DataAccessFactory.Param GENERALIZATION_INFOS_PROVIDER_PARAM = new DataAccessFactory.Param("GeneralizationInfosProviderParam", String.class, "Optional config parameter for GeneralizationInfosProvider implementation", false);
    public static final DataAccessFactory.Param NAMESPACEP = new DataAccessFactory.Param("namespace", URI.class, "uri to a the namespace", false);

    public DataStore createDataStore(Map<String, Serializable> params) throws IOException {
        String providerClassName = (String)GENERALIZATION_INFOS_PROVIDER_CLASS.lookUp(params);
        String repositoryClassName = (String)REPOSITORY_CLASS.lookUp(params);
        String providerParam = (String)GENERALIZATION_INFOS_PROVIDER_PARAM.lookUp(params);
        URI namespace = (URI)NAMESPACEP.lookUp(params);
        try {
            Class<?> providerClass = Class.forName(providerClassName);
            GeneralizationInfosProvider provider = (GeneralizationInfosProvider)providerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            GeneralizationInfos gInfos = provider.getGeneralizationInfos(providerParam);
            Class<?> repositoryClass = Class.forName(repositoryClassName);
            Repository repository = (Repository)repositoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return new PreGeneralizedDataStore(gInfos, repository, namespace);
        }
        catch (Exception ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public DataStore createNewDataStore(Map<String, Serializable> params) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean canProcess(Map<String, Serializable> params) {
        String repositoryClass = null;
        String providerClass = null;
        try {
            repositoryClass = (String)REPOSITORY_CLASS.lookUp(params);
            providerClass = (String)GENERALIZATION_INFOS_PROVIDER_CLASS.lookUp(params);
        }
        catch (IOException ex) {
            return false;
        }
        return repositoryClass != null && providerClass != null;
    }

    public String getDescription() {
        return "Data store supporting generalized geometries";
    }

    public String getDisplayName() {
        return "Generalizing data store";
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        return new DataAccessFactory.Param[]{REPOSITORY_CLASS, GENERALIZATION_INFOS_PROVIDER_CLASS, GENERALIZATION_INFOS_PROVIDER_PARAM, NAMESPACEP};
    }

    public boolean isAvailable() {
        return true;
    }

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return Collections.emptyMap();
    }
}

