/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.gen;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.data.FeatureReader;
import org.geotools.data.gen.PreGeneralizedSimpleFeature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class PreGeneralizedFeatureReader
implements FeatureReader<SimpleFeatureType, SimpleFeature> {
    protected SimpleFeatureType featureTyp;
    protected SimpleFeatureType returnedFeatureType;
    protected FeatureReader<SimpleFeatureType, SimpleFeature> backendReader;
    protected int[] indexMapping;
    protected String geomPropertyName;
    protected String backendGeomPropertyName;

    public PreGeneralizedFeatureReader(SimpleFeatureType featureTyp, SimpleFeatureType returnedFeatureType, int[] indexMapping, FeatureReader<SimpleFeatureType, SimpleFeature> backendReader, String geomPropertyName, String backendGeomPropertyName) {
        this.featureTyp = featureTyp;
        this.returnedFeatureType = returnedFeatureType;
        this.backendReader = backendReader;
        this.geomPropertyName = geomPropertyName;
        this.backendGeomPropertyName = backendGeomPropertyName;
        this.indexMapping = indexMapping;
    }

    public void close() throws IOException {
        this.backendReader.close();
    }

    public SimpleFeatureType getFeatureType() {
        return this.returnedFeatureType;
    }

    public boolean hasNext() throws IOException {
        return this.backendReader.hasNext();
    }

    public SimpleFeature next() throws IOException, IllegalArgumentException, NoSuchElementException {
        SimpleFeature next = (SimpleFeature)this.backendReader.next();
        if (next == null) {
            return null;
        }
        return new PreGeneralizedSimpleFeature(this.featureTyp, this.returnedFeatureType, this.indexMapping, next, this.geomPropertyName, this.backendGeomPropertyName);
    }
}

