/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.gen;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.geotools.api.feature.FeatureVisitor;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.util.ProgressListener;
import org.geotools.data.DataUtilities;
import org.geotools.data.gen.PreGeneralizedFeatureIterator;
import org.geotools.data.gen.PreGeneralizedSimpleFeature;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class PreGeneralizedFeatureCollection
implements SimpleFeatureCollection {
    protected SimpleFeatureCollection backendCollection;
    protected SimpleFeatureType featureType;
    protected SimpleFeatureType returnedFeatureType;
    protected String geomPropertyName;
    protected String backendGeomPropertyName;
    protected int[] indexMapping;

    public PreGeneralizedFeatureCollection(SimpleFeatureCollection backendCollection, SimpleFeatureType featureType, SimpleFeatureType returnedFeatureType, int[] indexMapping, String geomPropertyName, String backendGeomPropertyName) {
        this.backendCollection = backendCollection;
        this.featureType = featureType;
        this.returnedFeatureType = returnedFeatureType;
        this.geomPropertyName = geomPropertyName;
        this.backendGeomPropertyName = backendGeomPropertyName;
        this.indexMapping = indexMapping;
    }

    public void accepts(FeatureVisitor visitor, ProgressListener progress) throws IOException {
        DataUtilities.visit((FeatureCollection)this, (FeatureVisitor)visitor, (ProgressListener)progress);
    }

    public boolean contains(Object feature) {
        if (feature instanceof PreGeneralizedSimpleFeature) {
            return this.backendCollection.contains((Object)((PreGeneralizedSimpleFeature)feature).feature);
        }
        return this.backendCollection.contains(feature);
    }

    public boolean containsAll(Collection coll) {
        ArrayList<Object> searchColl = new ArrayList<Object>();
        for (Object feature : coll) {
            if (feature instanceof PreGeneralizedSimpleFeature) {
                searchColl.add(((PreGeneralizedSimpleFeature)feature).feature);
                continue;
            }
            searchColl.add(feature);
        }
        return this.backendCollection.containsAll(searchColl);
    }

    public SimpleFeatureIterator features() {
        return new PreGeneralizedFeatureIterator(this.backendCollection.features(), this.featureType, this.returnedFeatureType, this.indexMapping, this.geomPropertyName, this.backendGeomPropertyName);
    }

    public ReferencedEnvelope getBounds() {
        return this.backendCollection.getBounds();
    }

    public String getID() {
        return "pregeneralizd featurecollection";
    }

    public SimpleFeatureType getSchema() {
        return this.returnedFeatureType;
    }

    public boolean isEmpty() {
        return this.backendCollection.isEmpty();
    }

    public int size() {
        return this.backendCollection.size();
    }

    public SimpleFeatureCollection sort(SortBy sortBy) {
        SimpleFeatureCollection fColl = this.backendCollection.sort(sortBy);
        if (fColl == null) {
            return null;
        }
        return new PreGeneralizedFeatureCollection(fColl, this.featureType, this.returnedFeatureType, this.indexMapping, this.geomPropertyName, this.backendGeomPropertyName);
    }

    public SimpleFeatureCollection subCollection(Filter filter) {
        SimpleFeatureCollection fColl = this.backendCollection.subCollection(filter);
        if (fColl == null) {
            return null;
        }
        return new PreGeneralizedFeatureCollection(fColl, this.featureType, this.returnedFeatureType, this.indexMapping, this.geomPropertyName, this.backendGeomPropertyName);
    }

    public Object[] toArray() {
        Object[] res = this.backendCollection.toArray();
        for (int i = 0; i < res.length; ++i) {
            res[i] = new PreGeneralizedSimpleFeature(this.getSchema(), this.getSchema(), this.indexMapping, (SimpleFeature)res[i], this.geomPropertyName, this.backendGeomPropertyName);
        }
        return res;
    }

    public <O> O[] toArray(O[] a) {
        Object[] res = this.backendCollection.toArray((Object[])a);
        for (int i = 0; i < res.length; ++i) {
            PreGeneralizedSimpleFeature cast = new PreGeneralizedSimpleFeature(this.getSchema(), this.getSchema(), this.indexMapping, (SimpleFeature)res[i], this.geomPropertyName, this.backendGeomPropertyName);
            res[i] = cast;
        }
        return res;
    }
}

