/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.flatgeobuf;

import com.google.common.io.LittleEndianDataInputStream;
import com.google.flatbuffers.FlatBufferBuilder;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.util.NIOUtilities;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.wololo.flatgeobuf.ColumnMeta;
import org.wololo.flatgeobuf.GeometryConversions;
import org.wololo.flatgeobuf.HeaderMeta;
import org.wololo.flatgeobuf.generated.Feature;

public class FeatureConversions {
    private static void writeString(ByteBuffer target, String value) {
        CharsetEncoder encoder = StandardCharsets.UTF_8.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        int lengthPosition = target.position();
        target.position(lengthPosition + 4);
        int startStrPos = target.position();
        boolean endOfInput = true;
        encoder.encode(CharBuffer.wrap(value), target, true);
        int endStrPos = target.position();
        int encodedLength = endStrPos - startStrPos;
        target.putInt(lengthPosition, encodedLength);
    }

    public static void serialize(SimpleFeature feature, HeaderMeta headerMeta, OutputStream to, FlatBufferBuilder builder) throws IOException {
        int propertiesOffset = FeatureConversions.createProperiesVector(feature, builder, headerMeta);
        Geometry geometry = (Geometry)feature.getDefaultGeometry();
        int geometryOffset = geometry == null ? 0 : GeometryConversions.serialize((FlatBufferBuilder)builder, (Geometry)geometry, (byte)headerMeta.geometryType);
        int featureOffset = Feature.createFeature((FlatBufferBuilder)builder, (int)geometryOffset, (int)propertiesOffset, (int)0);
        builder.finishSizePrefixed(featureOffset);
        WritableByteChannel channel = Channels.newChannel(to);
        ByteBuffer dataBuffer = builder.dataBuffer();
        while (dataBuffer.hasRemaining()) {
            channel.write(dataBuffer);
        }
    }

    protected static int buildGeometry(SimpleFeature feature, FlatBufferBuilder builder, byte geometryType) throws IOException {
        Geometry geometry = (Geometry)feature.getDefaultGeometry();
        int geometryOffset = GeometryConversions.serialize((FlatBufferBuilder)builder, (Geometry)geometry, (byte)geometryType);
        return geometryOffset;
    }

    private static int createProperiesVector(SimpleFeature feature, FlatBufferBuilder builder, HeaderMeta headerMeta) {
        int minPow = 16;
        int maxPow = 20;
        int size = 0;
        for (int pow = 16; pow <= 20; pow += 2) {
            size = (int)Math.pow(2.0, pow);
            ByteBuffer bb = NIOUtilities.allocate((int)size);
            try {
                FeatureConversions.buildPropertiesVector(feature, headerMeta, bb);
            }
            catch (BufferOverflowException overflow) {
                NIOUtilities.returnToCache((ByteBuffer)bb);
                continue;
            }
            int propertiesOffset = 0;
            if (bb.position() > 0) {
                bb.flip();
                propertiesOffset = Feature.createPropertiesVector((FlatBufferBuilder)builder, (ByteBuffer)bb);
            }
            NIOUtilities.returnToCache((ByteBuffer)bb);
            return propertiesOffset;
        }
        throw new IllegalStateException("Unable to write properties vector of feature " + feature.getID() + ". Buffer overflowed at maximum capacity of " + size + " bytes");
    }

    private static void buildPropertiesVector(SimpleFeature feature, HeaderMeta headerMeta, ByteBuffer target) {
        target.order(ByteOrder.LITTLE_ENDIAN);
        for (short i = 0; i < headerMeta.columns.size(); i = (short)(i + 1)) {
            ColumnMeta column = (ColumnMeta)headerMeta.columns.get(i);
            byte type = column.type;
            Object value = feature.getAttribute(column.name);
            if (value == null) continue;
            target.putShort(i);
            if (type == 2) {
                target.put((byte)((Boolean)value != false ? 1 : 0));
                continue;
            }
            if (type == 0) {
                target.put((Byte)value);
                continue;
            }
            if (type == 3) {
                target.putShort((Short)value);
                continue;
            }
            if (type == 5) {
                target.putInt((Integer)value);
                continue;
            }
            if (type == 7) {
                if (value instanceof Long) {
                    target.putLong((Long)value);
                    continue;
                }
                if (value instanceof BigInteger) {
                    target.putLong(((BigInteger)value).longValue());
                    continue;
                }
                target.putLong((Long)value);
                continue;
            }
            if (type == 10) {
                if (value instanceof Double) {
                    target.putDouble((Double)value);
                    continue;
                }
                if (value instanceof BigDecimal) {
                    target.putDouble(((BigDecimal)value).doubleValue());
                    continue;
                }
                target.putDouble((Double)value);
                continue;
            }
            if (type == 13) {
                String isoDateTime = "";
                if (value instanceof LocalDateTime) {
                    isoDateTime = ((LocalDateTime)value).toString();
                } else if (value instanceof LocalDate) {
                    isoDateTime = ((LocalDate)value).toString();
                } else if (value instanceof LocalTime) {
                    isoDateTime = ((LocalTime)value).toString();
                } else if (value instanceof OffsetDateTime) {
                    isoDateTime = ((OffsetDateTime)value).toString();
                } else if (value instanceof OffsetTime) {
                    isoDateTime = ((OffsetTime)value).toString();
                } else if (value instanceof Date) {
                    isoDateTime = ((Date)value).toString();
                } else if (value instanceof Time) {
                    isoDateTime = ((Time)value).toString();
                } else if (value instanceof Timestamp) {
                    isoDateTime = ((Timestamp)value).toString();
                } else {
                    throw new RuntimeException("Cannot handle datetime type " + value.getClass().getName());
                }
                FeatureConversions.writeString(target, isoDateTime);
                continue;
            }
            if (type == 11) {
                FeatureConversions.writeString(target, (String)value);
                continue;
            }
            throw new RuntimeException("Cannot handle type " + value.getClass().getName());
        }
    }

    private static String readString(ByteBuffer bb, String name) {
        int length = bb.getInt();
        byte[] stringBytes = new byte[length];
        bb.get(stringBytes, 0, length);
        String value = new String(stringBytes, StandardCharsets.UTF_8);
        return value;
    }

    public static SimpleFeature deserialize(LittleEndianDataInputStream data, SimpleFeatureBuilder fb, HeaderMeta headerMeta, long fid) throws IOException {
        int featureSize = data.readInt();
        SimpleFeature feature = FeatureConversions.deserialize(data, fb, headerMeta, fid, featureSize);
        return feature;
    }

    public static SimpleFeature deserialize(LittleEndianDataInputStream data, SimpleFeatureBuilder fb, HeaderMeta headerMeta, long fid, int featureSize) throws IOException {
        byte[] bytes = new byte[featureSize];
        data.readFully(bytes);
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        Feature f = Feature.getRootAsFeature((ByteBuffer)bb);
        SimpleFeature feature = FeatureConversions.deserialize(f, fb, headerMeta, fid);
        return feature;
    }

    public static SimpleFeature deserialize(Feature feature, SimpleFeatureBuilder fb, HeaderMeta headerMeta, long fid) {
        int propertiesLength;
        org.wololo.flatgeobuf.generated.Geometry geometry = feature.geometry();
        byte geometryType = headerMeta.geometryType;
        if (geometry != null) {
            if (geometryType == 0) {
                geometryType = (byte)geometry.type();
            }
            Geometry jtsGeometry = GeometryConversions.deserialize((org.wololo.flatgeobuf.generated.Geometry)geometry, (int)geometryType);
            fb.add((Object)jtsGeometry);
        }
        if ((propertiesLength = feature.propertiesLength()) > 0) {
            ByteBuffer bb = feature.propertiesAsByteBuffer();
            while (bb.hasRemaining()) {
                short i = bb.getShort();
                ColumnMeta columnMeta = (ColumnMeta)headerMeta.columns.get(i);
                String name = columnMeta.name;
                byte type = columnMeta.type;
                if (type == 2) {
                    fb.set(name, (Object)(bb.get() > 0 ? 1 : 0));
                    continue;
                }
                if (type == 0) {
                    fb.set(name, (Object)bb.get());
                    continue;
                }
                if (type == 3) {
                    fb.set(name, (Object)bb.getShort());
                    continue;
                }
                if (type == 5) {
                    fb.set(name, (Object)bb.getInt());
                    continue;
                }
                if (type == 7) {
                    fb.set(name, (Object)bb.getLong());
                    continue;
                }
                if (type == 10) {
                    fb.set(name, (Object)bb.getDouble());
                    continue;
                }
                if (type == 13) {
                    fb.set(name, (Object)FeatureConversions.readString(bb, name));
                    continue;
                }
                if (type == 11) {
                    fb.set(name, (Object)FeatureConversions.readString(bb, name));
                    continue;
                }
                throw new RuntimeException("Unknown type");
            }
        }
        SimpleFeature f = fb.buildFeature(fb.getFeatureType().getTypeName() + "." + fid);
        return f;
    }
}

